#|
*******************************************************************************
PRODIGY Version 2.0  
Copyright 1989 by Steven Minton, Craig Knoblock, Dan Kuokka and Jaime Carbonell

The PRODIGY System was designed and built by Steven Minton, Craig Knoblock,
Dan Kuokka and Jaime Carbonell.  Additional contributors include Henrik Nordin,
Yolanda Gil, Manuela Veloso, Robert Joseph, Santiago Rementeria, Alicia Perez, 
Ellen Riloff, Michael Miller, and Dan Kahn.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#



(proclaim '(special *STATE* *INFERENCES-ONLY* *CLOSED-PREDS* *CAND-NODES*
                    *MATCH-COUNT* *META-FUNCTIONS* *FINISH* *ALL-NODES*
		    *CACHED-CANDS* *CURRENT-NODE* *OPERATORS* *INFERENCE-RULES*
		    *EBL-FLAG* n2 *STANDAR-META-FNS*))


(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types"))



; -------------------- META-LEVEL-CONSTRUCTS  --------------------------

; These functions are for use in control rules.

(defvar *STANDARD-META-FNS*
    '(known provable achievable current-goal is-first-goal adjunct-goal
	    current-op current-goal  is-equal not-equal high-on-goal-stack
	    candidate-bindings candidate-op previous-state-diff 
            on-goal-stack alt-on-deck was-added was-deleted protected-goal
	    candidate-goal list-of-candidate-goals is-top-level-node
	    direct-supergoal-of has-bound-vars not-top-level-node 
	    in-goal-exp is-top-level-goal is-bound candidate-node current-node
            node-pref-not-cached primary-candidate-node primary-candidate-goal
	    applied-operator applied-inference was-deleted-by predicate
	    is-start-node not-start-node below-depth-limit shallower))

(setf *META-FUNCTIONS* (copy-list *STANDARD-META-FNS*))

; NOTE: meta-functions are just like domain functions. They return
; NIL if the exp doesn't match, T if the exp is matches and doesn't 
; have any variables, or a list of binding-lists if the
; exp matches and has variables. 

(defun not-equal (a b)
    (cond ((or (is-variable a)
	       (is-variable b))
	   (error "NOT-EQUAL: both args must be constants"))
	  ((not (equal a b)))))

 
(defun is-bound (v)
  (not (is-variable v)))


(defun is-equal (a b)
  (cond ((and (is-variable a)
	      (is-variable b))
	 (error "IS-EQUAL: both args cant be variables"))
	((is-variable a)
	 (list (list (list a b))))
	((is-variable b)
	 (list (list (list b a))))
	((and (listp a)
	      (listp b))
	 (cond ((has-any-vars a)
		(cond ((has-any-vars b)
		       (cond (*EBL-FLAG*
			      (format 
			       t "~%Warning, IS-EQUAL: both args have variables~a" (list a b))
			      (let ((result (lst-match a b)))
				(if result (list result))))
			     (t (error "IS-EQUAL: both args cant be variables"))))
		      (t (let ((result (lst-match a b)))
			   (and result (list result))))))
	       ((has-any-vars b)
		(let ((result (lst-match b a)))
		  (and result (list result))))
	       (t (equal a b))))
	(t (equal a b))))


(defun candidate-node (n)
     (cond ((is-variable n)
	    (g-map (node in *CAND-NODES*)
                   (save (list (list n node)))))
	   ((member n *CAND-NODES*) t)
	   (t nil)))
   
; the default candidate-node (chosen by default if no prefs apply)

(defun primary-candidate-node (n)
     (cond ((is-variable n)
	    (list (list (list n (car *CAND-NODES*)))))
	   ((equal n (car *CAND-NODES*)))))

;  used to speed up node-pref control rules. Makes sure you only get
;  new preferences, those having to do with a new goal...

(defun node-pref-not-cached (n1 n2)
    (cond  ((and (or (not (latest-node-pref n2))
		     (created-later-than n1 (latest-node-pref n2)))
		 (not (equal n1 n2)))
	    t)
	   (t 
	    (setq *CACHED-CANDS* t)
	    nil)))

(defun latest-node-pref (n)
   (get (node-name n) 'latest-node-pref))

(defun set-latest-node-pref (n latest-node)
    (setf (get (node-name n) 'latest-node-pref) latest-node))


(defun created-later-than (n1 n2)
    (member n2 (cdr (member n1 *all-nodes*))))

(defun current-node (n)
    (cond ((is-variable n)
	   (list (list (list n *CURRENT-NODE*))))
	  ((equal n *CURRENT-NODE*))))


(defun not-start-node (n)
    (cond ((is-variable n)
	   (error "Function not-start-node called with a variable arg."))
	  ((not (eq 'start-goal (alt-goal (node-generating-alt n)))))))

(defun is-start-node (n)
    (cond ((is-variable n)
	   (error "Function is-start-node called with a variable arg."))
	  ((eq 'start-goal (alt-goal (node-generating-alt n))))))

(defun not-top-level-node (n)
    (cond ((is-variable n)
	   (error "Function not-top-level-node called with a variable arg."))
	  ((and (not (eq 'n1 (node-name n)))
		(not 
		 (and (node-parent n)
		      (eq 'n1 (node-name (leftmost-clone (node-parent n))))))
		(or (null *ABSTRACTION-LEVEL*)
		    (not (or (node-top-level-goals n)
			     (and (node-parent n)
				  (node-top-level-goals 
				   (leftmost-clone (node-parent n))))))))
	   t)))


(defun is-top-level-node (n)
    (cond ((is-variable n) 
	   (error "IS-TOP-LEVEL-NODE: node cannot be a variable"))
	  ((eq 'n1 (node-name n)) t) ; need test otherwise parent is nil
	  ((and (node-parent n)
		(eq 'n1 (node-name (leftmost-clone (node-parent n))))))
	  ((and *ABSTRACTION-LEVEL*
		(or (node-top-level-goals n)
		    (and (node-parent n)
			 (node-top-level-goals 
			  (leftmost-clone (node-parent n)))))))))


(defun predicate (x y)
    (cond ((is-variable x)
	   (cond ((is-variable y)
		  (error "PREDICATE: can't both be vars"))
		 ((list (list (list x (car y)))))))
	  ((is-variable y)
	   (error "PREDICTATE: 2nd arg can't be variable"))
	  ((equal x (car y)))))

(defun list-of-candidate-goals (node goals)
    (cond ((is-variable node) 
           (error "LIST-OF-CANDIDATE-GOALS: node cannot be a variable"))
	  ((list (list (list goals (node-candidate-goals node)))))))

    
(defun is-first-goal (goal goals)
    (cond ((is-variable goals) 
           (error "IS-FIRST-GOAL: goals cannot be a variable"))
	  ((is-variable goal)
	   (list (list (list goal (car goals)))))
	  (t (equal goal (car goals)))))
   

(defun which-is-parent (possible-parents n)
    (g-loop (while (setq n (node-parent n)))
	     (do (and (member n possible-parents)
		      (return (car (member n possible-parents)))))
	     (result (error "which-is-parent: parent not found"))))
	   
; g is assumed to be closed world

(defun protected-goal (n g)
    (cond ((is-variable n) (error "PROTECTED-GOAL: node cant be variable"))
	  ((null n) nil)
	  ((is-variable g)
	   (g-loop (init ret-val nil)
		   (next n (cond ((left-clone n))
				 ((node-parent n))))
		   (while n)
		   (do (and (node-applied-node n)
			    (push (list (list g (alt-goal (node-generating-alt n))))
				  ret-val)))
		   (result ret-val)))
	  ((has-vars g)
	   (g-loop (init ret-val nil bindings nil)
		   (next n (cond ((left-clone n))
				 ((node-parent n))))
		   (while n)
		   (do (and (node-applied-node n)
			    (setq bindings 
				  (lit-match3 g (alt-goal 
						    (node-generating-alt n))))
			    (push bindings ret-val)))
		   (result ret-val)))
	  ((g-loop (next n (cond ((left-clone n))
				 ((node-parent n))))
		   (while n) ; slight order change in cl conversion
		   (do (and (node-applied-node n)
			    (equal g (alt-goal (node-generating-alt n)))
			    (return t)))))))


(defun was-added (node lit)
    (cond ((or (is-variable node) (is-variable lit))
	   (error "WAS-ADDED, cant have variable node or lit"))
	  ((has-vars lit)
	   (g-loop (init bindings nil ret-val nil
			 lits (cond ((negated-p lit)
				     (state-false-assertions (node-state node)))
				    ((state-true-assertions 
					 (node-state node)))))
		   (while lits)
		   (do (and (setq bindings (lit-match3 lit (car lits)))
			    (was-added-above node (car lits))
			    (push bindings ret-val)))
		   (next lits (cdr lits))
		   (result ret-val)))
	  ((and (member lit (cond ((negated-p lit)
				   (state-false-assertions (node-state node)))
				  ((state-true-assertions (node-state node))))
			:test #'equal)
		(was-added-above node lit))
	   t)))


(defun was-added-above (n lit)
    (g-loop (init parent (node-parent n) 
		  is-inference (not (closed-predicate lit)))
	    (while parent)
	    (do (and (or is-inference (node-applied-node n))
		     (not (member lit 
				  (cond ((negated-p lit)
					 (state-false-assertions 
					     (node-state parent)))
					((state-true-assertions
					     (node-state parent))))
				  :test #'equal))
		     (return t)))
	    (next n (node-parent n)
	          parent (node-parent parent))))
	  
(defun was-deleted (node lit)
    (cond ((or (is-variable node) (is-variable lit))
	   (error "WAS-DELETED, cant have variable node or lit"))
	  ((has-vars lit) (error "Was-deleted: vars in lit: ~A" lit))
	  ((not (closed-predicate lit)) nil)
	  ((not (member lit (state-closed-world (node-state node)) :test #'equal))
	   (and (was-deleted-above node lit) t))
	  ((was-deleted-above (find-where-lit-absent node lit) lit)
	   t)))

; assume lit it is present in node

(defun find-where-lit-absent (node lit)
    (g-loop (while node)
	    (do (and (or (node-applied-node node)
			 (eq node n2))
		     (not (member lit (state-closed-world 
					  (node-state (node-parent node)))
				  :test #'equal))
		     (return node)))
	    (until (eq node n2))
	    (next node (node-parent node))))


			     
; assume lit it is absent in n, returns node under which deletion occurred

(defun was-deleted-above (n lit)
    (g-loop (while n)
	    (do (and (or (node-applied-node n)
			 (eq n n2))
		     (member lit (state-closed-world 
				     (node-state (node-parent n)))
			     :test #'equal)
		     (return n)))
	    (until (eq n n2))
	    (next n (node-parent n))))



(defun current-op (node op)
      (cond ((is-variable node) 
             (error "CURRENT-OP: node cannot be a variable"))
	    ((is-variable op)
	     (list (list (list op (node-current-op node)))))
	    (t (equal op (node-current-op node)))))

 
(defun candidate-op (node op)
    (cond ((is-variable node) 
           (error "CANDIDATE-OP: node cannot be a variable"))
	  ((is-variable op)
	   (mapcar #'(lambda (cop)
			     (list (list op cop)))
		   (node-candidate-ops node)))
	  ((member op (node-candidate-ops node))
	   t)))


(defun candidate-goal (node g)
    ; first make sure cand-goals have been initialized. Necessary if
    ; this function is called during node decisions. (eg. by node-rej rules).
    (if (not (node-candidate-goals node)) 
	(setf (node-candidate-goals node) 
	      (alt-unmatched-conds (node-generating-alt node))))
    (cond ((is-variable node)
	   (error "CANDIDATE-GOAL: node cannot be a variable"))
	  ((is-variable g)
	   (mapcar #'(lambda (uc) (list (list g uc)))
		   (node-candidate-goals node)))
	  ((listp g)
	   (mapcan #'(lambda (uc) (let ((val (lst-match g uc)))
				       (cond (val (list val))
					     (t nil))))
		   (node-candidate-goals node)))))

; just looks at the first candidate goal
(defun primary-candidate-goal (node g)
 ; first make sure cand-goals have been initialized. Necessary if
 ; this function is called during node decisions. (eg. by node-rej rules).
  (if (not (node-candidate-goals node)) 
      (cond ((node-reset-alt node)
	     (setf (node-candidate-goals node) 
		   (list (alt-goal (node-reset-alt node)))))
	    (t (setf (node-candidate-goals node) 
		     (alt-unmatched-conds (node-generating-alt node))))))
  (cond ((is-variable node)
	 (error "CANDIDATE-GOAL: node cannot be a variable"))
        ((and *EBL-FLAG*
	      (is-top-level-node node)) 
	 nil)
	((is-variable g)
	 (list (list (list g (car (node-candidate-goals node))))))
	((listp g)
	 (let ((val (lst-match g (car (node-candidate-goals node)))))
	   (cond (val (list val))
		 (t nil))))))
		   

;  just used internally by learning system, taking advantage of
; the fact that on-goal-stack doesn't look in the alt.

(defun high-on-goal-stack (n g)
    (on-goal-stack n g))

(defun on-goal-stack (n super)
    (cond ((is-variable n) 
           (error "ON-GOAL-STACK: node cannot be a variable"))
	  ((is-variable super)
	   (mapcar #'(lambda (g) (list (list super g)))
		   (node-goal-stack n)))
	  ((listp super)
	   (mapcan #'(lambda (g) (let ((val (lst-match super g)))
				      (cond (val (list val))
					    (t nil))))
		   (node-goal-stack n)))))
 
; NOTE: we assume sub is instantiated !

(defun direct-supergoal-of (node sub super)
    (cond ((is-variable node) 
           (error "DIRECT-SUPERGOAL-OF: node cannot be a variable"))
	  ((is-variable sub) 
	   (error "DIRECT-SUPERGOAL-OF: subgoal cannot be a variable"))
	  ((is-variable super)
	   (list (list (list super (car (node-goal-stack node))))))
	  ((not (listp super)) 
	   (error "DIRECT-SUPERGOAL-OF: supergoal is not a list"))
	  ((member sub (alt-unmatched-conds (node-generating-alt node))
		   :test #'equal)
	   (let ((result (lst-match super (car (node-goal-stack node)))))
		(and result (list result))))
	  ((g-loop (init goals (node-goal-stack node)
		          results nil temp nil)
	            (while (setq goals (member sub goals :test #'equal)))
		    (do (setq temp (lst-match super (cadr goals)))
			(and temp (push temp results))
			(pop goals))
		    (result results)))))

(defun is-top-level-goal (node goal)
    (adjunct-goal node goal))

(defun in-goal-exp (node goal)
    (let ((goal-exp (op-preconds '*FINISH*))
	  top-goals)
	 (cond ((is-variable node) (error "in-goal-exp node is variable"))
	       ((eq (car goal-exp) 'and)
		(setq top-goals (cdr goal-exp)))
	       ((is-literal goal-exp)
		(setq top-goals (list goal-exp)))
	       ((error "in-goal-exp ?? impl")))
	 (cond ((is-variable goal)
		(g-map (g in top-goals)
		      (save (list (list goal g)))))
	       ((g-loop (init bindings nil ret-val nil)
		      (while top-goals)
		      (do (and (setq bindings (lit-match goal (car top-goals)))
			       (push bindings ret-val)))
		      (next top-goals (cdr top-goals))
		      (result ret-val))))))

; hack, used only by learning stuff currently
; may want to make this filter out the 

; does not include direct supergoal of node
;  (and (not (equal (cadr (get node 'goal-stack)) g)) 

; assume node is not a variable...
(defun adjunct-goal (node goal)
    (let ((goal-exp (op-preconds '*FINISH*))
	  (state (node-state node))
	  top-goals)
	 (cond ((is-variable node) (error "adjunct-goal: node is variable"))
	       ((eq (car goal-exp) 'and)
		(setq top-goals 
		      (g-map (g in (cdr goal-exp))
			    (when (not (exp-match g '((nil nil)) state)))
			    (save g))))
	       ((is-literal goal-exp)
		(setq top-goals (and (not (exp-match goal-exp '((nil nil)) state))
				     (list goal-exp))))
	       ((error "adjunct-goal: condition nyet impl")))
	 (cond ((is-variable goal)
		(g-map (g in top-goals)
		      (save (list (list goal g)))))
	       ((g-loop (init bindings nil ret-val nil)
		      (while top-goals)
		      (do (and (setq bindings (lit-match goal (car top-goals)))
			       (push bindings ret-val)))
		      (next top-goals (cdr top-goals))
		      (result ret-val))))))
	     

(defun current-goal (node goal)
      (cond ((is-variable node) 
             (error "CURRENT-GOAL: node cannot be a variable"))
	    ((is-variable goal)
	     (list (list (list goal (node-current-goal node)))))
	    ((listp goal)
	     (let ((result-b (lst-match goal (node-current-goal node))))
		  (and result-b (list result-b))))))



(defun candidate-bindings (node vals-list)
  (cond ((is-variable node)
	 (error "CANDIDATE-BINDINGS: node must be bound"))
	((is-variable vals-list)
	 (error "CANDIDATE-BINDINGS: vals-list must be bound"))
	((listp vals-list)
	 (remove-duplicates
	  (g-map (cand in (node-candidate-bindings node))
		 (filter (constant-tst (lst-match vals-list cand))))
	  :test #'equal))
	(t (error "CANDIDATE-BINDINGS: vals-list is not a list"))))

; if during EBL, makes sure that any variable in the bindings list that
; has an & in its name is actually bound (i.e., bound to a constant not 
; a variable).  This is because learned rules expect these guys to be bound!
; (Maybe we should do this for all rules, regardless of learning?)

(defun constant-tst (bindings)
  (cond ((and *EBL-FLAG*
	      (some #'(lambda (pair)
			(and (is-variable (car pair))
			     (eql #\& (elt (prin1-to-string (car pair)) 1))
			     (is-variable (cadr pair))))
		    bindings))
	 nil)
	(t bindings)))

; slst comes from the alt spec, olst comes from the cand-bindings
;  should be put in matcher

(defun lst-match (slst olst)
    (cond ((negated-p slst)
	   (and (negated-p olst)
		(lst-match (cadr slst) (cadr olst))))
	  ((g-loop (init bindings nil)
	            (while slst)
		    (do (cond ((is-variable (car slst))
			       (cond ;((is-variable (car olst)))
				               ; both vars,relax
			              ((assoc (car slst) bindings)
				       (or (equal (cadr (assoc (car slst) 
							      bindings))
						  (car olst))
					   (return)))
				      (t (push (list (car slst) (car olst))
					       bindings))))
			      ((not (equal (car slst) (car olst)))
			       (return)))) 	; return if constant - var
		    (next slst (cdr slst) olst (cdr olst))
		    (result (or bindings '((nil nil))))))))
		    
;  --------------------------------------------------------------

;  stuff for previous-state diff 

(defun previous-state-diff (n diffs)
    (cond ((is-variable n) 
           (error "PREVIOUS-STATE-DIFF: node cannot be a variable"))
	  ((find-all-vars diffs) ; has vars
	   (g-loop (init cstate (state-closed-world (node-state n)) 
			  bindings nil)
	            (while n)
		    (do (and (node-applied-node n)
			     (operator-p (alt-op (node-generating-alt n)))
			     (setq bindings 
				   (diff-match diffs
				       (get-actual-diffs cstate
					   (state-closed-world 
					      (node-state (node-parent n))))))
			     (return (list bindings))))
		    (next n (node-parent n))))
	  ((g-loop (init state (state-closed-world (node-state n))
                         adds (sort (get-adds-from-diffs diffs) 'alphalessp-f)
			 dels (sort (get-dels-from-diffs diffs) 'alphalessp-f)
			 repeat-state nil)
	            (before-starting (cond ((are-in-state dels state)
					    (setq repeat-state 
			                      (change-state adds dels state)))
					   (t (return nil))))
		    (while n)
		    (do (cond ((and (node-applied-node n)
				    (operator-p
					 (alt-op (node-generating-alt n)))
				    (equal repeat-state
					   (state-closed-world
					      (node-state (node-parent  n)))))
			       (return t))))
		    (next n (node-parent n))))))


(defun are-in-state (dels s)
    (cond ((null dels) t)
	  ((member (car dels) s :test #'equal)
	   (are-in-state (cdr dels) s))
	  (t nil)))

(defun diff-match (diffs actuals)
	(r-diff-match diffs actuals '((nil nil))))

(defun r-diff-match (diffs orig-actuals orig-bindings)
   (and (eql (length orig-actuals) (length diffs))
	(g-loop (init actual nil bindings nil actuals orig-actuals)
 	        (before-starting (cond ((null orig-actuals) (return orig-bindings))))
		(while (setq actual (pop actuals)))
		(do (and (setq bindings (lit-match2 (car diffs) actual
					 orig-bindings))
 		         (setq bindings (r-diff-match (cdr diffs)
					    (del-eq actual orig-actuals) bindings))
			 (return bindings))))))


(defun get-actual-diffs (cs ns)
    (cond ((null cs)
	   (cond ((null ns) nil)  
		 ((cons (negate (car ns)) (get-actual-diffs cs (cdr ns))))))
	  ((null ns) ;  could be more efficient but this way we get a copy
	   (cons (car cs) (get-actual-diffs (cdr cs) ns)))
	  ((equal (car cs) (car ns))
	   (get-actual-diffs (cdr cs) (cdr ns)))
	  ((alphalessp-f (car cs) (car ns))
	   (cons (car cs) (get-actual-diffs (cdr cs) ns)))
	  ((cons (negate (car ns)) (get-actual-diffs cs (cdr ns))))))


(defun get-adds-from-diffs (diffs)
    (cond ((null diffs) nil)
	  ((negated-p (car diffs))
	   (cons (cadar diffs)
		 (get-adds-from-diffs (cdr diffs))))
	  ((get-adds-from-diffs (cdr diffs)))))


 (defun get-dels-from-diffs (diffs)
    (cond ((null diffs) nil)
	  ((not (eq (caar diffs) '~))
	   (cons (car diffs)
		 (get-dels-from-diffs (cdr diffs))))
	  ((get-dels-from-diffs (cdr diffs)))))

(defun alt-on-deck (n g op)
    (cond ((or (is-variable n)
	       (is-variable g)
	       (is-variable op))
	   (error "ERROR: alt-on-deck has a variable!"))
	  ((r-alt-on-deck n g op))))

;  should really use generating alt

;  expect goal to be an atomic form, op to be constant, and node a constant

;  can be the current reset alt, or anybody above
(defun r-alt-on-deck (n g op)
    (g-loop (init alt (node-reset-alt n) bindings nil)
	    (while n)
	    (do (and alt
		     (eq op (alt-op alt))
		     (setq bindings (lit-match g (alt-goal alt)))))
  	    (until bindings)			  
	    (next alt (node-generating-alt (leftmost-clone n))
		  n (v-pre-parent n))
  	    (result (and bindings (list bindings)))))

;  returns list of bound vars

(defun has-bound-vars (n g op bvars)
    (cond ((or (is-variable n)
	       (is-variable g)
	       (is-variable op))
	       (not (is-variable bvars))
	       (error "ERROR: has-bound-vars has a variable or bvars is not a var!"))
	  ((r-has-bound-vars n g op bvars))))
       	
; bvars must be a list

(defun r-has-bound-vars (n g op bvars)
    (g-loop (init alt (node-reset-alt n) bindings nil)
	    (while n)
	    (do (and alt
		     (eq op (alt-op alt))
		     (setq bindings (lit-match g (alt-goal alt)))))
	    (until bindings)			  
	    (next alt (node-generating-alt (leftmost-clone n))
		  n (v-pre-parent n))
	    (result (if bindings 
		        (list (new-bvar-bindings bvars alt bindings))))))



(defun new-bvar-bindings (bvars alt bindings)
  (g-loop (init r-alt-vals (alt-vars alt))
	  (while bvars)
	  (do (and (car bvars)
		   (not (assoc (car bvars) bindings))
		   (push (list (car bvars) (car r-alt-vals)) bindings)))
	  (next bvars (cdr bvars)
	        r-alt-vals (cdr r-alt-vals))
	  (result bindings)))


;  ------------------------------------------------------------------


; KNOWN checks if exp is known to be true in *STATE* of CURRENT-NODE.
; returns a list of binding lists, as do other meta-functions, or t

(defun known (node exp)
    (let ((old-state *STATE*) result)
	 (setq *STATE* (node-state node))
	 (setq result (descend-match exp '((nil nil)) 'all))
	 (cond ((equal result '(((nil nil))))
	        (setq result t)))
	 (setq *STATE* old-state)
	 result))


(defun initialize-recur-start-node (current-node)
    (prog (start-node start-state)
	  (setq start-node (get-new-node))
	  (setq start-state (make-new-state-nm))
	  (setf (node-generating-alt start-node)
		(list 'recur-goal 'recur-op '((done)) nil nil))
	  (set-closed-world start-state 
  	        (state-closed-world (node-state current-node)))
	  (set-true-assertions start-state 
	        (state-true-assertions (node-state current-node)))
	  (set-false-assertions start-state
	        (state-false-assertions (node-state current-node)))
	  (setf (node-state start-node) start-state)
	  (setf (node-recur-children current-node)
		(cons start-node (node-recur-children current-node)))
	  (setf (node-recur-parent start-node) current-node)
	  (expand-node start-node)
	  (return start-node)))

; Checks if exp is achievable at CURRENT-NODE. Calls PRODIGY recursively.
;  NOTE the recur-op must be an INFERENCE RULE
 
(defun achievable (current-node exp)
    (and (recur-run nil current-node exp)
	 (cond ((has-any-vars exp)
		(known (car (node-recur-children current-node)) exp))
	       (t))))

(defun has-any-vars (exp)
    (g-loop (while exp)
	    (do (cond ((atom (car exp))
		       (cond ((is-variable (car exp))
			      (return t))))
		      ((has-any-vars (car exp))
		       (return t))))
	    (next exp (cdr exp))))

; Checks if exp is provable at CURRENT-NODE. Calls PRODIGY recursively.

(defun provable (current-node exp)
    (and (recur-run t current-node exp)
	 (cond ((has-any-vars exp)
		(known (car (node-recur-children current-node)) exp))
	       (t))))

; Calls common recursively.

(defun recur-run (inferences-only-flag current-node goal-exp)
    (let ((old-top-level-goal (op-preconds '*FINISH*))
	  (old-match-count *MATCH-COUNT*)  ; save globals
	  (old-state *STATE*)
          (old-cand-nodes *CAND-NODES*)
	  (old-node *CURRENT-NODE*))
	 (setf (op-preconds '*FINISH*) goal-exp)
	 (cond (*INFERENCES-ONLY* (setq inferences-only-flag nil))
                      ;for resetting
	       (inferences-only-flag (setq *INFERENCES-ONLY* t))) 
	 (prog1 (cntrl (initialize-recur-start-node current-node) '(done))
		(if inferences-only-flag (setq *INFERENCES-ONLY* nil))
		(setf (op-preconds '*FINISH*) old-top-level-goal)
		(setq *STATE* old-state
		      *MATCH-COUNT* (+ *MATCH-COUNT* old-match-count)
		      *CURRENT-NODE* old-node
		      *CAND-NODES* old-cand-nodes))))


		
(defun applied-operator (node &optional (oper nil))
  "test whether an operator was applied at this node."
  (and (node-p node)
       (node-applied-node node)
       (let ((nco (node-current-op (node-parent node))))
	 (and (assoc nco *OPERATORS*)
	      (cond ((null oper) t)
		    ((is-variable oper) (list (list (list oper nco))))
		    ((atom oper) (equal oper nco)))))))


  
(defun applied-inference (node &optional (infer nil))
  "test whether an inference rule was applied at this node"
  (and (node-p node)
       (node-applied-node node)
       (let ((nco (node-current-op (node-parent node))))
	 (and (assoc nco *INFERENCE-RULES*)
	      (cond ((null infer) t)
		    ((is-variable infer) (list (list (list infer nco))))
		    ((atom infer) (equal infer nco)))))))


   
(defun was-deleted-by (node lit op vars)
  (cond ((or (is-variable node)(is-variable lit) 
	     (is-variable op) (is-variable vars) (has-vars vars))
	 (error "WAS-DELETED-BY, cant have variable node, lit, op or bindings"))
	((has-vars lit)(error "Was-deleted-by: vars in lit"))
	((not (closed-predicate lit)) nil)
	((let ((anscestor (cond ((not (member lit (state-closed-world
						   (node-state node))
					      :test #'equal))
				 (was-deleted-above node lit))
				((was-deleted-above 
				  (find-where-lit-absent node lit) lit))))
	       reset-alt)
	   (and anscestor
		(setq reset-alt (node-reset-alt anscestor))
		(eql op (if reset-alt (alt-op reset-alt)))
		(g-loop (init vals (if reset-alt (alt-vars reset-alt)))
			(while vals)
			(do (cond ((null (car vars)))
				  ((equal (car vals) (car vars)))
				  ((return))))
			(next vals (cdr vals) vars (cdr vars))
			(result t)))))))



(defun below-depth-limit (node)
   (declare (type node node) (special *DEPTH-LIMIT*))
   "Returns nil if node is below depth limit, t otherwise.  Also it
    deletes the nodes that are in the path that was stopped."

      (when (> (node-depth node) *DEPTH-LIMIT*)
;        (format t "~%Hit depth limit.~%")
;	(remove-nodes-until-backtrack node)
        t)
)

(defun shallower (node1 node2)
    (declare (type node node1 node2))
    "Shallower function that works better then one in Prodigy 2.0
     manual and tutorial."
    (< (node-depth node1) (node-depth node2)))
