#|
*******************************************************************************
PRODIGY Version 2.0  
Copyright 1989 by Steven Minton, Craig Knoblock, Dan Kuokka and Jaime Carbonell

The PRODIGY System was designed and built by Steven Minton, Craig Knoblock,
Dan Kuokka and Jaime Carbonell.  Additional contributors include Henrik Nordin,
Yolanda Gil, Manuela Veloso, Robert Joseph, Santiago Rementeria, Alicia Perez, 
Ellen Riloff, Michael Miller, and Dan Kahn.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#


; ======================================================================
; File:  interface.lisp		Version: 1-20 	     Created:  5/10/88
; Locked by: nobody                                 Modified:  6/3/88
; 
; Purpose:   This file contains generic user interface functions....

; Changes: 6/3/88, restored, mpm.
; ======================================================================


;(provide 'prodigy-command-interface)
;(in-package 'prodigy-command-interface)
;(export '())
;(import '())

(eval-when (compile)
      (load-path *PLANNER-PATH* "ini")
      #-:coral (load-path *PLANNER-PATH* "pg-x11")
)
#-:coral (use-package 'pg)
; ----------------------------------------------------------------------


(proclaim 
  '(special *HELP-COMMAND-TABLE* *SYNONYMS* *ALL-NODES*  
     	    *COMMAND-LIST* *EXPL-NODE* *NODE-NUM* *MATCH-EXPLANATION* 
	    *EXPLAIN-MATCH-FAILURES* *FALSIFY-RELEVANCE-TABLE* 
	    *TRUIFY-RELEVANCE-TABLE* *OPERATORS* *INFERENCE-RULES* n1 
	    *DOMAIN-GRAPHICS* *TREE-GRAPHICS* *NODE-LIST* *TREE-WINDOW*
	    *PICTURE-GRAPHICS*  *MAPPED* *OP-TRACING* *SCR-TRACING*
	    *SCR-NODE-SELECT-RULES*  *SCR-GOAL-SELECT-RULES*
	    *SCR-OP-SELECT-RULES*	*SCR-BINDINGS-SELECT-RULES*
	    *SCR-NODE-REJECT-RULES*  *SCR-GOAL-REJECT-RULES*
	    *SCR-OP-REJECT-RULES*	*SCR-BINDINGS-REJECT-RULES*
	    *SCR-NODE-PREFERENCE-RULES*  *SCR-GOAL-PREFERENCE-RULES*
	    *SCR-OP-PREFERENCE-RULES*  *SCR-BINDINGS-PREFERENCE-RULES*
 ))

; ----------------------------------------------------------------------

(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types"))
 

; ======================================================================
;                    COMMAND INTERFACE FUNCTIONS 
; ======================================================================


;; PROCESS-COMMAND wants its input in the format (KEY (arguments) rest)
;; chooses function depending on KEY
;; dkahn -- added pq to if to eliminate error message
;; for just carrage return.

(defmacro process-command (parsed-query command-cases)
  `(let* ((pq ,parsed-query)
	  (key (car pq))
	  (args (cadr pq))
	  (rest (cddr pq))
	  (func (gethash key ,command-cases)))
     (declare (special key args rest)) ; needed to access lexical values...
     (if (or (not pq) func)  
         (eval func)
	 (format t "~2%Sorry, I didn't understand that,~%~
	try saying it in another way~%"))))


; ----------------------------------------------------------------------

;; PARSE-COMMAND parses the query by looking in the synonym table for the 
;; appropriate command and adding the arguments as a list.
;; Example: (s 3) becomes (STACK (3))


(defun parse-command (query stable)
  (cond ((null query) nil)
	((atom query)
	 (cond ((gethash query stable)
		(list (gethash query stable)))
	       (t (list query))))
	((listp (car query))
	 (parse-command (car query) stable))
	((gethash (car query) stable)
	 (list (gethash (car query) stable) (cdr query)))
	(t query)))


; ----------------------------------------------------------------------

;; The COMMAND-INTERPRETER function reads and parses user input, and executes
;; the indicated command. The function requires a prompting string {prompt}, 
;; a command synonym hash table {synonyms}, a command hash table {commands}, 
;; a help item hash table for use with the help facility {help}, a list
;; of commands to end the input {stopcmds}, and a function to do some 
;; tidying up when we are done.  Each of the hash tables are made by calling
;; one of the following functions: make-synonym-table, make-command-table,
;; or, make-help-table.


(defun command-interpreter (preset prompt synonyms 
			    commands help stopcmds cleanup)
  (declare (ignore help))
  (funcall preset)
  (let ((the-result nil))
    (loop 
      (format t "~2%~A " prompt)
      (setq the-result 
	    (process-command 
	     (parse-command (read-atoms) synonyms)
	     commands))
      (when (member the-result stopcmds)
	(funcall cleanup)
	(return the-result)))))

; ======================================================================
;                  TABLE INITIALIZATION FUNCTIONS 
; ======================================================================


;; MAKE-SYNONYM-TABLE transforms a list of synonyms, each of the form
;; (command . (syn1 syn2 syn3 ...)), into a hash table with the same datum.

(defun make-synonym-table (syn-list)
  (when syn-list
    (let ((syn-table (make-hash-table :test #'eql)))
      (dolist (entry syn-list syn-table)
	(let ((command (car entry))(synonyms (cadr entry)))
	  (setf (gethash command syn-table) command)
	  (dolist (synon synonyms)
	    (setf (gethash synon syn-table) command)))))))

; ----------------------------------------------------------------------

;; MAKE-COMMAND-TABLE transforms an alist of commands and effects, of the
;; form (command-symbol (effect-function)) into a symbol pointing to a hash 
;; table containing the same datum.


(defun make-command-table (cmd-cases)
  (when cmd-cases
    (let ((cmd-table (make-hash-table :test #'eql)))
      (dolist (entry cmd-cases cmd-table)
	(let ((command (car entry)) (effect (cadr entry)))
	  (setf (gethash command cmd-table) effect))))))

; ----------------------------------------------------------------------

;; MAKE-HELP-TABLE transforms a symbol pointing to a list of help items,
;; each item of the form (topic field value), into a symbol pointing to a
;; hash table containing the same datum.

(defun make-help-table (help-items)
  (when help-items
    (let ((help-table (make-hash-table :test #'eql)))
      (dolist (entry help-items help-table)
	(let ((topic (car entry))
	      (field (cadr entry))
	      (val (caddr entry)))
	  (put-hlp topic field val help-table))))))




; ======================================================================
;                    GENERIC  INTERFACE  HELP  FUNCTIONS 
; ======================================================================


;; A help topic may be either a command, a submenu listing various
;; commands, or a menu listing various submenus. The TERSE-TEXT field
;; allows a one line synopsis of the particular topic.  Multiple lined
;; summaries are shown with the SUBMENU-TEXT and MENU TEXT fields.
;; The COMMANDS field is used to list the commands associated with the
;; topic and SUBMENU-TEXT, while the submenus are shown in conjunction 
;; with the MENU-TEXT and TOPIC fields. 


(defstruct hlp-topic
  topic           
  terse-text 
  menu-text       submenus 
  submenu-text    commands )


; ----------------------------------------------------------------------

;; GET-HLP shows the value of a field {element} within the the help
;; command hash table using the topic {keyword} as the index.

(defun get-hlp (keyword element help-table)
  (let ((Entry (gethash keyword help-table)))
    (if entry
	(case element
	  ('terse-text (hlp-topic-terse-text  Entry))
	  ('submenu-text (hlp-topic-submenu-text Entry))
	  ('menu-text (hlp-topic-menu-text Entry))
	  ('submenus (hlp-topic-submenus Entry))
	  ('commands (hlp-topic-commands Entry))))))


; ----------------------------------------------------------------------

;; PUT-HLP stores a value on the help commands hash table using
;; the topic {httopic}, field {htfield} and value {htvalue}. 


(defun put-hlp (httopic htfield htvalue htable)
  (let ((Entry (gethash httopic htable)))
    (if (or (null Entry) (not (hlp-topic-p Entry)))
	(setq Entry (make-hlp-topic :topic httopic)))
    (case htfield
      (terse-text  (setf (hlp-topic-terse-text Entry) htvalue))
      (submenu-text  (setf (hlp-topic-submenu-text Entry) htvalue))
      (menu-text (setf (hlp-topic-menu-text Entry) htvalue))
      (submenus  (setf (hlp-topic-submenus Entry) htvalue))
      (commands (setf (hlp-topic-commands Entry) htvalue)))
    (setf (gethash httopic htable) Entry)
    t))


; ======================================================================
;                     MISCELLANEOUS   FUNCTIONS 
; ======================================================================

(defun read-atoms ()
; return the input line as a single list of atoms. 
  (let ((ins ""))
    (loop 
      (setq ins (concatenate 'string ins " " (read-line)))
      (and (evenp (double-quote-count ins))
	   (<= (paren-count ins) 0)
	   (return (string-intern ins))))))


(defun double-quote-count (s)
; counts the number of double quote characters in a string.
  (let ((c 0))
    (dotimes (i (length s) c)
      (cond ((char-equal #\" (aref s i)) (incf c))))))


(defun paren-count (s)
; counts the levels of open parentheses in a string, making sure
; to ignore any parentheses inside a string literal (double quote).
  (let ((c 0) (lit nil))
    (dotimes (i (length s) c)
      (if lit 
	  (cond ((char-equal #\" (aref s i)) (setq lit nil)))
	  (cond ((char-equal #\" (aref s i)) (setq lit t))
		((char-equal #\( (aref s i)) (incf c))
		((and (char-equal #\) (aref s i)) (> c 0))
		 (setq c (1- c))))))))



(defun string-intern (s)
; given a string {s}, this routine will return a list containing 
; the objects within  the string.

  (cond ((null-string s) nil)
	((null-string (cdr-string s)) (values (list (car-string s))))
	(t (append (list (car-string s)) 
		   (string-intern (cdr-string s))))))


(defun null-string (s)
; this tests for an empty string.
  (and (stringp s) 
       (setq s (string-trim '(#\space #\tab #\newline) s))
       (= 0 (length s))
       s))


(defun car-string (s)
; given a string {s}, this function returns the first list or 
; word as a lisp object (atom or list).
  (let ((obj nil) (len 0))
    (unless (null-string s)
      (setq s (string-trim '(#\space #\tab #\newline #\\ #\|) s))
      (multiple-value-setq (obj len)
	(read-from-string s nil "")))
    (values obj s len)))



(defun cdr-string (s)
; given an input string {s}, it removes the first word/list
; and returns the remainder of the string.

  (and (stringp s)
       (let ((c nil)(lc nil))
	 (multiple-value-setq (c s lc)
	   (car-string s))
	 (subseq s lc))))

; ----------------------------------------------------------------------

(defun get-args (args no-of-args query-list)
  "Queries user for required command arguments. 
   Will convert a sequence of atoms into a list of args."
  (cond ((>= (length args) no-of-args) args)
	(t (append (get-args args (1- no-of-args) (butlast query-list))
		   (progn (if (not (listen *terminal-io*))
			      (format t "~%~A" (car (last query-list))))
		     (read-atoms))))))

; ----------------------------------------------------------------------

(defun seq-butlast (s &optional (n 1))
  (let ((ln (length s)))
    (if (> ln n) (subseq s 0 (- ln n)))))


(defun seq-last (s &optional (n 1))
  (let ((ln (length s)))
    (if (> ln n) (subseq s (- ln n) ln))))

; ======================================================================
;		  Functions to implement event loop.
; ======================================================================

(defvar *LINE-BUFFER* (make-array '(512) :element-type 'string-char
				  :fill-pointer 0))
(defvar *EOL-CHAR* #+:cmu #\linefeed #+:franz-inc #\newline 
				"End of line character")

(defvar *CHAR* nil)

(defun read-line-no-hang (&optional (stream *standard-input*))
     (declare (stream stream) (special *LINE-BUFFER* *CHAR*))
  
     "READ-LINE-NO-HANG will finish all output calls and then read the 
      next char off stream and push it onto a stack.  If the char read 
      is #\linefeed then it will return the whole stack otherwise it 
      will return nil. "
     ;reset buffer if necessary.
     (if (and (not (zerop (fill-pointer *LINE-BUFFER*)))
              (eql (char *LINE-BUFFER* (1- (fill-pointer *LINE-BUFFER*)))
	      *EOL-CHAR*))
	 (setf (fill-pointer *LINE-BUFFER*) 0))
     ;if new char push onto stack.
     (when (listen)
;	   (let ((char (read-char stream)))
;	       (declare (string-char char))
  	       (setf *char* (read-char stream))
	       (vector-push *CHAR* *LINE-BUFFER*)
	       (if (eql *CHAR* *EOL-CHAR*)
		   (string-trim `(,*EOL-CHAR*) *LINE-BUFFER*)
		   nil)
;)
))

(defun delay-beep ()
    (sleep 1)
;    (system:beep)
)

(defun test-read ()

	(let (string)
	   (loop
		(setf string (read-line-no-hang))
		(when string
		    (format t "~S~%" string)
		    (force-output))
		)))

(defun test-read-one-line ()
       (do ((string nil (read-line-no-hang)))
	   (string (format t "~S~%" string))))


(defun read-event-no-hang () 
(declare (special *DISPLAY*))
(default-event-handler *DISPLAY*))

(defun read-some-input ()
  "Polls for input line at keyboard and then at window."
(cond ((or *TREE-GRAPHICS* *DOMAIN-GRAPHICS*)

   (finish-output)
     (do ((line-input (read-line-no-hang) (read-line-no-hang))
          (win-input  (read-event-no-hang) (read-event-no-hang)))
          ((or line-input win-input)  ; end condition
		(or (stringp win-input) line-input ""))
     ))
      (t (read-line))
)
)
;;; The function read-atoms is redifined here for "standard x11" machines
;;; which require this loop to be able to trap window events as well 
;;; as accept input thru their xterm windows.
#-(or :cmu :coral) 
(defun read-atoms ()
  "return the input line as a single list of atoms. "
  (let ((ins ""))
    (loop 
      (setq ins (concatenate 'string ins " " (read-some-input)))
      (and (evenp (double-quote-count ins))
	   (<= (paren-count ins) 0)
	   (return (string-intern ins))))))

; ======================================================================
;                  End   of  File    interface.lisp 
; ======================================================================



