#|
*******************************************************************************
PRODIGY Version 2.0  
Copyright 1989 by Steven Minton, Craig Knoblock, Dan Kuokka and Jaime Carbonell

The PRODIGY System was designed and built by Steven Minton, Craig Knoblock,
Dan Kuokka and Jaime Carbonell.  Additional contributors include Henrik Nordin,
Yolanda Gil, Manuela Veloso, Robert Joseph, Santiago Rementeria, Alicia Perez, 
Ellen Riloff, Michael Miller, and Dan Kahn.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#


; ======================================================================
; File:  analyze.lisp		Version: 1-20 	     Created:  3/23/88
; Locked by: nobody                                 Modified:  7/7/88
;
; Purpose:   Search analysis user interface definitions
; ======================================================================


;(provide 'prodigy-search-analysis)
;(require 'prodigy-command-interface)
;(in-package 'search-analysis)
;(export '())
;(import '())


; ======================================================================
;                  ANALYZE  COMMAND  INTERFACE  VARIABLES 
; ======================================================================

(defvar *ANALYZE-PROMPT* "Analysis:")
(defvar  *ANALYZE-STOPCMDS* '(STOP CONTINUE))

; The reason DISPLAY-TREE is called in the preset is analyze needs the data structures
; that keep track of the current path.  These structure were invented for 
; tree graphics.  This led to a situation where analyze commands such as forward 5
; would go forward 5 nodes absolutely without tree graphics, and five nodes on
; the current path with tree graphics.  Using the data structure it now always goes
; moves relative to the current path.

(defvar  *ANALYZE-PRESET*  
         #'(lambda ()
	     (declare (special environment begin-node n1 *ALL-TREES*
			       *ALL-NODES* *EXPL-NODE* *NODE-LIST*))
		      (or (null environment)
			  (stringp environment)
			  (error "~2% Erroneous value of Analysis Environment~
			          is neither~% a string nor null. Illegal ~
				  value ~A~2%" environment))
		      (cond (*ALL-NODES*
			     (cond ((and (eq (node-current-op 
					      (cadr *ALL-NODES*))
					     '*FINISH*)
					 (node-applied-node (cadr *ALL-NODES*)))
				    ; set phony node to nil
; dkahn--I commented the next line because I think its unnecessary
; and we shouldn't be messing up the node name bindings.
;				    (set (node-name (car *ALL-NODES*)) nil)  
				    ; and delete it from list
				    (setq *NODE-LIST* (cdr *ALL-NODES*))) 
				   (t (setq *NODE-LIST* *ALL-NODES*)))
			     (cond ((null *EXPL-NODE*))
				   ((not (member *EXPL-NODE* *NODE-LIST*))
				    (setq *EXPL-NODE* nil)))
				; this is a hack, this stuff was for
				; tree-grahics at first
			     (let ((rev-all-nodes (reverse *all-nodes*)))
			       (setf *ALL-TREES* (build-tree-node-list
						rev-all-nodes
						(generate-heads (car rev-all-nodes)))))
			     (initialize-vars)
			     (let ((entry-node (cond ((node-p begin-node) begin-node)
				    ((and (integerp begin-node)
					  (member (name-to-node begin-node)
						  *ALL-NODES*))
				     (name-to-node begin-node))
				    (t (caar *all-trees*)))))
			     (initialize-tree *all-trees*)
			     (display-tree (find-tree entry-node *all-trees*))
			     (move-to-node (find-head entry-node *all-trees*))
			     ))
			    (t (setq *NODE-LIST* nil *EXPL-NODE* nil)))))

(defvar *ANALYZE-POSTSET* 
        #'(lambda ()
	    (declare (special envrionment *SURROUNDING-GRAPHICS*
			      *TREE-GRAPHICS*))
		      (if *SURROUNDING-GRAPHICS*
			   (toggle-surrounding-graphics))
			; Tree graphics must now be destroyed
			; when analyze exits.
		      (if  *TREE-GRAPHICS*
			   (kill-tree-graphics))
			   (reset-display-tree)
		      (format t "~2% ... Returning to ~
		      ~:[previous context~;~:*~(~A~)~]~2%"
			      environment)))


; ======================================================================
;                 SYNONYM  TABLE  FOR  ANALYZE  FACILITY 
; ======================================================================


(defvar *ANALYZE-SYNONYMS* 
 (make-synonym-table
  '((ADVISE (AD ADV ADVI ADVIS ADVISE ADVIC ADVICE TAKE-ADVICE))
    (ALTS (AL ALT ALTS))
    (APROPOS (AP APR APRO APROP APROPO APROPOS))
    (ABS-DOWN (DOWN))
    (ABS-UP (UP))
    (BACKWARD (B BW BACKW BACKWA BACKWAR BACKWARD))
    (BACKTRACK (BACKT BT BACKTR BACKTRA BACKTRAC BACKTRACK))
    (CHILDREN (CH CHIL CHILD CHILDR CHILDRE CHILDREN))
    (CLONES (CL CLO CLON CLONE CLONES))
    (CONTEXT (CONTE CONTEX CONTEXT))
    (CONTINUE (CONTI CONTIN CONTINU CONTINUE FINISH))
    (DETAIL (D DE DET DETA DETAI DETAIL))
    (EVAL (E EV  EVA EVAL LISP))
    (FORWARD (F FO FOR FORW FORWA FORWAR FORWARD))
    (GO (GO))
    (HELP (H HE HEL HELP ?))
    (INFERENCE (INFE INFER INFERE INFEREN INFERENC INFERENCE INFERENCES))
    (LAST (LA LAS LAST END))
    (LEFT (L LEFT))
    (LEFTMOST (LEFTM LM))
    (MOVIE (MOVI MOV MO M))
    (NOT-UNIQUE-COMMAND-WORD (A BA BAC BACK C CO CON CONT G I IN LE LEF O OP
			      P PA PAR RI RIG RIGH  S SC ST STA T  W WH))
    (OPERATOR (OPE OPER OPERA OPERAT OPERATO OPERATORS))
    (OPFAIL (OPF OPFA OPFAI OPFAIL))
    (OPSEQ  (OPS OPSE OPSEQ))
    (OPTRACE (OPT OPTR OPTRA OPTRAC OPTRACE))
    (PARENT (PARE PAREN PARENT))
    (PARTIAL (PART PARTI PARTIA PARTIAL))
    (PICTURE (PI PIC PICT PICTU PICTUR PICTURE))
    (RAW (RA PLIST RAW))
    (REFRESH (RE REF REFR REFRE REFRES REFRESH))
    (RIGHT (R RIGHT))
    (RIGHTMOST (RM RIGHTM RIGHTMO RIGHTMOS RIGHTMOST))
    (SCFAIL (SCF SCFA SCFAI SCFAIL))
    (SCHST (SCH SCHS SCHST))
    (SCRULE (SCR SCRU SCRUL SCRULES SCRULE))
    (SCTRACE (SCT SCTR SCTRA SCTRAC SCTRACE))
    (SHOW (SH SHO SHOW))
    (SOLUTION (SO SOL SOLU SOLUT SOLUTI SOLUTIO SOLUTION))
    (SURROUNDING (SU SUR SURR SURRO SURROU SURROUN SURROUND SURROUNDI 
		     SURROUNDIN SURROUNDING))
    (STACK (STAC STACK))
    (STATE (STAT STATE))
    (STOP (STO STOP Q QUI QUIT TOP))
    (TEXT (TE TEX TEXT))
    (TREE (TR TRE TREE))
    (TOGSURROUNDING (TO TOG TOGS TOGSU TOGSUR TOGSURR TOGSURRO TOGSURROU
			TOGSURROUN TOGSURROUND TOGSURROUNDI TOGSURROUNDIN
			TOGSURROUNDING))
    (WHATIF (TRY WHATIF WHA WHAT WHATI WHATIF WHAT- WHAT-I WHAT-IF))
)))

; ======================================================================
;                    HELP  TABLE  FOR  ANALYZE  FACILITY  
; ======================================================================


(defvar *ANALYZE-HELP* 
 (make-help-table
'((HELP SUBMENUS (movement node graphics miscellaneous))


  (ALL COMMANDS (abs-down abs-up advise alts apropos backward backtrack
		 children clones
		 context continue detail eval forward go help 
		 inference last left leftmost operator opfail opseq 
		 optrace parent partial picture raw refresh right 
		 rightmost scfail schst scrule sctrace show solution 
		 stack surrounding state stop text togsurrounding tree 
		 whatif ))
  (GRAPHICS COMMANDS (picture tree show backtrack refresh 
		      surrounding  togsurrounding  text movie))
  (NODE COMMANDS (context stack state alts detail schst
		  partial parent children clones raw whatif advise
		  scfail opfail))
  (MOVEMENT COMMANDS (abs-down abs-up go forward backward right left rightmost
		      leftmost last ))
  (MISCELLANEOUS COMMANDS (stop continue apropos eval solution opseq 
			   help operator inference scrule sctrace optrace))

  (HELP MENU-TEXT
"  Help is used to list the four classes of search analysis commands.
  If a particular command is specified, it will give you information
  about that command.

  The analysis categories are: ")


  (ALL  SUBMENU-TEXT " The analysis help commands are ...")
  (GRAPHICS SUBMENU-TEXT
"  Graphics commands are used to update either domain or tree graphics.
  All movement commands update the tree graphics since the current
  node is always displayed.  If you select a node beyond the tree
  graphics window, the tree will scroll.")
  (MISCELLANEOUS SUBMENU-TEXT
"  Commands to perform other useful things.")
  (MOVEMENT SUBMENU-TEXT
"  Movement commands are used to traverse the search tree.")
  (NODE SUBMENU-TEXT
"  Node commands are used to obtain information about a given node as
  well as to change some of the choices made.")




  (ADVISE TERSE-TEXT "- runs problem solver and allows user to select alts")
  (ALTS  TERSE-TEXT  "- prints the possible alternatives")
  (ABS-DOWN TERSE-TEXT "- move to the next lower abstract level.")
  (ABS-UP TERSE-TEXT "- move to the next higher abstract level.")
   (APROPOS TERSE-TEXT "[keyword] - shows associations for a given keyword, default 
                      is to prompt the user")
  (BACKWARD TERSE-TEXT "[x] - go backward x nodes in the tree, x defaults to 1")
  (BACKTRACK TERSE-TEXT "[node] - expands a backtracking path")
  (CHILDREN TERSE-TEXT "- prints the child nodes")
  (CLONES TERSE-TEXT  "- prints the clones of a node") 
  (CONTEXT TERSE-TEXT
	   "- prints the number, goal, operator and other useful stuff")
  (CONTINUE TERSE-TEXT  "- exit and resume planning" )
  (DETAIL TERSE-TEXT "[n] - shows each alt in detail, or alt number 'n'")
  (EVAL TERSE-TEXT  "[exp] - evaluate the given lisp expression")
  (FORWARD  TERSE-TEXT "[x] - go forward x nodes in the tree, x defaults to 1") 
  (GO TERSE-TEXT  "[node] - jump to the specified node, default is to prompt the user")
  (GRAPHICS TERSE-TEXT  "Commands - control the state and tree graphics")
  (HELP  TERSE-TEXT  "[exp] - provide general help")
  (INFERENCE TERSE-TEXT "[name] - prints the specified inference rule")
  (LAST TERSE-TEXT  "- go to the last node in the search tree")
  (LEFT TERSE-TEXT  "[x] - go left x clones, x defaults to 1")
  (LEFTMOST TERSE-TEXT  "- go to the leftmost clone")
  (MISCELLANEOUS TERSE-TEXT "Commands to perform other useful things")
  (MOVEMENT TERSE-TEXT   "Commands - traverse the search tree")
  (MOVIE TERSE-TEXT "- show a movie of solution.")
  (NODE TERSE-TEXT  "Commands - display information about a node")
  (OPERATOR TERSE-TEXT "[name] - prints the specified operator")
  (OPFAIL TERSE-TEXT
	  "- lists the operators that were tried, but failed to match")
  (OPSEQ TERSE-TEXT "- prints the operators in the problem solution")
  (OPTRACE TERSE-TEXT
	   "- toggles the operator/inference tracing facility (for opfail)")
  (PARENT TERSE-TEXT "- prints the parent node")
  (PARTIAL TERSE-TEXT "- prints the problem solution up to this node")
  (PICTURE TERSE-TEXT  "- toggles the domain graphics")
  (RAW TERSE-TEXT "- prints the property list of a node")
  (REFRESH TERSE-TEXT "- refreshes the window with the tree graphics")
  (RIGHT TERSE-TEXT "[x] - go right x clones, x defaults to 1")
  (RIGHTMOST TERSE-TEXT "- go to the rightmost clone")
  (SCFAIL TERSE-TEXT
	  "- lists the control rules that were tried, but failed to match")
  (SCHST  TERSE-TEXT "- prints the search control history")
  (SCRULE TERSE-TEXT "[name] - prints the specified control rule")
  (SCTRACE TERSE-TEXT
	   "- toggles the search control tracing facility (for scfail)")
  (SHOW TERSE-TEXT
	"[node] - draws the tree with [node] in the upper-left corner")
  (SOLUTION TERSE-TEXT "- prints the solution including inferences")
  (SURROUNDING TERSE-TEXT 
	       "- display local nodes using simple character graphics")
  (STACK TERSE-TEXT  "- prints the goal stack")
  (STATE TERSE-TEXT "- print the current state")
  (STOP TERSE-TEXT  "- exit and abort the current planning process")
  (TEXT TERSE-TEXT "- toggles the trace text during problem solving")
  (TOGSURROUNDING TERSE-TEXT
	   "- toggles simple character graphics displaying local nodes")
  (TREE TERSE-TEXT  "- toggles the tree graphics")
  (WHATIF TERSE-TEXT "[node] - selects new start node and alt for a run")

)))


; ======================================================================
;              COMMAND   TABLE   FOR   ANALYSIS   FACILITY 
; ======================================================================


(defvar *ANALYZE-COMMANDS* 
 (make-command-table 
  '((ADVISE (the-advise-command))
    (ALTS (the-alts-command))
    (ABS-DOWN (the-abs-down-command))
    (ABS-UP (the-abs-up-command))
    (APROPOS (the-apropos-command (car args) *ANALYZE-HELP*))
    (BACKWARD (the-back-command args))
    (BACKTRACK (the-backtrack-command args))
    (CHILDREN (the-children-command))
    (CLONES (the-clones-command))
    (CONTEXT (the-context-command *EXPL-NODE*))
    (CONTINUE 'CONTINUE)
    (DETAIL (the-detailed-alts-command args))
    (EVAL (the-eval-command args))
    (FORWARD (the-forward-command args))
    (GO (the-go-command args))
    (HELP (the-help-command args *ANALYZE-HELP*))
    (INFERENCE (the-inference-command (car args)))
    (LAST (the-last-command))
    (LEFT (the-left-command args))
    (LEFTMOST (the-leftmost-command))
    (MOVIE (the-movie-command))
    (NOT-UNIQUE-COMMAND-WORD (the-not-unique-command))
    (OPERATOR (the-operator-command (car args)))
    (OPFAIL (the-opfail-command))
    (OPSEQ (the-opseq-command))
    (OPTRACE (the-optrace-command))
    (PARENT (the-parent-command))
    (PARTIAL (the-partial-command args))
    (PICTURE (the-picture-command))
    (RAW (the-raw-command))
    (REFRESH (the-refresh-command))
    (RIGHT (the-right-command args))
    (RIGHTMOST (the-rightmost-command))
    (SCFAIL (the-scfail-command))
    (SCHST (the-schst-command args))
    (SCRULE (the-scrule-command (car args)))
    (SCTRACE (the-sctrace-command))
    (SHOW (the-show-command args))
    (SOLUTION (the-solution-command))
    (SURROUNDING (the-surrounding-command))
    (STACK (the-stack-command))
    (STATE (the-state-command)) 
    (STOP 'STOP)
    (TEXT (the-text-command))
    (TOGSURROUNDING (the-togsurrounding-command))
    (TREE (the-tree-command))
    (WHATIF (the-whatif-command (car args) environment))
)))


; ======================================================================
;             ANALYZE   COMMAND   INTERPRETER   ROUTINE 
; ======================================================================


;; The ANALYZE facility first does the initiation, then prints out the nodes
;; where something "has happened" together with their node numbers, in order
;; to jump to the interesting node.  Finally, ANALYZE performs the following
;; loop: read user input, parse the input, and, execute the command.
;;
;; HACK ALERT (REVISITED) - When PRODIGY completes a run, it creates an extra
;; node that is never used.  This "phony" node will be the first node in
;; *ALL-NODES* since it was the last node created.  If PRODIGY did not finish,
;; however, it will not have created this node and so all of the nodes in
;; *ALL-NODES* will have been used.  To protect the explanation facility from
;; the likes of this pseudo-node, I created a different version of 
;; *ALL-NODES*, called *NODE-LIST*, which contains all of the "real" nodes.
;; ("real" nodes don't eat quiche...)  It also sets the pseudo-node to be nil.
;; These drastic measures were necessary to prevent the pseudo-node from
;; wreaking havoc on the tree-drawing algorithm, but I'm not sure if it's
;; still necessary because I've added some error-checking code since then.
;;


(defun analyze (&optional (begin-node 1) (environment nil))
  (declare (special begin-node environment))
    "Analyze sets up some lexical variables that will be special to
the functions inside the the analyze command (which means that analyze
must be used from the interface) and then calls the
command-interpreter with the proper commands."

  (format t "~2% Entering Search Analysis Facility ...~%")
  (let ((*MAPPED* nil)
	(*ALL-TREES* nil)
	(*TREE-WINDOW-VIRTUAL-WIDTH* 0)
	(*TREE-WINDOW-VIRTUAL-HEIGHT* 0))
    (declare (special *MAPPED* *ALL-TREES*
		      *TREE-WINDOW-VIRTUAL-WIDTH* 
    		      *TREE-WINDOW-VIRTUAL-HEIGHT*)
	     (fixnum  *TREE-WINDOW-VIRTUAL-WIDTH* 
    		      *TREE-WINDOW-VIRTUAL-HEIGHT*))
    (command-interpreter 
     *ANALYZE-PRESET* *ANALYZE-PROMPT* *ANALYZE-SYNONYMS*
     *ANALYZE-COMMANDS* *ANALYZE-HELP* *ANALYZE-STOPCMDS*
     *ANALYZE-POSTSET*)))


; ======================================================================
;			   END   OF   analyze.lisp
; ======================================================================
















