#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

(proclaim '(special *SCHEMA-TABLE* *SCHEMAS* *EBL-PATH* *U-SCHEMAS*
		    *S-SCHEMAS* *GI-SCHEMAS* *F-SCHEMAS*))

(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types")
	(load-path *EBL-PATH*     "ebl-data-types"))

(load-path *EBL-PATH* "f1")
(load-path *EBL-PATH* "s1")
(load-path *EBL-PATH* "u1")
(load-path *EBL-PATH* "gi1")


(setq *SCHEMA-TABLE* nil)


(defun add-to-schema-table (nm sig)
    (prog (table-entry)
	  (setq table-entry (assoc (car sig) *SCHEMA-TABLE*))
	  (cond ((null table-entry)
		 (push (list (car sig) nm) *SCHEMA-TABLE*))
		(t (nconc table-entry (list nm))))))


(setq *SCHEMAS* 
	(append *U-SCHEMAS* *S-SCHEMAS* *GI-SCHEMAS* *F-SCHEMAS*))

(g-loop (init schema nil nm nil sig nil form nil tmp *SCHEMAS*)
      (while (setq schema (pop tmp)))
      (do (setq nm (car schema)
	        sig (cadr schema)
		form (caddr schema))
	  (add-to-schema-table nm sig) 
	  (setf (get nm 'sig-form) (cdr schema))
	  (setf (get nm 'vars) (find-all-vars form))
	  (setf (get nm 'num-vars) (length (get nm 'vars)))))

; (ps-syntax-check) ; only necessary EBL development

	   
					          
