#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

; Contains Proof schemas (i.e. axioms) for learning from success.

(setq *S-SCHEMAS* '(

(def-goal-succeeds 
   (goal-succeeds <node> <goal> <op> <b>)
   (exists (<s>) (op-succeeds <s> <goal> <op> <b>)
	   (no-change <node> <s>)))

(def-bindings-succeed
   (bindings-succeed <node> <goal> <op> <b>)
   (exists (<s>) (op-succeeds <s> <goal> <op> <b>)
	   (no-change <node> <s>)))

(def-directly-succeeds
  (op-succeeds <node> <goal> <op> <b>)
  (let (<l-op>) (old-legal-operator <l-op>)
    (exists (<add>) (member-add-list <add> <l-op>)
     (and (matches <add> <goal>)
          (op-binding-list <b> <l-op>)
          (is-equal <op> <l-op>)
          (applicable <l-op> <node>)))))


(def-succeeds-with-post-goals
  (op-succeeds <node> <goal> <op> <b>)
  (let (<op-1>) (old-legal-operator <op-1>)
   (let (<op-2>) (new-legal-operator <op-2>)
    (and (is-equal <op-1> <op>)
       (let (<g2>) (in-goal-exp <node> <g2>)
         (let (<child>) (op-succeeds <child> <g2> <op-2> <b2>)
          (exists (<add>) (member-add-list <add> <op-1>)
	    (and (matches <add> <goal>)
	         (op-binding-list <b> <op-1>)
		 (applicable <op-1> <node>)
		 (apply-op-to-generate-succ-state
		      <child> <op-1> <add> <node>)))))))))


(def-subgoaling-succeeds
    (op-succeeds <node> <goal> <op> <b>)
    (let (<child>) (op-succeeds <child> <goal> <op> <b>)
	 (is-succeeding-subgoal-state <child> <goal> <node>)))

(def-precursor-succeeds
    (op-succeeds <node> <goal> <op> <b>)
    (let (<child>) (op-succeeds <child> <goal> <op> <b>)
	 (let (<pre-op>) (old-legal-operator <pre-op>)
	      (exists (<add>) (member-add-list <add> <pre-op>)
		      (and (applicable <pre-op> <node>)
			   (apply-op-to-generate-succ-state
			       <child> <pre-op> <add> <node>))))))
	 
; may want to make this a separate thing...

(def-applicable
 (applicable <op> <node>)
 (let (<preconds>)  (get-preconds <preconds> <op>)
   (known <node> <preconds>)))

		 ))
