
(setq *OPERATORS* '(
(MOVE
 (params (<adj-loc> <to-loc>))
 (preconds (and
	    (adjacent-to <to-loc> <adj-loc>)
	    (supported-loc <to-loc>)
	    (loc-in-room <to-loc> <room>)
	    (in-room robot <room>)
	    (vacant-loc <to-loc>)
	    (at robot <adj-loc>)
	    ))
 (effects (
   (del (at robot <adj-loc>))
   (add (at robot <to-loc>)))))


(MOVE-THRU-DOOR
 (params (<door> <roomx>))
 (preconds (and
	    (connects <door> <roomx> <roomy>)
	    (in-room robot <roomy>)
	    (door-open <door>)
	    (loc-next-to-door <door> <roomy> <locy>)
	    (at robot <locy>)
	    (loc-next-to-door <door> <roomx> <locx>)
	    ))
 (effects    
    ((del (in-room robot <roomy>))
     (del (at robot <locy>))
     (add (at robot <locx>))
     (add (in-room robot <roomx>)))))


(OPEN-DOOR
 (params (<door> <room1>))
 (preconds (and
	    (connects <door> <room1> <room2>)
	    (in-room robot <room1>)
	    (loc-next-to-door <door> <room1> <loc>)
	    (at robot <loc>)
	    (arm-empty)
	    (door-closed <door>)
	    ))
 (effects
  ((add (door-open <door>))
   (del (door-closed <door>)))))


(PICK-UP
 (params (<box> <box-loc>))
 (preconds (and
	    (object <box>)
	    (at <box> <box-loc>)
	    (next-to <box-loc> <robot-loc>)
	    (at robot <robot-loc>)
	    (clear <box>)
	    (arm-empty)
	    ))
 (effects (
   (del (at <box> <box-loc>))
   (add (holding <box>)))))
    


(PUT-DOWN
 (params (<box> <new-loc>))
 (preconds (and
	    (vacant-loc <new-loc>)
	    (object <box>)
	    (next-to <new-loc> <robot-loc>)
	    (supported-loc <new-loc>)
;	    (supported-loc <robot-loc>)
            (holding <box>)
	    (at robot <robot-loc>)
	    ))
 (effects (
   (del (holding <box>))
   (add (at <box> <new-loc>)))))


(TURN-ON-LIGHT
 (params (<room> <loc>))
 (preconds (and
	   (light-off <room>)
	   (light-switch <room> <loc>)
	   (at robot <loc>)
;	   (arm-empty)
	   ))
 (effects (
	   (del (light-off <room>))
	   (add (light-on <room>)))))
		
          
		 ))

(setq *INFERENCE-RULES* '(


(INFER-VACANT-LOC
 (params (<loc>))
 (preconds
	  (~ (exists (<obj>)(at <obj> <loc>)))
	  )
 (effects (
   (add (vacant-loc <loc>)))))

(INFER-SUPPORTED-LOC
 (params (<loc>))
 (preconds
	(or (ground-loc <loc>)
	    (and (above-loc <loc> <below-loc>)
		 (object <ob>)
		 (at <ob> <below-loc>)
		 )
	    ))
 (effects (
   (add (supported-loc <loc>)))))
 

(INFER-CLEAR
 (params (<ob>))
 (preconds 
    (and (at <ob> <loc>)
	 (above-loc <above-loc> <loc>)
	 (vacant-loc <above-loc>)
	 ))
 (effects (
   (add (clear <ob>)))))


(INFER-ARM-EMPTY
 (params nil)
 (preconds
     (~ (exists (<ob>) (holding <ob>))))
 (effects (
   (add (arm-empty)))))



))



(setq *X-DIM* 14)
(setq *Y-DIM* 9)
(setq *Z-DIM* 3)

(setq *ROOMS* (list (list (make-location :room 'frontporch :x 0 :y 0 :z 0)
			  (make-location :room 'frontporch :x 3 :y 1 :z 0))
		    (list (make-location :room 'stairsup :x 0 :y 2 :z 0)
			  (make-location :room 'stairsup :x 2 :y 3 :z 0))
		    (list (make-location :room 'stairsdown :x 0 :y 5 :z 0)
			  (make-location :room 'stairsdown :x 2 :y 5 :z 0))
		    (list (make-location :room 'kitchen :x 0 :y 6 :z 0)
			  (make-location :room 'kitchen :x 5 :y 8 :z 0))
		    (list (make-location :room 'fronthall :x 3 :y 2 :z 0)
			  (make-location :room 'fronthall :x 4 :y 5 :z 0))
		    (list (make-location :room 'closet :x 4 :y 0 :z 0)
			  (make-location :room 'closet :x 4 :y 1 :z 0))
		    (list (make-location :room 'bathroom :x 5 :y 5 :z 0)
			  (make-location :room 'bathroom :x 5 :y 5 :z 0))
		    (list (make-location :room 'livingroom :x 5 :y 0 :z 0)
			  (make-location :room 'livingroom :x 11 :y 4 :z 0))
		    (list (make-location :room 'diningroom :x 6 :y 5 :z 0)
			  (make-location :room 'diningroom :x 11 :y 8 :z 0))
		    (list (make-location :room 'sunporch :x 12 :y 2 :z 0)
			  (make-location :room 'sunporch :x 13 :y 8 :z 0))))

(setq *DOORS*
      (list (make-door :name 'doorfpfh
		       :loc1 (make-location :room 'frontporch :x 3 :y 1 :z 0)
		       :loc2 (make-location :room 'fronthall :x 3 :y 2 :z 0))
	    (make-door :name 'doorfhsu
		       :loc1 (make-location :room 'stairsup :x 2 :y 2 :z 0)
		       :loc2 (make-location :room 'fronthall :x 3 :y 2 :z 0))
	    (make-door :name 'doorfhcl
		       :loc1 (make-location :room 'closet :x 4 :y 1 :z 0)
		       :loc2 (make-location :room 'fronthall :x 4 :y 2 :z 0))
	    (make-door :name 'doorfhbr
		       :loc1 (make-location :room 'bathroom :x 5 :y 5 :z 0)
		       :loc2 (make-location :room 'fronthall :x 4 :y 5 :z 0))
	    (make-door :name 'doorfhkt
		       :loc1 (make-location :room 'kitchen :x 3 :y 6 :z 0)
		       :loc2 (make-location :room 'fronthall :x 3 :y 5 :z 0))
	    (make-door :name 'doorktsd
		       :loc1 (make-location :room 'kitchen :x 2 :y 6 :z 0)
		       :loc2 (make-location :room 'stairsdown :x 2 :y 5 :z 0))
	    (make-door :name 'doorktdr
		       :loc1 (make-location :room 'kitchen :x 5 :y 6 :z 0)
		       :loc2 (make-location :room 'diningroom :x 6 :y 6 :z 0))
	    (make-door :name 'doorfhlr
		       :loc1 (make-location :room 'livingroom :x 5 :y 2 :z 0)
		       :loc2 (make-location :room 'fronthall :x 4 :y 2 :z 0))
	    (make-door :name 'doorlrdr
	               :loc1 (make-location :room 'livingroom :x 8 :y 4 :z 0)
		       :loc2 (make-location :room 'diningroom :x 8 :y 5 :z 0))
	    (make-door :name 'doorlrsp
		       :loc1 (make-location :room 'livingroom :x 11 :y 3 :z 0)
		       :loc2 (make-location :room 'sunporch :x 12 :y 3 :z 0))
	    (make-door :name 'doordrsp
		       :loc1 (make-location :room 'diningroom :x 11 :y 6 :z 0)
		       :loc2 (make-location :room 'sunporch :x 12 :y 6 :z 0))))

(setq *ROOM-MAP* (make-array (list *X-DIM* *Y-DIM*) :initial-element nil))

(initialize-room-map *ROOMS*)
