#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

;;;  Host: bacon.arc.nasa.gov
;;;  File: /home/copernicus/abp/prodigy/ebl/patches.lisp
;;;  Contains: Modifies operator names and Warns user of errors in PDL exp
;;;  Author:  Andy Philips (abp@bacon.arc.nasa.gov)
;;;  Created: Sun May 12 19:07:42 1989
;;;  Updated: Fri Jul  7 18:17:06 1989
;;;  Modified: Julie Roomy Feb 18th, 1992.
;;;      -- essentially removed all functions that I didn't need.


; on all of these should really use "get-form-from-exp"
; not get-forms-from-exp


; a filter rule is a reject or select


(defun normalize-node-filter-rule (rule)
  (let ((lhs (get rule 'lhs))
	sig lits node)
    (setq lits (get-forms-from-exp 'candidate-node lhs))
    (setq lhs (replace-lits-with-t lits lhs)) 
    (setq node (caddr (get rule 'rhs)))
    (push node sig)
    (and (TF-trimable lhs)
	 (setq lhs (TF-trim lhs)))
    (setf (get rule 'lhs-for-ebs)  lhs)
    (setf (get rule 'sig-for-ebs) (cons 'node-sig sig) )))


(defun normalize-goal-filter-rule (rule)
  (let ((lhs (get rule 'lhs))
	sig lits goal node)
    (setq lits (get-forms-from-exp 'candidate-goal lhs))
    (setq goal (caddr (car lits)))
    (push goal sig)
    (setq lhs (replace-lits-with-t lits lhs))
    (setq lits (get-forms-from-exp 'current-node lhs))
    (setq node (cadr (car lits)))
    (push node sig)
    (or (null (cdr lits))(error "mult nodes"))
    (setq lhs (replace-lits-with-t lits lhs))
    (and (TF-trimable lhs)
	 (setq lhs (TF-trim lhs)))
    (setf (get rule 'lhs-for-ebs)  lhs)
    (setf (get rule 'sig-for-ebs) (cons 'goal-sig sig))))


(defun normalize-op-filter-rule (rule)
  (let ((lhs (get rule 'lhs))
	sig lits op goal node)
    (setq lits (get-forms-from-exp 'candidate-op lhs))
    (setq lhs (replace-lits-with-t lits lhs)) 
    (setq op (caddr (get rule 'rhs)))
    (push op sig)
    (setq lits (get-forms-from-exp 'current-goal lhs))
    (setq goal (caddr (car lits)))
    (push goal sig)
    (or (null (cdr lits))(error "mult goals"))
    (setq lhs (replace-lits-with-t lits lhs))
    (setq lits (get-forms-from-exp 'current-node lhs))
    (setq node (cadr (car lits)))
    (push node sig)
    (or (null (cdr lits))(error "mult nodes"))
    (setq lhs (replace-lits-with-t lits lhs))
    (and (TF-trimable lhs)
	 (setq lhs (TF-trim lhs)))
    (setf (get rule 'lhs-for-ebs) lhs)
    (setf (get rule 'sig-for-ebs) (cons 'op-sig sig) )))


(defun normalize-bindings-filter-rule (rule)
  (let ((lhs (get rule 'lhs))
	sig lits op goal node bindings)
    (setq lits (get-forms-from-exp 'candidate-bindings lhs))
    (setq lhs (replace-lits-with-t lits lhs)) 
    (setq bindings (caddr (get rule 'rhs)))
    (push bindings sig)
    (setq lits (get-forms-from-exp 'current-op lhs))
    (setq lhs (replace-lits-with-t lits lhs)) 
    (setq op (caddr (car lits)))
    (push op sig)
    (or (null (cdr lits))(error "mult ops"))
    (setq lits (get-forms-from-exp 'current-goal lhs))
    (setq goal (caddr (car lits)))
    (push goal sig)
    (or (null (cdr lits))(error "mult goals"))
    (setq lhs (replace-lits-with-t lits lhs))
    (setq lits (get-forms-from-exp 'current-node lhs))
    (setq node (cadr (car lits)))
    (push node sig)
    (or (null (cdr lits))(error "mult nodes"))
    (setq lhs (replace-lits-with-t lits lhs))
    (and (TF-trimable lhs)
	 (setq lhs (TF-trim lhs)))
    (setf (get rule 'lhs-for-ebs) lhs)
    (setf (get rule 'sig-for-ebs) (cons 'bindings-sig sig)))) 




;(defun replace-lits-with-t (lits exp)
 ; (dolist (l lits) 
	;  (setq exp (subst t l exp :test #'equal)))
;  exp)


(defun dynamically-add-scr (nm)
  (let ((rule-type
         (cond ((eq (car (get nm 'rhs)) 'select)
                (cond ((eq (cadr (get nm 'rhs)) 'node) 'node-select)
                      ((eq (cadr (get nm 'rhs)) 'goal) 'goal-select)
                      ((eq (cadr (get nm 'rhs)) 'operator) 'op-select)
		      ((eq (cadr (get nm 'rhs)) 'bindings) 'bindings-select)
                      ((error "bad rule type" nm))))
               ((eq (car (get nm 'rhs)) 'reject)
                (cond ((eq (cadr (get nm 'rhs)) 'node) 'node-reject)
                      ((eq (cadr (get nm 'rhs)) 'goal) 'goal-reject)
                      ((eq (cadr (get nm 'rhs)) 'operator) 'op-reject)
                      ((eq (cadr (get nm 'rhs)) 'bindings) 'bindings-reject)
                      ((error "bad rule type" nm))))
               ((eq (car (get nm 'rhs)) 'prefer)
                (cond ((eq (cadr (get nm 'rhs)) 'node) 'node-pref)
                      ((eq (cadr (get nm 'rhs)) 'goal) 'goal-pref)
		      ((eq (cadr (get nm 'rhs)) 'operator) 'op-pref)
                      ((eq (cadr (get nm 'rhs)) 'bindings) 'bindings-pref)
                      ((error "bad rule type" nm)))))))
    (normalize-scr-for-ebs nm)
    (load-new-scntrl-rule
     `(,nm (lhs ,(get nm 'lhs)) (rhs ,(get nm 'rhs)))
     rule-type)))


(defun replace-lits-with-t (lits exp)
  (dolist (l lits)
          (setq exp (subst t l exp :test #'equal)))
  exp)



;; borrowed from ebl-top-level.lisp:
(defun show-rules ()
  (dolist (nm *LEARNED-RULES-IN-SYS*)
          (cond ((get nm 'was-learned)
                 (pprint (list 'lhs (get nm 'lhs)))
                 (pprint (list 'rhs (get nm 'rhs)))))))
