;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  Static Analyzer for Full Prodigy language
;;
;;  Code for creating and using binding lists
;;
;;
;;  Author: Oren Etzioni
;;  Mod:    Bruce Lesourd
;;  Mod:    Julie Roomy
;;  Mod:    Rob Spiger
;;
;;  Some functions still have definitions with and without iterate.
;;  The ones without iterate may be deleted.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;---------------------------
;; return bindings create PSG
;; There was a very strange bug where return-bindings was acting 
;; incorrectly until I recompiled this file.  Therefore I changed
;; the name to make it more unique.
(defun return-bindings-create-PSG (node)
  (cond 
   ((Literal-p node)
    (Literal-bindings node))
   ((InternalNode-p node)
    (InternalNode-bindings node))))



;;-------------------
;; relevant-operators
;; returns: list of op-structs for all the operators that satisfy goal.
;; The op-structs consist of: (name-of-operator binding-list 
;;                condition-for-effect bound-effects-without-conditions)
;; Match returns the bindings under which goal unifies with the effects
;; of the ops (including any conditions which need to be conjoined).
;; Handles negated goals!  We check that binds exist (in the when
;; clause below) because the relevant operator may fail to match the
;; goal, because of constants.  This works because binds is non-null
;; even if the match succeeds with no unifications!  
;;(defun relevant-operators (goal)
;;  (iter:iterate
;;   (iter:for op iter:in (relevant-ops goal))
;;   (let* ((effects (find-op-effects op))
;;	  (lbl (goal-match goal effects)))
;;     (when lbl
;;	   (appending
;;	    (iter:iterate
;;	     (iter:for bl iter:in lbl)
;;	     (iter:collect (ops-helper bl op effects))))))))



;;-----------
;; goal-match
;; Returns an list of binding lists for the variables in the *effects*,
;; because these are the variables that will be substituted for.
;; eg: g=(holding <x>)  effects=((holding <v>), (~ (clear <v>))).
;; result: ((<v> <x>)).
;; Also if the effect which matches the goal is a conditional effect
;; return the condition.
;;(defun goal-match (goal effects)
;;  (iter:iterate
;;   (iter:for e iter:in effects)
;;   (let ((bl (first (match (first e) goal))))
;;     ;; when something matches check for a conditional effect
;;     ;; by returning the binding list plus the condition of the effect
;;     ;; (condition is nil for most effects)
;;     (when bl 
;;	   (iter:collect (list bl (second e)))))))



;;-------------
;; relevant-ops
;; Returns operators which may match goal.  Decision based upon
;; tables built by prodigy.  Also removes those operators learned
;; from goal-rejection rules (don't generate a rule which already
;; exists).
;;(defun relevant-ops (goal)
;;  (remove-bad-ops 
;;   goal
;;   (if (eq (first goal) '~)  ;; if literal negated try to falsify
;;       (rest (assoc (first (second goal)) ;; ex: (~ (P x))
;;		    *falsify-relevance-table*))
;;     (rest (assoc (first goal)          ;; ex: (P x)
;;		  *truify-relevance-table*)))))



;;---------------
;; remove-bad-ops
;; Using domain specific information
;; Removes ops that are ruled out by default control rules.
;;(defun remove-bad-ops (goal ops)
;;  (iter:iterate
;;   (iter:for c iter:in *bad-ops*)
;;   (when (match (list goal) (list (car c)))
;;	 (setq ops (set-difference ops (cdr c))))
;;   (iter:finally (iter:return ops))))

;;-----------
;; ops-helper
;; Given an operator its effects and it's binding list this routine 
;; returns an op-struct:  (name-of-operator binding-list 
;;        condition-for-effect bound-effects-without-conditions)
;; currently this function binds the effects and their conditions
;; and seperates binding-list into bindings and condition.
;; also it removes (nil nil) from binding-list.
;;(defun ops-helper (binding-list op effects)
;;  (let*
;;      ((bindings (remove-nils (first binding-list)))
;;       (condition (second binding-list))
;;       (bound-effects (bind-effects effects bindings)))
;;    (list op (second bound-effects) condition (first bound-effects))))




;;------------
;; remove-nils
(defun remove-nils (bindings)
  (iter:iterate
   (iter:for binding iter:in bindings)
   (if (first binding)
       (iter:collect binding))))


;;-------------
;; bind-effects
;;(defun bind-effects (effects bindings)
;;  (list
;;   (iter:iterate
;;    (iter:for e iter:in effects)
;;    (let ((bound (bind-clauses e bindings)))
;;      (iter:collect (first bound))
;;      (setq bindings (second bound))))
;;   bindings))
          


;;-------------
;; bind-clauses
; Substitutes the bindings in binds into clauses.
; returns a list (clauses binds).
; Generates vars for wild-card vars.
; Checks for constants. Handles negated clauses!
; potential values of generate argument: (var, const, nil)
; These determine what bind-clauses does with unbound vars in the
; clauses. 
(defun bind-clauses (clauses binds &optional (generate 'var))
  (iter:iterate
   (iter:for p iter:in clauses)
   (let* ((negated (eq (car p) '~))
	  (vars-and-binds
	   (if negated
	       (bind-clauses-helper (cdr (cadr p)) binds
				    generate)
	     (bind-clauses-helper (cdr p) binds
				  generate)))
	  )
     (setq binds (cadr vars-and-binds))
     (iter:collect
      (if negated
	  `(~ ,(cons (car (cadr p)) (car vars-and-binds)))
	(cons (car p) (car vars-and-binds)))
      into new-clauses))
    (finally
     (return (list new-clauses binds))))
  )

;;(defun bind-clauses (clauses binds &optional (generate 'var))
;; (let* (
;;  (negated nil)
;;  (vars-and-binds nil)
;;  (bind-clauses-helper nil)
;;  (binds nil))
;;   (loop for p in clauses 
;;    do
;;     (setq negated (eq (car p) '~))
;;     (setq vars-and-binds 
;;           (if negated (setq bind-clauses-helper (cdr (cadr p))
;;                             binds               generate)
;;                       (setq bind-clauses-helper (cdr p)
;;                             binds               generate)))
;;     (setq binds (cadr vars-and-binds))
;;     collect
;;      (if negated
;; 	   `(~ ,(cons (car (cadr p)) (car vars-and-binds)))
;;  	   (cons (car p) (car vars-and-binds)))
;;      into new-clauses
;;    finally
;;     (return (list new-clauses binds)))))


;;(defun bind-clauses (clauses binds &optional (generate 'var))
;; (let* (
;;   (new-clauses nil))
;;  (mapcar #'
;;   (lambda (p)
;;    (let* (
;;      (negated (eq (car p) '~))
;;      (vars-and-binds 
;;               (if negated
;;                (bind-clauses-helper (cdr (cadr p)) binds generate)
;;                (bind-clauses-helper (cdr p) binds generate))))
;;     (setq binds (cadr vars-and-binds))
;;     (setq new-clauses
;;                  (cons 
;;                   (if negated
;;                	`(~ ,(cons (car (cadr p)) (car vars-and-binds)))
;;                     (cons (car p) (car vars-and-binds)))
;;                   new-clauses))))
;;   clauses)
;;   (list new-clauses binds)))


;;--------------------
;; bind-clauses-helper
;;(defun bind-clauses-helper (vars binds generate)
;; (let* (
;;   (new-vars nil))
;; (mapcar #'
;;  (lambda (x)
;;   (if (rob-is-var? x)
;;     (let*
;;	   ((binding (assoc x binds)))
;;	 (if binding
;;	     (setq new-vars (cons (cadr binding) new-vars))
;;	   (if generate
;;	       (let ((new-binding
;;		      (cond ((member x *wild-cards*)
;;			     (generate-random-wild-card))
;;			    ((eq generate 'var) (generate-random-var))
;;			    ((eq generate 'const) (generate-random-const))
;;			    (t (error "Unknown flag ~s ~%" generate)))))
;;		 (setq new-vars (cons new-binding new-vars))
;;		 (setq binds (append (list (list x new-binding))
;;				     binds)))
;;	     (setq new-vars (cons x new-vars)))))
;;     (setq new-vars (cons x new-vars))))		; x is a constant.
;;  vars)
;;  (list new-vars binds)))


--------------------
 bind-clauses-helper
(defun return-input (x) x)

;;(defun bind-clauses-helper (vars binds generate)
;; (let* (
;;   (binding nil)
;;   (new-binding nil)
;;   (new-vars nil))
;;   (loop for x in vars do
;;     (print "hi there")
;;     when (rob-is-var? x)
;;        do (setq binding (assoc x binds))
;;        and 
;;        if (return-input binding)
;;           collect (cadr binding) into new-vars
;;        else
;;           if generate
;;                 do (setq new-binding 
;;                    (cond
;;                     ((member x *wild-cards*)
;;                      (generate-random-wild-card))
;;                     ((eq generate 'var) 
;;                      (generate-random-var))
;;                     ((eq generate 'const)
;;                      (generate-random-const))
;;                     (t (error "Unknown flag ~s ~%" generate))))
;;                 and collect new-binding into new-vars
;;                 and do (setq binds (append (list 
;;                              (list x new-binding)) binds))
;;           else collect x into new-vars
;;           end
;;        end
;;     else 
;;      collect x into new-vars
;;     end
;;     finally (return (list new-vars binds)))))


       
;;  (iter:iterate
;;   (iter:for x iter:in vars)
;;   (if (rob-is-var? x)
;;       (let*
;;	   ((binding (assoc x binds)))
;;	 (if binding
;;	     (iter:collect (cadr binding) into new-vars)
;;	   (if generate
;;	       (let ((new-binding
;;		      (cond ((member x *wild-cards*)
;;			     (generate-random-wild-card))
;;			    ((eq generate 'var) (generate-random-var))
;;			    ((eq generate 'const) (generate-random-const))
;;			    (t (error "Unknown flag ~s ~%" generate)))))
;;		 (iter:collect new-binding iter:into new-vars)
;;		 (setq binds (append (list (list x new-binding))
;;				     binds)))
;;	     (iter:collect x iter:into new-vars))))
;;     (iter:collect x iter:into new-vars))		; x is a constant.
;;   (iter:finally (iter:return (list new-vars binds)))))
;;

;;--------------------
;; bind-clauses-helper
(defun bind-clauses-helper (vars binds generate)
  (iter:iterate
   (iter:for x iter:in vars)
   (if (rob-is-var? x)
       (let*
	   ((binding (assoc x binds)))
	 (if binding
	     (iter:collect (cadr binding) into new-vars)
	   (if generate
	       (let ((new-binding
		      (cond ((member x *wild-cards*)
			     (generate-random-wild-card))
			    ((eq generate 'var) (generate-random-var))
			    ((eq generate 'const) (generate-random-const))
			    (t (error "Unknown flag ~s ~%" generate)))))
		 (iter:collect new-binding into new-vars)
		 (setq binds (append (list (list x new-binding))
				     binds)))
	     (iter:collect x into new-vars))))
     (iter:collect x into new-vars))		; x is a constant.
   (finally (return (list new-vars binds)))))


;;----------------
;; find-op-effects
;; modified for conditional effects so that returned effect list is
;; (((effect1) (condition1)) ((effect2) (condition2)) etc...)
;;

(defun find-op-effects (op-name)
  (parse-effects (get op-name 'effects)))

(defun parse-effects (effect-list)
  (let ((first-effect (first effect-list)))
    (cond
     ;; simple add effect
     ((eq (first first-effect)
	  'add)
      (cons (rest first-effect)
	    (parse-effects (rest effect-list))))

     ;; simple del effect
     ((eq (first first-effect)
	  'del)
      (cons (list (negate-literal (second first-effect)))
	    (parse-effects (rest effect-list))))

     ;; conditional effect list
     ((eq (first first-effect)
	  'if)
      `(,@(and-cond-to-effect (second first-effect)
                (parse-effects (rest (rest first-effect))))
        ,@(parse-effects (rest effect-list))))

     (T nil))))  ;; all effects parsed


(defun and-cond-to-effect (cond effects)
 (mapcar #'(lambda (effect)
           (if (eq (second effect) nil)
           `(,(first effect) ,cond)
           `(,(first effect) (AND ,cond ,(second effect)))))
  effects))


;;---------------
;; negate-literal
;; borrowed from original static
;;(defun negate-literal (l)
;;  (cond ((eq (first l) '~)
;;	 (cons (first (second l))
;;	       (mapcar #'(lambda (param)
;;			   param
;;			   )
;;		       (rest (second l)))))
;;	(T
;;	 (list '~
;;	       (cons (first l)
;;		     (mapcar #'(lambda (param)
;;				 param
;;#|				 (cond ((random-const? param)
;;					param)
;;				       ((my-var? param)
;;					param)
;;				       ((wild? param)
;;					param))
;;|#
;;				 )
;;			     (rest l)))))))
;;this function is defined in rules/rules.lisp
