
#ifdef __GNUC__
 #pragma once
#endif

#ifndef _DEBUG_H_
#define _DEBUG_H_

/* There is probably a more elegant way to force a core dump...
 * But I don't know it.
 */
#define DUMP_CORE (*((char *) 1) = '\1')

#ifdef DEBUG
#define FNAME(str) static char *procedure_string = str
#define MNAME(str) static char *module_string = str
#else
/* Must expand to something harmless, because null declarations 
 * are not allowed.  */
#define FNAME(str) extern int dummy()
#define MNAME(str) extern int dummy()
#endif

#endif  /* _DEBUG_H_ */
