# include <stdio.h>			/* wdlen.c (rev3.7) */
# include <ctype.h>

char punctuation[512] = ",.;:-?!\"()[]{}" ;

int wdlngs[21];		/* array with counts of word lengths */
int longlpr = 0;	/* toggle option for long histogram */

main(argc, argv)	/* tabulate word length frequency */
int argc;
char *argv[];
{
	FILE *fopen(), *fp;
	int i;

	if (argc == 1)
	{
		puts("Usage: wdlen [-l -dPfile -] filename(s)\t\t(rev3.7)");
		puts("-l: print long histogram suitable for lineprinter");
		puts("-d: define punctuation set according to Pfile");
		puts("- : read standard input instead of files");
		exit(1);
	}
	initialize();
	for (i = 1; i < argc; i++)
	{
		if (*argv[i] == '-')
			getflag(argv[i]);
		else if ((fp = fopen(argv[i], "r")) != NULL)
		{
			wdlen(fp);
			fclose(fp);
		}
		else
		{
			fprintf(stderr,
			"Wdlen cannot access the file: %s\n", argv[i]);
			exit(1);
		}
	}
	pr_results();
	exit(0);
}

initialize()		/* set word length array to all zeros */
{
	int i;

	for (i = 0; i < 21; i++)
		wdlngs[i] = 0;
}

getflag(f)		/* parses command line to set options */
char *f;
{
	char *pfile;

	f++;
	switch(*f++)
	{
		case 'l':
			longlpr = 1;
			break;
		case 'd':
			pfile = f;
			getpunct(pfile);
			break;
		case NULL:
			wdlen(stdin);
			break;
		default:
			fprintf(stderr,
			"Invalid wdlen flag: -%s\n", --f);
			exit(1);
			break;
	}
}

getpunct(pfile)		/* read user's punctuation from pfile */
char *pfile;
{
	FILE *pfp, *fopen();
	char s[512], *strcpy();

	if ((pfp = fopen(pfile, "r")) == NULL)
	{
		fprintf(stderr,
		"Wdlen cannot access Punctfile: %s\n", pfile);
		exit(1);
	}
	else
		while (fgets(s, 512, pfp))
			strcpy(punctuation, s);
}

wdlen(fp)		/* tabulate array of word lengths */
FILE *fp;
{
	int wlen;

	while (wlen = getword(fp))
		if (wlen < 21)
			++wdlngs[wlen];
}

getword(fp)		/* move through text, counting word lengths */
FILE *fp;
{
	int wlen = 1;
	register int c;

	while ((c = getc(fp)) != EOF && isskip(c))
		;
	if (c == EOF)
		return(NULL);
	while ((c = getc(fp)) != EOF && !isskip(c))
		wlen++;
	return(wlen);
}

isskip(c)		/* function to evaluate punctuation */
char c;
{
	char *ptr;

	if (isspace(c))
		return(1);
	for (ptr = punctuation; *ptr != c && *ptr != NULL; ptr++)
		;
	if (*ptr == NULL)
		return(0);
	else
		return(1);
}

pr_results()		/* print out table of word lengths */
{
	int max, incr, i, j;

	max = 0;
	for (i = 1; i < 21; i++)
		if (wdlngs[i] > max)
			max = wdlngs[i];
	if (longlpr)
		incr = max/100;
	else
		incr = max/60;
	if (incr == 0)
		incr = 1;
	printf("Wdlen: Count:\n");
	for (i = 1; i < 21; i++)
	{
		printf("   %2d  ", i);
		printf("%5d  ", wdlngs[i]);
		for (j = 0; j < wdlngs[i]; j = j + incr)
			putchar('-');
		putchar('\n');
	}
}
