# include <stdio.h>			/* format.c (rev3.7) */
# include <ctype.h>
# include <signal.h>

char *tempfile;		/* to store overflow while counting */
int nomap = 0;		/* toggle for mapping keyword to lcase */
int nocnt = 0;		/* toggle for counting keyword */
int nokwd = 0;		/* toggle for suppressing keyword */

usage()			/* print proper usage and exit */
{
	puts("Usage: format [-mck] [filename(s)]\t\t(rev3.7)");
	puts("-m: keywords not mapped from lower to upper case");
	puts("-c: suppress counting of keyword frequency");
	puts("-k: entirely suppress printing of keyword");
	exit(1);
}

main(argc, argv)	/* make keyword headings with count */
int argc;
char *argv[];
{
	FILE *fopen(), *fp;
	int i, j, onintr();
	char *mktemp();

	if (signal(SIGINT, SIG_IGN) != SIG_IGN)
		signal(SIGINT, onintr);

	tempfile = "/tmp/FmtXXXXX";
	mktemp(tempfile);

	for (i = 1; argv[i] && *argv[i] == '-'; i++)
	{
		for (j = 1; argv[i][j] != NULL; j++)
		{
			if (argv[i][j] == 'm')
				nomap = 1;
			else if (argv[i][j] == 'c')
				nocnt = 1;
			else if (argv[i][j] == 'k')
				nokwd = 1;
			else  /* bad option */
			{
				fprintf(stderr,
				"Illegal format flag: -%c\n", argv[i][j]);
				usage();
			}
		}
	}
	if (i == argc)
	{
		if (nokwd)
			rmkwds(stdin);
		else if (nocnt)
			ffmt(stdin);
		else
			format(stdin);
	}
	for (; i < argc; i++)
	{
		if ((fp = fopen(argv[i], "r")) != NULL)
		{
			if (nokwd)
				rmkwds(fp);
			else if (nocnt)
				ffmt(fp);
			else
				format(fp);
			fclose(fp);
		}
		else  /* attempt to open file failed */
		{
			fprintf(stderr,
			"Format cannot access the file: %s\n", argv[i]);
			continue;
		}
	}
	unlink(tempfile);
	exit(0);
}

char buff[BUFSIZ*8];	/* tempfile buffer for storing contexts */
int bufflen;		/* total length of contexts in buffer */
int fulltf = 0;		/* does the tempfile contain something? */
FILE *tf = NULL;	/* file pointer for tempfile routines */

format(fp)	  	/* print keyword and count only if different */
FILE *fp;
{
	char s[BUFSIZ], okw[BUFSIZ/2], nkw[BUFSIZ/2], cntxt[BUFSIZ];
	char *sp, *kwp, *cxp, *strcpy();
	int kwfreq = 0;

	strcpy(okw,"~~~~~");	/* make sure 1st keyword is printed */

	while (fgets(s, BUFSIZ, fp))
	{
		for (sp = s, kwp = nkw; *sp && *sp != '|'; sp++, kwp++)
		{
			if (!nomap && islower(*sp))
				*kwp = toupper(*sp);
			else
				*kwp = *sp;
		}
		*kwp = NULL;

		for (++sp, cxp = cntxt; *sp && *sp != '\n'; sp++, cxp++)
		{
			if (*sp == '|') {
				*cxp = ' '; *++cxp = ' '; *++cxp = ' ';
			} else
				*cxp = *sp;
		}
		*cxp = '\n';
		*++cxp = NULL;

		if (strcmp(nkw, okw) != 0)  /* kwds different */
		{
			if (kwfreq != 0)
			{
				getbuff(kwfreq);
				putchar('\n');
			}
			*buff = NULL;
			bufflen = 0;
			fputs(nkw, stdout);
			putbuff(cntxt);
			kwfreq = 1;
		}
		else  /* if keywords are the same */
		{
			putbuff(cntxt);
			kwfreq++;
		}
		strcpy(okw, nkw);
	}
	getbuff(kwfreq);
}

putbuff(cntxt)		/* cache routine to buffer tempfile */
char cntxt[];
{
	char *strcat();

	if (!fulltf)
	{
		bufflen += strlen(cntxt);
		if (bufflen < BUFSIZ*8)
			strcat(buff, cntxt);
		else {
			fulltf = 1;
			if ((tf = fopen(tempfile, "w")) == NULL)
				perror(tempfile);
			fputs(buff, tf);
			*buff = NULL;
			bufflen = 0;
		}
	}
	else  /* fulltf */
		fputs(cntxt, tf);
}

getbuff(kwfreq)		/* print frequency and context buffer */
int kwfreq;
{
	char str[BUFSIZ];

	printf("(%d)\n", kwfreq);
	if (!fulltf)
		fputs(buff, stdout);
	else
	{
		fclose(tf);
		if ((tf = fopen(tempfile, "r")) == NULL)
			perror(tempfile);
		while (fgets(str, BUFSIZ, tf))
			fputs(str, stdout);
		fclose(tf);
		fulltf = 0;
	}
}

int onintr()		/* remove tempfile in case of interrupt */
{
	fprintf(stderr, "\nInterrupt\n");
	unlink(tempfile);
	exit(1);
}

ffmt(fp)	  	/* if different, print keyword without count */
FILE *fp;
{
	char s[BUFSIZ], okw[BUFSIZ/2], nkw[BUFSIZ/2], cntxt[BUFSIZ];
	char *sp, *kwp, *cxp, *strcpy();

	strcpy(okw,"~~~~~");	/* make sure 1st keyword is printed */
	while (fgets(s, BUFSIZ, fp))
	{
		for (sp = s, kwp = nkw; *sp && *sp != '|'; sp++, kwp++)
		{
			if (!nomap && islower(*sp))
				*kwp = toupper(*sp);
			else
				*kwp = *sp;
		}
		*kwp = NULL;

		for (++sp, cxp = cntxt; *sp && *sp != '\n'; sp++, cxp++)
		{
			if (*sp == '|') {
				*cxp = ' '; *++cxp = ' '; *++cxp = ' ';
			} else
				*cxp = *sp;
		}
		*cxp = '\n';
		*++cxp = NULL;

		if (strcmp(nkw, okw) != 0)  /* kwds different */
			printf("\n%s\n %s", nkw, cntxt);
		else  /* if keywords are the same */
			printf(" %s", cntxt);
		strcpy(okw, nkw);
	}
}

rmkwds(fp)		/* completely suppress printing of keyword */
FILE *fp;
{
	char s[BUFSIZ], *sp;

	while (fgets(s, BUFSIZ, fp))
	{
		for (sp = s; *sp && *sp != '|'; sp++)
			;
		for (; *sp; sp++)
		{
			if (*sp == '|')
				printf("   ");
			else
				putchar(*sp);
		}
	}
}
