.TH TROFFMT HUM (rev3.7)
.ds ]W UC Berkeley
.SH NAME
troffmt \- format concordance for typesetter
.SH SYNOPSIS
.nf
\fBtroffmt\fP  [ \fB\-ckm\fP ]  [ filename ... ]  [ \- ]
\-c: suppress counting of keyword frequency
\-k: entirely suppress printing of keyword
\-m: do not supply concordance macros automatically
\- : read standard input instead of files
.fi
.SH DESCRIPTION
\fITroffmt\fP is a preprocessor for \fItroff\fP that replaces \fIformat\fP
when using the phototypesetter instead of the lineprinter.
It builds its own macros, so it does not require the \-ms package.
.PP
Keyword counting can be suppressed by using the \-c option;
this will speed up the program somewhat.
To completely suppress printing of a separate keyword, use the \-k option.
.PP
Here is a typical program sequence for a concordance,
suitable for sending to the typesetter:
.nf
 % kwic \-f5 \-c80 filename(s) | sort | troffmt | troff \-Q
.fi
The \-c80 argument to \fIkwic\fP creates a context suitable for the typesetter.
Anything larger may result in lines too long for the typesetter.
If there is no \-f or \-w option, \-c85 would be safe;
with long \-f or \-w options, adjust \-c accordingly.
.SH FILES
\fITroffmt\fP depends in /usr/lib/me/chars.me,
or /usr/lib/mx/tmac.xacc, for accent mark definitions.
.SH "SEE ALSO"
format(hum), kwal(hum), kwic(hum), sort(1)
.SH AUTHOR
Bill Tuthill
.SH BUGS
On systems without either -me or -mx, accent marks are undefined.
The \-k option silently overrides the \-c option.
The \-m flag does not have the same meaning
as the \-m flag in \fIformat.\fP
