.TH SFIND HUM (rev3.7)
.ds ]W UC Berkeley
.SH NAME
sfind \- find sentence matching a pattern
.SH SYNOPSIS
.nf
\fBsfind\fP  [ \fB\-s\fIc\fP \-l\fIn\fP \-p\fIn\fP \-i\fIc\fP \-r\fR ]  'pattern'  [ \- ]  filename ...
\-sC: record separator set to C (or empty line with no C)
\-ln: line number is set to n (instead of 1)
\-pn: page number is set to n (default off)
\-ic: page incrementing character is c (not =)
\-r : reset linenumber to 1 with each new file
\-  : read standard input instead of files
.fi
.SH DESCRIPTION
\fISfind\fP is a rewrite of the Unix utility \fIgrep\fP,
oriented towards sentences rather than towards lines.
It is useful for finding words and syntactic patterns
in their full linguistic context.
If the pattern is longer than one word,
or if it contains magic shell characters,
it must be enclosed in quotes.
You can specify multiple filenames,
and \fIsfind\fP will search through them in order.
If there is a match, it will print the current filename,
the line number where the sentence begins,
the page number if relevent, and the pattern, all on a single line.
This information will be followed by the sentence
exactly as it appears in the text.
.PP
The pattern wildcard character `_' (underscore) matches
any single character; it is similar to the `.' (period) in \fIgrep\fP,
or the `?' (question mark) in the shell.
The wildcard character `*' (asterisk) matches
any number of characters in your text until the pattern continues;
it is exactly like the `*' wildcard in the shell.
It is also similar, but not identical, to the `*' in \fIgrep\fP,
which matches zero or more repetitions of the previous character.
To find an actual underscore or asterisk,
precede these metacharacters with a backslash.
.PP
If you begin searching in the middle of a text,
you can set the beginning line number (or page number)
with the \-l (or \-p) option.
For compatibility with the page incrementing feature of \fIkwic\fP,
\fIsfind\fP will count pages if it encounters `=' (equals) in the text.
The incrementing character can be changed with the \-i option.
If you want to reset the linenumber to 1
at the beginning of each new file, use the \-r option.
.PP
The \-s option is for use with databases
where records are separated by a record separator.
This character can be specified after the \-s,
and the program will operate a record at a time,
rather than a sentence at a time.
If the record separator is a magic shell character,
it will have to be quoted or escaped with a backslash.
A \-s alone indicates that records are separated by a blank line,
as are records in \fIrefer\fP bibliographies.
It is similar to the \-F option of \fIawk\fP.
.SH "SEE ALSO"
kwic(hum), awk(1), grep(1)
.SH AUTHOR
Bill Tuthill
.SH BUGS
There is no equivalent in \fIsfind\fP to the
[...], and [^...] metacharacters of \fIgrep\fP.
These would be extremely helpful.
