.TH KWAL HUM (rev3.7)
.ds ]W UC Berkeley
.SH NAME
kwal \- key word and line concordance
.SH SYNOPSIS
.nf
\fBkwal\fP  [ \fB\-k\fIn\fP \-m \-w\fIS\fP \-f\fIn\fP \-s\fIn\fP \-r \-l\fIn\fP \-x \-d\fIF\fR + \- ]  filename ...
\-kn: keyword is n characters long (defaults to 15)
\-m : keywords not mapped from upper to lower case
\-wS: write string S onto id field (use quotes around blanks)
\-fn: filename (up to n characters) written onto id field
\-sn: skip n characters of lefthand id field in text and write as id
\-r : reset linenumber to 1 at beginning of every file
\-ln: line numbering begins with line n (instead of 1)
\-x : line numbering is suppressed entirely
\-d : define punctuation set according to file F
\(pl : the + character indicates cedilla or umlaut
\(mi : read text from standard input (terminal or pipe)
.fi
.SH DESCRIPTION
\fIKwal\fP is a text concordance program,
generally for use with poetry.
Normally, it prints a left-hand keyword (adjusted for backspaces),
a 6 digit linenumber, and the line of context.
The following characters are considered to be
punctuation marks:  ,.;:-"?!()[]{}  but all other
non-alphabetic characters can be part of a word.
These punctuation characters can be changed.
.PP
By default, only the first 15 characters
of the keyword are printed, followed by a vertical bar;
longer keywords are truncated.
If you want more or less than 15 characters in the keyword,
use the \-k option to lengthen or shorten it.
To find the longest word in your text,
try the \fImaxwd\fP program, and set \-k accordingly.
You can also use \fImaxwd \-l\fP to determine
the length of your longest context line.
Keywords are mapped to lower case to ease the logistics of sorting,
unless the \-m option is specified.
.PP
The \-w argument allows you to write an id field
(such as the name of an author or work) after the keyword.
If you want to include any blanks,
enclose the entire string in quotes: \-w"Poetic Edda".
The \-f argument allows you to write the current filename,
up to a number of characters you specify.
If the filename is shorter, it will be blank-padded,
and if it is longer, it will be truncated.
.PP
If you are concording a series of short poems,
each starting with line 1, type them into separate files,
and use the \-r option to reset the linenumber to 1
at the beginning of each new file.
If you resume concording in the middle of your text,
you can set the line number with the \-l option.
If your text is already numbered or identified,
with a system that is not entirely arithmetic,
such as by hemistich or by double lines,
you can print your custom id field by using the \-s option.
This will skip over n characters of your lefthand id field
embedded in the text, and print it as an id field,
after the (\-f) filename, but before the (\-l) linenumber.
When you also want to suppress linenumbering, use the \-x option.
.PP
If you are working with a foreign language,
and need to use normal punctuation marks as diacritical marks,
you can change the default punctuation set with the \-d option.
Just type the punctuation marks you want into a file,
on a single line with no embedded spaces,
and specify the filename after the \-d in your command line.
If you have cedillas or umlauts, you can represent them
as a `+' character after the accented letter.
Use the `+' option of \fIkwic\fP, and filter your output through
either the \fIcedilla\fP or \fIumlaut\fP program.
.PP
After generating the concordance,
it should be alphabetized using the Unix \fIsort\fP program.
Keywords should be grouped and counted with the \fIformat\fP program,
and the final results can be sent to the lineprinter.
Here is a typical program sequence for generating a concordance:
.nf
 % kwal poem* | sort | format | lpr
.fi
Usually, it is better to send the results of \fIformat\fP
to a file, where they can be examined and edited,
before sending the file to the lineprinter.
.SH "SEE ALSO"
format(hum), kwic(hum), maxwd(hum), maxln(hum), sort(1)
.SH LIMITATIONS
Lines of text cannot be longer than 512 characters.
Linenumbers cannot exceed 999999 without skewing the output format.
Most lineprinters will not print entries longer than 132 characters.
.SH AUTHOR
Bill Tuthill
.SH BUGS
