.TH EXCLUDE HUM (rev3.7)
.ds ]W UC Berkeley
.SH NAME
exclude \- exclusion module for concordance
.SH SYNOPSIS
\fBexclude\fP  [ \fB\-i\fP  ignorefile ]  [ \fB\-o\fP  onlyfile ]  [ filename ... ]
.nf
\-i: ignorefile contains words to be ignored, one per line
\-o: onlyfile has only words to be printed, one per line
.fi
.SH DESCRIPTION
.I Exclude
is a filter that functions as an exclusion routine
for deleting unnecessary words from a concordance.
When invoked without any arguments,
it reads standard input, and writes to standard output,
filtering out all lines beginning with words listed in ``exclfile''.
If any filenames of text files are given,
\fIexclude\fP will read from them rather than from standard input.
.PP
Ordinarily, words to be ignored are read from ``exclfile'',
but another ignore file can be specified after the \-i option.
(There is a list of common English words in /usr/lib/eign.)
If you wish to preserve only a small set of words,
and want all other words ignored, you can list these
important words in the only file, and use the \-o option;
only words listed in that file will be sent through the filter.
Words listed in the exclude file must be on a line of their own,
with no blanks anywhere on the line.
.PP
\fIExclude\fP should be used after \fIkwic\fP or \fIkwal\fP,
but before \fIsort\fP, because eliminating unnecessary words before
sorting will save large amounts of otherwise redundant machine time.
Here is a sample command line using the exclusion routine:
.nf
 % kwic  textfile | exclude | sort | format
.fi
Of course, it is necessary to have words to be excluded in a file 
called ``exclfile'', residing in the same directory as ``textfile''.
Eliminating prepositions and articles from a concordance
can often shorten it by as much as one-third to one-half.
.SH "SEE ALSO"
format(hum), kwal(hum), kwic(hum), sort(1)
.SH AUTHOR
Bill Tuthill
.SH BUGS
There cannot be more than 500 lines in the exclude file.
