/*
 *	mktrie.h
 *			(C) Copyright 1991, All rights reserved by ICOT
 */

#include <sys/types.h>
#include <netinet/in.h>
#include "config.h"
#include "wchar.h"

typedef struct path_r *path_t;
typedef struct info_r *info_t;

struct path_r {
    path_t	next;
    path_t	child;
    int		count;
    long	offset;
    w_char_t	code;
};

struct info_r {
    info_t	next;
    short	hinsi;
    short	length;
    w_char_t	yomi[MAX_YOMI];
};


#define set_short(v, s)\
  (v = (short)htons((u_short)(s)))

#define set_long(v, l)\
  (v = (long)htonl((u_long)(l)))

#define put_short(p, s)\
  {u_short tmp;\
     tmp = htons((u_short)(s));\
     bcopy((char *)&tmp, (char *)p, sizeof(short));\
  }

#define put_long(p, l)\
  {u_long tmp;\
     tmp = htonl((u_long)(l));\
     bcopy((char *)&tmp, (char *)p, sizeof(long));\
  }

#define forward_short(p)\
  (((char *)(p)) = ((char *)(p)) + sizeof(short))
#define forward_long(p)\
  (((char *)(p)) = ((char *)(p)) + sizeof(long))
