/*
 *	kio.c --- Kanji Input/Output routines
 *			(C) Copyright 1991, All rights reserved by ICOT
 */

#include <stdio.h>
#include <strings.h>
#include "define.h"
#include "wchar.h"
#include "kio.h"

#define IO_BUF_SIZE	1024
#define	ESC_CODE	0x1B

static char kanji_shift_in_1[]  = { ESC_CODE, '$', 'B' };
static char kanji_shift_in_2[]  = { ESC_CODE, '$', '@' };
static char kanji_shift_out_1[] = { ESC_CODE, '(', 'B' };
static char kanji_shift_out_2[] = { ESC_CODE, '(', 'H' };
static char kanji_shift_out_3[] = { ESC_CODE, '(', 'J' };

char kanji_shift_in[]  = { ESC_CODE, '$', 'B' };
char kanji_shift_out[] = { ESC_CODE, '(', 'B' };

#define is_kanji_in(addr) \
  (strncmp((addr), kanji_shift_in_1, 3) == 0 || \
   strncmp((addr), kanji_shift_in_2, 3) == 0)

#define is_kanji_out(addr) \
  (strncmp((addr), kanji_shift_out_1, 3) == 0 || \
   strncmp((addr), kanji_shift_out_2, 3) == 0 || \
   strncmp((addr), kanji_shift_out_3, 3) == 0)

static char	low_ibuf[IO_BUF_SIZE];
static char	low_obuf[IO_BUF_SIZE];

/*
 *	read a string from a stream (includes jis kanji)
 */

int read_line(fp, wbuf)
    FILE *fp;
    w_char_t *wbuf;
{
    register int i, j;
    register w_char_t wch;

    if (feof(fp))
        return 0;
    bzero(low_ibuf, IO_BUF_SIZE);
    if (fgets(low_ibuf, IO_BUF_SIZE, fp) == NULL)
        return 0;
    for (i = j = 0; low_ibuf[i] != '\0';) {
	if (low_ibuf[i] == ESC_CODE) {
	    if (is_kanji_in(&(low_ibuf[i]))) {
		i += 3;
		for (;;) {
		    if (low_ibuf[i] == '\0' || low_ibuf[i+1] == '\0')
		        return -1;
		    wch = low_ibuf[i++];
		    wch <<= 8;
		    wch |= low_ibuf[i++];
		    wbuf[j++] = wch;
		    if (low_ibuf[i] == ESC_CODE)
			if (is_kanji_out(&(low_ibuf[i])))
			    break;
		}
		i += 3;
	    }
	}
	wbuf[j++] = low_ibuf[i++];
    }
    wbuf[j] = NULL;
    return j;
}

/*
 *	write a string on a stream
 */

void write_line(fp, wbuf)
    FILE *fp;
    register w_char_t *wbuf;
{
    register int i, j;

    for (i = j = 0; j < IO_BUF_SIZE;) {
	if (wbuf[i] == NULL) {
	    low_obuf[j] = '\0';
	    break;
	}
	if (wbuf[i] & (w_char_t)0xFF00) {
	    (void)strncpy(&(low_obuf[j]), kanji_shift_in, 3);
	    j += 3;
	    do {
		register w_char_t wch;
		if (j >= IO_BUF_SIZE)
		    break;
		wch = wbuf[i++];
		low_obuf[j++] = wch >> 8;
		low_obuf[j++] = wch & (w_char_t)0x00FF;
	    } while (wbuf[i] & (w_char_t)0xFF00);
	    (void)strncpy(&(low_obuf[j]), kanji_shift_out, 3);
	    j += 3;
	} else
	    low_obuf[j++] = wbuf[i++];
    }
    (void)fputs(low_obuf, fp);
}
