
; FILE:       /u2/thnet/data/arcs/fablesA0
; PURPOSE:    test retrieval using fables (numbers 94-103)
; PROGRAMMER: Greg Nelson
; CREATED:    7-25-88
; UPDATED:    7-25-88 - Added hypotheticals.

(defun lfa100 () (load "//tinman/ucla/psych/emelz/ARCS/fablesA0"))
(defun makeloaded nil
  (defvar structures_loaded nil "Keep a list of all of the make_strucs done."))
(setq structures_loaded (append structures_loaded '(fable94 fable95 fable96 fable97 fable98 fable99 fable100 fable101 fable102 fable103)))

; FABLE 94:  Once Bitten, Twice Shy

(defun make_fable94 nil
  (make_struc 'fable94 'fable
	    '(story ((house (obj-house) true f94-1)
		     (mice (obj-mice) true f94-2)
		     (overrun (obj-mice obj-house) true f94-3)
		     (cat (obj-cat) true f94-4)
		     (some-of (obj-some-mice obj-mice) true f94-5)
		     (rest-of (obj-survivors obj-mice) true f94-6)
		     (catch (obj-cat obj-some-mice) true f94-7)
		     (catch (obj-cat obj-survivors) false f94-8)
		     (eat (obj-cat obj-some-mice) true f94-9)
		     (mouse-holes (obj-holes) true f94-10)
		     (retreat-to (obj-survivors obj-holes) true f94-11)
		     (cause (f94-9 f94-11) true f94-12)
		     (dead (obj-cat) false f94-13)
		     (pretend-that (obj-cat (f94-13 true)) true f94-15)
		     (believe (obj-survivors (f94-13 true)) false f94-16)
		     (come-out (obj-survivors) false f94-17)
		     (cause (f94-9 f94-16) true f94-18)
		     (cause (f94-16 f94-17) true f94-19)
		    )
	     )
	    '(moral ((men (obj-men) true m94-1)
		     (wise (obj-men) true m94-2)
		     (experience (conc-experience) true m94-3)
		     (learn-from (obj-men conc-experience) true m94-4)
		     (cause (m94-2 m94-4) true m94-5)
		     (enemy-of (obj-enemy obj-men) true m94-6)
		     (pretenses-of (obj-pretenses obj-enemy) true m94-7)
		     (deceive (obj-pretenses obj-men) false m94-8)
		     (occurs-never (m94-8) true m94-9)
		     (cause (m94-2 m94-9) true m94-10)
		    )
             )
))

; FABLE 95:  Villainy Unmasked

(defun make_fable95 nil
  (make_struc 'fable95 'fable
	    '(story ((cat (obj-cat) true f95-1)
		     (hens (obj-hens) true f95-2)
		     (some-of (obj-sick obj-hens) true f95-3)
		     (sick (obj-sick) true f95-4)
		     (hear-that (obj-cat f95-4) true f95-5)
		     (doctor (obj-cat) false f95-6)
		     (pretend-that (obj-cat (f95-6 true)) true f95-7)
		     (healthy (obj-hens) unknown f95-8)
		     (ask-if (obj-cat obj-hens (f95-8 true)) true f95-9)
		     (become-true (f95-8) unknown f95-10)
		     (if ((f95-13 true) (f95-10 true)) true f95-11)
		     (say-to (obj-hens f95-11 obj-cat) true f95-12)
		     (depart (obj-cat) unknown f95-13)
		    )
	     )
	    '(moral ((villain (obj-villain) true m95-1)
		     (honest (obj-villain) false m95-2)
		     (pretend-that (obj-villain (m95-2 true)) true m95-3)
		     (man (obj-sensible) true m95-4)
		     (sensible (obj-sensible) true m95-5)
		     (convince-that (obj-villain obj-sensible (m95-2 true)) false m95-6)
		     (cause (m95-5 m95-6) true m95-7)
		    )
             )
))

; FABLE 96:  Metamorphosis -- Naturam expells furca, tamen usque recurret

(defun make_fable96 nil
  (make_struc 'fable96 'fable
	    '(story ((cat (obj-cat) true f96-1)
		     (youth (obj-youth) true f96-2)
		     (handsome (obj-youth) true f96-3)
		     (goddess (obj-aphrodite) true f96-4)
		     (love (obj-cat obj-youth) true f96-5)
		     (pity (obj-aphrodite obj-cat) true f96-6)
		     (cause (f96-5 f96-6) true f96-7)
		     (girl (obj-cat) unknown f96-8)
		     (desire (obj-cat (f96-8 true)) true f96-9)
		     (say-to (obj-cat f96-9 obj-aphrodite) true f96-10)
		     (make-true (obj-aphrodite f96-8) true f96-11)
		     (conjoin-event (f96-6 f96-10) true f96-12)
		     (cause (f96-12 f96-11) true f96-13)
		     (beautiful (obj-cat) true f96-14)
		     (love (obj-man obj-cat) true f96-15)
		     (instincts-of (obj-instincts obj-cat) true f96-16)
		     (curious-whether (obj-aphrodite (f96-21 true)) true f96-17)
		     (mouse (obj-mouse) true f96-18)
		     (release (obj-aphrodite obj-mouse) true f96-19)
		     (chase (obj-cat obj-mouse) true f96-20)
		     (changed (obj-instincts) false f96-21)
		     (cause (f96-20 f96-21) true f96-22)
		     (indignant (obj-aphrodite) true f96-23)
; There's certainly no "cause" for her being indignant!!!
		     (make-false (obj-aphrodite f96-8) true f96-24)
		     (cause (f96-23 f96-24) true f96-25)
		    )
	     )
	    '(moral ((man (obj-bad-man) true m96-1)
		     (bad (obj-bad-man) true m96-2)
		     (character-of (obj-character obj-bad-man) true m96-3)
		     (appearance-of (obj-appearance obj-bad-man) true m96-4)
		     (altered (obj-appearance) true m96-5)
		     (altered (obj-character) false m96-6)
		     (even-though (m96-5 m96-6) true m96-7)
		    )
             )
))

; FABLE 97:  The Patience of Fear

(defun make_fable97 nil
  (make_struc 'fable97 'fable
	    '(story ((bull (obj-bull) true f97-1)
		     (lion (obj-lion) true f97-2)
		     (pursue (obj-lion obj-bull) true f97-3)
		     (cave (obj-cave) true f97-4)
		     (enter (obj-bull obj-cave) true f97-5)
		     (cause (f97-3 f97-5) true f97-6)
		     (goats (obj-goats) true f97-7)
		     (inside (obj-goats obj-cave) true f97-8)
		     (butt-against (obj-goats obj-bull) true f97-9)
		     (accept (obj-bull f97-9) true f97-10)
		     (afraid-of (obj-bull obj-lion) true f97-11)
		     (afraid-of (obj-bull obj-goats) false f97-12)
		     (cause (f97-11 f97-10) true f97-13)
		     (cause (f97-12 f97-10) false f97-14)
		    )
	     )
	    '(moral ((people (obj-people) true m97-1)
		     (stronger-than (obj-stronger obj-people) true m97-2)
		     (weaker-than (obj-weaker obj-people) true m97-3)
		     (fear (obj-people obj-stronger) true m97-4)
		     (attack (obj-weaker obj-people) true m97-5)
		     (accept (obj-people m97-5) true m97-6)
		     (cause (m97-4 m97-6) true m97-7)
		    )
             )
))

; FABLE 98:  Nothing To Lose -- Cantabit vacuus coram latrone viator

(defun make_fable98 nil
  (make_struc 'fable98 'fable
	    '(story ((mule (obj-rich-mule) true f98-1)
		     (mule (obj-poor-mule) true f98-2)
		     (gold (obj-gold) true f98-3)
		     (barley (obj-barley) true f98-4)
		     (carry (obj-rich-mule obj-gold) true f98-5)
		     (carry (obj-poor-mule obj-barley) true f98-6)
		     (proud (obj-rich-mule) true f98-7)
		     (sedate (obj-poor-mule) true f98-8)
		     (bandits (obj-bandits) true f98-9)
		     (ambush (obj-ambush) true f98-10)
		     (jump-out-of (obj-bandits obj-ambush) true f98-11)
		     (attack (obj-bandits obj-rich-mule) true f98-12)
		     (steal (obj-bandits obj-gold) true f98-13)
		     (conjoin-event (f98-5 f98-13) true f98-14)
		     (cause (f98-17 f98-12) true f98-15)
		     (leave-alone (obj-bandits obj-poor-mule) true f98-16)
		     (cause (f98-6 f98-16) true f98-17)
		     (die (obj-rich-mule) true f98-18)
		     (cause (f98-12 f98-18) true f98-19)
		     (alive (obj-poor-mule) true f98-20)
		     (cause (f98-16 f98-20) true f98-21)
		    )
	     )
	    '(moral ((humble (obj-humble-poor) true m98-1)
		     (poor (obj-humble-poor) true m98-2)
		     (safe (obj-humble-poor) true m98-3)
		     (rich (obj-rich) true m98-4)
		     (imperiled (obj-rich) true m98-5)
		    )
             )
))

; FABLE 99:  Hoist With Her Own Petard

(defun make_fable99 nil
  (make_struc 'fable99 'fable
	    '(story ((goat (obj-goat) true f99-1)
		     (ass (obj-ass) true f99-2)
		     (master-of (obj-master obj-goat) true f99-3)
		     (master-of (obj-master obj-ass) true f99-4)
		     (jealous-of (obj-goat obj-ass) true f99-5)
		     (food (obj-food) true f99-6)
		     (excessive-for (obj-food obj-ass) true f99-7)
		     (cause (f99-7 f99-5) true f99-8)
		     (suggest-that (obj-goat f99-16) true f99-9)
		     (life-of (obj-life obj-ass) true f99-10)
		     (toil (obj-life) true f99-11)
		     (say-to (obj-goat f99-11 obj-ass) true f99-12)
		     (fit (obj-fit) true f99-13)
		     (have (obj-ass obj-fit) false f99-14)
		     (pretend-that (obj-ass (f99-14 true)) true f99-16)
		     (fall (obj-ass) true f99-17)
		     (cause (f99-16 f99-17) true f99-18)
		     (injured (obj-ass) true f99-19)
		     (cause (f99-17 f99-19) true f99-20)
		     (veterinary (obj-vet) true f99-21)
		     (lung-of (obj-lung obj-goat) true f99-22)
		     (prescribe-for (obj-vet obj-lung obj-ass) true f99-23)
		     (cause (f99-19 f99-23) true f99-24)
		     (kill (obj-master obj-goat) true f99-25)
		     (cause (f99-23 f99-25) true f99-26)
		    )
	     )
	    '(moral ((trap-for (obj-trap obj-other) true m99-1)
		     (lay (obj-you obj-trap) true m99-2)
		     (ruined (obj-you) unknown m99-3)
		     (cause (m99-1 m99-3) unknown m99-4)
		     (occur-sometimes ((m99-4 true)) true m99-5)
		    )
             )
))

; FABLE 100:  Friends Old and New

(defun make_fable100 nil
  (make_struc 'fable100 'fable
	    '(story ((goatherd (obj-goatherd) true f100-1)
		     (flock-of (obj-flock obj-goatherd) true f100-2)
		     (goats (obj-wild-goats) true f100-3)
		     (wild (obj-wild-goats) true f100-4)
		     (join (obj-wild-goats obj-flock) true f100-5)
		     (food (obj-flock-food) true f100-6)
		     (enough (obj-flock-food) true f100-7)
		     (barely (f100-7) true f100-8)
		     (give-to (obj-goatherd obj-flock-food obj-flock) true f100-9)
		     (food (obj-wild-food) true f100-10)
		     (excessive (obj-wild-food) true f100-11)
		     (give-to (obj-goatherd obj-wild-food obj-wild-goats) true f100-12)
		     (depart (obj-wild-goats) true f100-13)
		     (rebuke-for (obj-goatherd obj-wild-goats f100-13) true f100-14)
		     (say-to (obj-wild-goats f100-18 obj-goatherd) true f100-15)
		     (suspicious-of (obj-wild-goats obj-goatherd) true f100-16)
		     (conjoin-event (f100-9 f100-12) true f100-17)
		     (cause (f100-17 f100-16) true f100-18)
		     (cause (f100-16 f100-13) true f100-19)
		    )
	     )
	    '(moral ((offers (obj-offers) true m100-1)
		     (friendly (obj-offers) true m100-2)
		     (people (obj-people) true m100-3)
		     (accept-from (obj-us obj-offers obj-people) true m100-4)
		     (cautious (obj-us) true m100-5)
		     (when (m100-4 m100-5) unknown m100-6)
		     (friends-of (obj-friends obj-people) true m100-7)
		     (prefer-to (obj-people obj-us obj-friends) unknown m100-8)
		     (if ((m100-8 true) (m100-6 true)) true m100-9)
		    )
             )
))

; FABLE 101:  One Thing at a Time

(defun make_fable101 nil
  (make_struc 'fable101 'fable
	    '(story ((goat (obj-goat) true f101-1)
		     (young (obj-goat) true f101-2)
		     (flock (obj-flock) true f101-3)
		     (lag-behind (obj-goat obj-flock) true f101-4)
		     (wolf (obj-wolf) true f101-5)
		     (chase (obj-wolf obj-goat) true f101-6)
		     (ceremony (conc-ceremony) true f101-7)
		     (desire (obj-goat conc-ceremony) true f101-8)
		     (say-to (obj-goat f101-8 obj-wolf) true f101-9)
		     (request (obj-goat (f101-12 true)) true f101-10)
		     (flute (obj-flute) true f101-11)
		     (play (obj-wolf obj-flute) true f101-12)
		     (dance (obj-goat) true f101-13)
		     (dogs (obj-dogs) true f101-14)
		     (hear (obj-dogs f101-12) true f101-15)
		     (come-to (obj-dogs obj-goat) true f101-16)
		     (chase-away (obj-dogs obj-wolf) true f101-17)
		    )
	     )
	    '(moral ((people (obj-people) true m101-1)
		     (business (obj-business) true m101-2)
		     (current (obj-business) true m101-3)
		     (consider (obj-people obj-business) false m101-4)
		     (have (obj-people obj-in-grasp) true m101-5)
		     (lose (obj-people obj-in-grasp) true m101-6)
		     (cause (m101-4 m101-6) true m101-7)
		    )
             )
))

; FABLE 102:  A Bad Workman
; COMMENTS:  Oh happy day!  A short fable, right near the end.  No moral.
;            None.  Whatsoever.

(defun make_fable102 nil
  (make_struc 'fable102 'fable
	    '(story ((sheep (obj-sheep) true f102-1)
		     (shear (obj-shearer obj-sheep) true f102-2)
		     (clumsily (f102-2) true f102-3)
		     (complain-to (obj-sheep obj-shearer) true f102-4)
		    )
	     )
))

; FABLE 103:  Sound And Fury Signifying Nothing
; COMMENTS:  Do you read a lot of Shakespeare, Aesop?

(defun make_fable103 nil
  (make_struc 'fable103 'fable
	    '(story ((lion (obj-lion) true f103-1)
		     (ass (obj-ass) true f103-2)
		     (cave (obj-cave) true f103-3)
		     (goats (obj-goats) true f103-4)
		     (inside (obj-cave obj-goats) true f103-5)
		     (enter (obj-ass obj-cave) true f103-6)
		     (scare (obj-ass obj-goats) true f103-7)
		     (leave (obj-goats obj-cave) true f103-8)
		     (cause (f103-7 f103-8) true f103-9)
		     (catch (obj-lion obj-goats) true f103-10)
		     (cause (f103-8 f103-10) true f103-11)
		     (brag-to (obj-ass obj-lion) true f103-12)
		     (stupid (obj-ass) true f103-13)
		     (cause (f103-12 f103-13) true f103-14)
		     (imply (obj-lion f103-14) true f103-15)
		    )
	     )
	    '(moral ((people (obj-people) true m103-1)
		     (brag-to (obj-people obj-those) true m103-2)
		     (know (obj-those obj-people) true m103-3)
		     (laugh-at (obj-those obj-people) true m103-4)
		     (conjoin-event (m103-2 m103-3) true m103-5)
		     (cause (m103-5 m103-4) true m103-6)
		    )
             )
))


