
; FILE:       data/arcs/plays
; PURPOSE:    test retrieval using plays
; PROGRAMMER: David Gochfeld
; CREATED:    a long time ago
; UPDATED:    7-21-88 - "UNKNOWN" added, 7/22/88 - desire-true, desire-false,
;      believe-true, believe-false, order-to-do, attempt-to-do
;             7-25-88 - desire-xxx, believe-xxx, order-to-do, attempt-to-do
;      removed, imbedded hypothetical truth values for argument propositions 
;      added.
; UPDATED:    7-28-88 - divided into two files, histories and tragedies in one,
;      comedies and problem plays in the other.

(defun lcom () (load "//tinman/ucla/psych/emelz/ARCS/comedies")) 
(defvar structures_loaded nil "Keep a list of all of the make_strucs done.")
(setq structures_loaded (append structures_loaded '(merry-wives
alls-well measure-for-measure merchant-of-venice tempest two-gentlemen
as-you-like-it much-ado twelfth-night loves-labors winters-tale
midsummer-night taming-shrew timon-of-athens pericles)))

; COMEDIES and Problem Plays

; The Merry Wives of Windsor
; this is not very accurate but should suffice

(make_struc 'merry-wives 'play
	    '(characters ((gentleman (obj-page) true mwc-1)
			  (gentleman (obj-ford) true mwc-2)
			  (lady (obj-mistress-page) true mwc-3)
			  (lady (obj-mistress-ford) true mwc-4)
			  (married (obj-page obj-mistress-page) true mwc-5)
			  (married (obj-ford obj-mistress-ford) true mwc-6)
			  (rogue (obj-falstaff) true mwc-7)
			  (daughter (obj-anne obj-page) true mwc-8)
			  (gentleman (obj-fenton) true mwc-9)
			  (gentleman (obj-slender) true mwc-10)
			  (foolish (obj-slender) true mwc-11)
			  (doctor (obj-caius) true mwc-12)
			 )
	     )
	    '(plot ((rich (obj-mistress-page) true mw-1)
		    (rich (obj-mistress-ford) true mw-2)
		    (marry (obj-falstaff obj-mistress-page) false mw-3)
		    (marry (obj-falstaff obj-mistress-ford) false mw-4)
		    (desire (obj-falstaff (mw-3 true)) true mw-5)
		    (cause (mw-1 mw-5) true mw-6)
		    (desire (obj-falstaff (mw-4 true)) true mw-7)
		    (cause (mw-2 mw-7) true mw-8)
		    (conjoin-event (mw-5 mw-7) true mw-9)
;		    (love (obj-slender obj-anne) false mw-10)
		    (marry (obj-slender obj-anne) false mw-11)
		    (desire (obj-page (mw-11 true)) true mw-12)
		    (marry (obj-caius obj-anne) false mw-13)
		    (desire (obj-mistress-page (mw-13 true)) true mw-14)
		    (love (obj-anne obj-fenton) true mw-15)
		    (love (obj-fenton obj-anne) true mw-16)
		    (marry (obj-anne obj-fenton) true mw-17)
		    (desire (obj-anne (mw-17 true)) true mw-18)
		    (desire (obj-fenton (mw-17 true)) true mw-19)
		    (know (obj-mistress-page mw-9) true mw-20)
		    (know (obj-mistress-ford mw-9) true mw-21)
		    (trick (obj-falstaff) true mw-22)
		    (plan (obj-mistress-page mw-22) true mw-23)
		    (plan (obj-mistress-ford mw-22) true mw-24)
		    (scold (obj-mistress-page obj-falstaff) true mw-25)
		    (scold (obj-mistress-ford obj-falstaff) true mw-26)
		    (scold (obj-page obj-falstaff) true mw-27)
		    (scold (obj-ford obj-falstaff) true mw-28)
		    (repent (obj-falstaff mw-9) true mw-29)
		    (forgive (obj-page obj-anne mw-17) true mw-30)
		   )
	     )
)

; Concerns:  There are several other possible ways of encoding thiis play.
;   Instead of coding each of the ladies as "lady" and then "married" it
;  might be possible to just say (wife (obj-mistress-xxx obj-xxx) true).
;   Instead of treating the mistresses seperately all the time the could be
;  put together with a conjoin-object.  I chose to avoid that.
;   There are two ways I can see of getting around the four "scold" 
;  propositions.  One is to use three conjoin-objects, the other is to
;  say (scold (everybody obj-falstaff)) and leave it at that.  By the way,
;  the idea is that the first obj scolds the second object.
;   The "apologize" predicate should probably be two place or three place --
;  actor apologizes to someone for a proposition.  In this case all those 
;  arguments are not really needed -- perhaps we should just say (remorseful
;  (obj-falstaff) true).  Now I am saying that Falstaff repents the proposition
;  (see Tempest).  If the three conjoin-objects were used to get rid of all
;  the scolds, then apologize could be used with the same conjoined-object.
;   Finally, the "forgive" predicate is three-place, where the actor forgives 
;  someone for a proposition. 



; All's Well that Ends Well
; this is the worst yet in inaccuracy. but i can't see how to represent the
; whole part about Bertram declaring that Helena would not truly be his wife
; until she carried his child and wore his ring, then Helena and Diana 
; tricking Bertram into both.

(make_struc 'alls-well 'play
	    '(characters ((king (obj-king) true alc-1)
			  (count (obj-bertram) true alc-2)
			  (woman (obj-helena) true alc-3)
			  (woman (obj-diana) true alc-4)
			 )
	     )
	    '(plot ((ill (obj-king) true al-1)
		    (cure (obj-helena obj-king) true al-2)
		    (love (obj-helena obj-bertram) true al-3)
		    (marry (obj-bertram obj-helena) true al-4)
		    (order (obj-king (al-4 true)) true al-5)
		    (cause (al-26 al-5) true al-6)
		    (dislike (obj-bertram obj-helena) true al-7)
		    (leave (obj-bertram) true al-8)
		    (follow (obj-helena obj-bertram) true al-9)
		    (love (obj-bertram obj-diana) true al-10)
		    (trick (obj-bertram) true al-11)
		    (plan (obj-helena al-11) true al-12)
		    (conjoin-event (al-3 al-7) true al-13)
		    (cause (al-13 al-12) true al-14)
		    (plan (obj-diana al-11) true al-15)
		    (substitute (obj-helena obj-diana) true al-16)
		    (cause (al-11 al-16) true al-17)
		    (meet (obj-helena obj-bertram) true al-18)
		    (meet (obj-diana obj-bertram) false al-19)
		    (believe (obj-bertram (al-19 true)) true al-20)
		    (cause (al-16 al-20) true al-21)
		    (impregnate (obj-bertram obj-helena) true al-22)
		    (cause (al-20 al-22) true al-23)
		    (ring (obj-ringA) true al-24)
		    (give (obj-king obj-ringA obj-helena) true al-25)
		    (ring (obj-ringB) true al-26)
		    (give (obj-bertram obj-ringB obj-diana) true al-27)
		    (cause (al-10 al-27) true al-28)
		    (give (obj-helena obj-ringA obj-bertram) true al-29)
		    (give (obj-diana obj-ringB obj-helena) true al-30)
		    (conjoin-event (al-22 al-30) true al-31)
		    (love (obj-bertram obj-helena) true al-32)
		    (cause (al-31 al-32) true al-33)
		    (conjoin-event (al-2 al-3) true al-34)
		   )
	     )
)

; Well, it's messy and inaccurate, but it's the best I can do.

; Concerns: perhaps the "trick" and "plan" propositions used in this
;  and in Merry-Wives should be (trick (obj-trick <obj-victim>)) and
;  then (plan (obj-actor obj-trick)).

; Measure for Measure

(make_struc 'measure-for-measure 'play
	    '(characters ((duke (obj-vincentio) true mmc-1)
			  (city (obj-venice) true mmc-2)
			  (government (obj-government obj-venice) true mmc-3)
			  (official (obj-angelo) true mmc-4)
			  (woman (obj-juliet) true mmc-5)
			  (woman (obj-isabella) true mmc-6)
			  (siblings (obj-isabella obj-claudio) true mmc-7)
			  (man (obj-claudio) true mmc-8)
			  (lady (obj-mariana) true mmc-9)
			  (monk (obj-monk) true mmc-10)
			 )
	     )
	    '(plot ((unrest (obj-venice) true mm-1)
		    (lax (obj-vincentio) true mm-2)
		    (corrupt (obj-government) true mm-3)
		    (conjoin-event (mm-2 mm-3) true mm-4)
		    (cause (mm-4 mm-1) true mm-5)
		    (deputy (obj-angelo) true mm-6)
		    (cause (mm-4 mm-6) true mm-7)
		    (leave (obj-vincentio) false mm-8)
		    (pretend (obj-vincentio mm-8) true mm-9)
		    (masquerade (obj-vincentio obj-monk) true mm-10)
		    (imprison (obj-angelo obj-claudio) true mm-11)
		    (impregnate (obj-claudio obj-juliet) true mm-12)
		    (cause (mm-12 mm-11) true mm-13)
		    (betrothed (obj-claudio obj-juliet) true mm-14)
		    (unfair (mm-11) true mm-15)
		    (cause (mm-14 mm-15) true mm-16)
		    (release (obj-angelo obj-claudio) unknown mm-17)
		    (plead (obj-isabella obj-angelo mm-17) true mm-18)
		    (sex (obj-sex) true mm-19)
		    (give (obj-isabella obj-sex obj-angelo) unknown mm-20)
		    (desire (obj-angelo (mm-20 true)) true mm-21)
		    (if ((mm-20 true) (mm-17 true)) false mm-22)
		    (lie (obj-angelo mm-22 obj-isabella) true mm-23)
		    (believe (obj-isabella (mm-22 true)) true mm-24)
		    (believe (obj-claudio (mm-22 true)) true mm-25)
		    (love (obj-mariana obj-angelo) true mm-26)
		    (substitute (obj-mariana obj-isabella) unknown mm-27)
		    (marry (obj-mariana obj-angelo) unknown mm-28)
		    (if ((mm-27 true) (mm-28 true)) true mm-29)
		    (say (obj-vincentio mm-29 obj-isabella) true mm-30)
		    (give (obj-mariana obj-sex obj-angelo) true mm-31)
		    (conjoin-event (mm-23 mm-29) true mm-32)
		    (cause (mm-32 mm-31) true mm-33)
		    (believe (obj-angelo (mm-20 true)) true mm-34)
		    (executed (obj-claudio) false mm-35)
		    (order (obj-angelo (mm-35 true)) true mm-36)
		    (dead (obj-claudio) false mm-37)
		    (believe (obj-angelo (mm-37 true)) true mm-38)
		    (end (mm-10) true mm-39)
		    (return-to (obj-vincentio obj-venice) true mm-40)
		    (denounce (obj-isabella obj-angelo) true mm-41)
		    (denounce (obj-mariana obj-angelo) true mm-42)
		    (imprison (obj-vincentio obj-angelo) true mm-43)
		    (release (obj-vincentio obj-claudio) true mm-44)
		    (marry (obj-claudio obj-juliet) true mm-45)
		    (release (obj-vincentio obj-angelo) true mm-46)
		    (plead (obj-mariana obj-vincentio mm-46) true mm-47)
		    (plead (obj-isabella obj-vincentio mm-46) true mm-48)
		    (conjoin-event (mm-47 mm-48) true mm-49)
		    (cause (mm-49 mm-46) true mm-50)
		   )
	     )
)

; I'm stuck here representing Isabella pleading for Claudio's release (in
; other words, pleading for mm-17 to be true.)
; I'm also stuck now representing Angelo's demanding sexual favors from
; Isabella before he will release Claudio.

; Concerns: the "plead" (prop mm-18) is Actor pleads with other-person for
;  a proposition to be true.  This is like "request" in the fable 18 and
;  another in the twenties.
; Not sure how to make it true that Mariana marries Angelo (prop mm-28).

; Also, this is 58 propositions long.  Sorry about that.


; The Merchant of Venice

(make_struc 'merchant-of-venice 'play
	    '(characters ((man (obj-bassanio) true mvc-1)
			  (merchant (obj-antonio) true mvc-2)
			  (money-lender (obj-shylock) true mvc-3)
			  (friends (obj-bassanio obj-antonio) true mvc-4)
			  (enemies (obj-antonio obj-shylock) true mvc-5)
			  (lady (obj-portia) true mvc-6)
			  (father (obj-father obj-portia) true mvc-7)
			 )
	     )
	    '(plot ((rich (obj-portia) true mv-1)
		    (marry (obj-bassanio obj-portia) unknown mv-2)
		    (desire (obj-bassanio (mv-2 true)) true mv-3)
		    (money (obj-money) true mv-4)
		    (have (obj-bassanio obj-money) unknown mv-5)
		    (if ((mv-5 true) (mv-2 true)) true mv-6)
		    (borrow (obj-antonio obj-money obj-shylock) true mv-7)
		    (give (obj-antonio obj-money obj-bassanio) true mv-8)
		    (cause (mv-8 mv-5) true mv-9)
		    (casket (obj-gold-casket) true mv-10)
		    (casket (obj-silver-casket) true mv-11)
		    (casket (obj-lead-casket) true mv-12)
		    (will (obj-will obj-father) true mv-13)
		    (choose (obj-bassanio obj-lead-casket) true mv-14)
		    (permit (obj-will mv-2) true mv-15)
		    (cause (mv-14 mv-15) true mv-16)
		    (need (obj-antonio obj-money) true mv-17)
		    (repay (obj-antonio obj-shylock) false mv-18)
		    (cause (mv-17 mv-18) true mv-19)
		    (kill (obj-shylock obj-antonio) false mv-20)
		    (desire (obj-shylock (mv-20 true)) true mv-21)
		    (cause (mv-18 mv-21) true mv-22)
		    (give (obj-bassanio obj-money obj-shylock) false mv-23)
		    (plead (obj-bassanio obj-shylock mv-23) true mv-24)
		    (refuse (obj-shylock obj-money) true mv-25)
		    (masquerade (obj-portia obj-lawyer) true mv-26)
		    (lawyer (obj-lawyer) true mv-27)
		    (desire (obj-portia (mv-30 true)) true mv-28)
		    (cannot (obj-shylock mv-20) true mv-29)
		    (convince (obj-portia obj-shylock mv-29) true mv-30)
		    (cause (mv-2 mv-28) true mv-31)
		    (cause (mv-28 mv-26) true mv-32)
		    (cause (mv-26 mv-30) true mv-33)
		   )
	     )
)

; Concerns: mv-9 -- mv-8 is causing mv-5, which is conditional, to be true.
;   mv-23 give should be take for clarity, but take connotes stealing, and
;   bassanio is freely offering the money.

; This is really sloppy and should probably be redone.


; The Tempest

(make_struc 'tempest 'play
	    '(characters ((duke (obj-prospero) true tpc-1)
			  (magician (obj-prospero) true tpc-2)
			  (siblings (obj-antonio obj-prospero) true tpc-3)
			  (daughter (obj-miranda obj-prospero) true tpc-4)
			  (king (obj-alonso) true tpc-5)
			  (siblings (obj-sebastian obj-alonso) true tpc-6)
			  (son (obj-ferdinand obj-alonso) true tpc-7)
			  (man (obj-caliban) true tpc-8)
			  (deformed (obj-caliban) true tpc-9)
			  (man (obj-antonio) true tpc-10)
			  (man (obj-sebastian) true tpc-11)
			  (spirit (obj-ariel) true tpc-12)
			 )
	     )
	    '(plot ((overthrow (obj-antonio obj-prospero) true tp-1)
		    (duke (obj-antonio) true tp-2)
		    (cause (tp-1 tp-2) true tp-3)
		    (conjoin-object (obj-prospero obj-miranda obj-exiles) true tp-4)
		    (adrift (obj-exiles) true tp-5)
		    (island (obj-island) true tp-6)
		    (land (obj-exiles obj-island) true tp-7)
		    (cave (obj-cave) true tp-8)
		    (live (obj-exiles obj-cave) true tp-9)
		    (slave (obj-caliban obj-prospero) true tp-10)
		    (release (obj-prospero obj-ariel) true tp-11)
		    (serve (obj-ariel obj-prospero) true tp-12)
		    (ship (obj-ship) true tp-13)
		    (sail (obj-alonso obj-ship) true tp-14)
		    (sail (obj-sebastian obj-ship) true tp-15)
		    (sail (obj-antonio obj-ship) true tp-16)
		    (sail (obj-ferdinand obj-ship) true tp-17)
		    (storm (obj-storm) true tp-18)
		    (conjure (obj-prospero obj-storm) true tp-19)
		    (threaten (obj-storm obj-ship) true tp-20)
		    (land (obj-ship obj-island) true tp-21)
		    (cause (tp-20 tp-21) true tp-22)
		    (lure (obj-ariel obj-ferdinand obj-cave) true tp-23)
		    (drowned (obj-ferdinand) false tp-24)
		    (believe (obj-alonso (tp-24 true)) true tp-25)
		    (cause (tp-23 tp-25) true tp-26)
		    (love (obj-ferdinand obj-miranda) true tp-27)
		    (love (obj-miranda obj-ferdinand) true tp-28)
		    (overthrow (obj-sebastian obj-alonso) false tp-29)
		    (plot (obj-sebastian tp-29) true tp-30)
		    (lure (obj-ariel obj-alonso obj-cave) true tp-31)
		    (lure (obj-ariel obj-antonio obj-cave) true tp-32)
		    (repent (obj-antonio tp-1) true tp-33)
		    (end (tp-2) true tp-34)
		    (cause (tp-33 tp-34) true tp-35)
		    (restore (tpc-1) true tp-36)
		    (cause (tp-34 tp-36) true tp-37)
		    (reunited (obj-alonso obj-ferdinand) true tp-38)
		    (cause (tp-31 tp-38) true tp-39)
		    (return-to (obj-ship obj-milan) true tp-40)
		    (return-to (obj-exiles obj-milan) true tp-41)
		    (marry (obj-ferdinand obj-miranda) true tp-42)
		   )
	     )
)

; Note:
;  the restore proposition restores the condition stated in the proposition
; that is the argument.
;  the repent proposition -- actor repents doing proposition.
;  the plot proposition -- actor plots doing proposition.
;  I want to avoid the conjoin-object, but that will require three more 
; propositions.

; Two Gentlemen of Verona

(make_struc 'two-gentlemen 'play
	    '(characters ((duke (obj-duke) true tgc-1)
			  (daughter (obj-silvia obj-duke) true tgc-2)
			  (gentleman (obj-thurio) true tgc-3)
			  (foolish (obj-thurio) true tgc-4)
			  (gentleman (obj-valentine) true tgc-5)
			  (gentleman (obj-proteus) true tgc-6)
			  (friends (obj-valentine obj-proteus) true tgc-7)
			  (woman (obj-julia) true tgc-8)
			  (outlaws (obj-outlaws) true tgc-9)
			  (group (obj-outlaws) true tgc-10)
			  (city (obj-milan) true tgc-11)
			  (page (obj-page) true tgc-12)
			 )
	     )
	    '(plot ((love (obj-proteus obj-julia) true tg-1)
		    (love (obj-julia obj-proteus) true tg-2)
		    (ring (obj-ringa) true tg-3)
		    (ring (obj-ringb) true tg-4)
		    (give (obj-julia obj-ringa obj-proteus) true tg-5)
		    (cause (tg-2 tg-5) true tg-6)
		    (give (obj-proteus obj-ringb obj-julia) true tg-7)
		    (cause (tg-1 tg-7) true tg-8)
		    (learning (conc-learning) true tg-9)
		    (want (obj-valentine conc-learning) true tg-10)
		    (journey (obj-valentine obj-milan) true tg-11)
		    (cause (tg-10 tg-11) true tg-12)
		    (love (obj-valentine obj-silvia) true tg-13)
		    (love (obj-silvia obj-valentine) true tg-14)
		    (marry (obj-thurio obj-silvia) false tg-15)
		    (desire (obj-duke (tg-15 true)) true tg-16)
		    (elope (obj-valentine obj-silvia) false tg-17)
		    (plot (obj-valentine tg-17) true tg-18)
		    (conjoin-event (tg-13 tg-16) true tg-19)
		    (cause (tg-19 tg-18) true tg-20)
		    (arrive (obj-proteus obj-milan) true tg-21)
		    (love (obj-proteus obj-silvia) true tg-22)
		    (reveal (obj-proteus tg-18 obj-duke) true tg-23)
		    (cause (tg-22 tg-23) true tg-24)
		    (banish (obj-duke obj-valentine) true tg-25)
		    (conjoin-event (tg-16 tg-23) true tg-26)
		    (cause (tg-26 tg-25) true tg-27)
		    (woo (obj-thurio obj-silvia) true tg-28)
		    (help (obj-proteus obj-thurio tg-28) false tg-29)
		    (pretend (obj-proteus tg-29) true tg-30)
		    (woo (obj-thurio obj-silvia) true tg-31)
		    (cause (tg-22 tg-30) true tg-32)
		    (cause (tg-22 tg-31) true tg-33)
		    (scorn (obj-silvia obj-proteus) true tg-34)
		    (cause (tg-1 tg-34) true tg-35)
		    (disavow (obj-proteus tg-1) true tg-36)
		    (cause (tg-34 tg-36) true tg-37)
		    (masquerade (obj-julia obj-page) true tg-38)
		    (employ (obj-proteus obj-julia tg-28) true tg-39)
		    (offer (obj-proteus obj-ringa obj-silvia) true tg-40)
		    (cause (tg-22 tg-40) true tg-41)
		    (refuse (obj-silvia obj-ringa) true tg-42)
		    (cause (tg-34 tg-42) true tg-43)
		    (leader (obj-valentine obj-outlaws) true tg-44)
		    (flee (obj-silvia obj-milan) true tg-45)
		    (search (obj-silvia obj-valentine) true tg-46)
		    (capture (obj-outlaws obj-silvia) true tg-47)
		    (free (obj-proteus obj-silvia) true tg-48)
		    (reunited (obj-valentine obj-silvia) true tg-49)
		    (repentant (obj-proteus) true tg-50)
		    (forgive (obj-valentine obj-proteus) true tg-51)
		    (offer (obj-julia obj-ringb obj-silvia) true tg-52)
		    (accident (tg-52) true tg-53)
		    (cause (tg-51 tg-53) true tg-54)
		    (recognize (obj-proteus obj-julia) true tg-55)
		    (cause (tg-52 tg-55) true tg-56)
		    (pardon (obj-duke obj-outlaws) true tg-57)
		    (permit (obj-duke tg-59) true tg-58)
		    (marry (obj-silvia obj-valentine) true tg-59)
		    (restore (tg-1) true tg-60)
		    (cause (tg-55 tg-60) true tg-61)
		    (marry (obj-proteus obj-julia) true tg-62)
		   )
	     )
)

; Notes: 
;   the Employ proposition says that actor employs second person for 
;  proposition (i.e. proteus employs julia to help him woo silvia.)
;   the Help proposition says that the actor helps the second person
;  in doing the proposition (i.e. proteus helps thurio woo silvia, which
;  is false.)
;   disavow says that proteus is disavowing his love for julia, and his love
;  for julia is restored when he recognizes her because of her accidental 
;  offering of ringb (instead of ringa) to silvia.
;   I say that Proteus is repentant, but i could just as easily say
;  (apologive (obj-proteus obj-valentine tg-23) true) -- tg-23 is the
;  reveal proposition, and then I could say that valentine forgives
;  proteus for the same proposition.

; As You Like It

(make_struc 'as-you-like-it 'play
	    '(characters ((duke (obj-old-duke) true asc-1)
			  (brother (obj-frederick obj-old-duke) true asc-2)
			  (friend (obj-sir-rowland obj-old-duke) true asc-3)
			  (son (obj-oliver obj-sir-rowland) true asc-4)
			  (son (obj-orlando obj-sir-rowland) true asc-5)
			  (daughter (obj-rosalind obj-old-duke) true asc-6)
			  (daughter (obj-celia obj-frederick) true asc-7)
			  (champion (obj-charles) true asc-8)
			  (forest (obj-arden) true asc-9)
			  (shepherd (obj-silvius) true asc-10)
			  (shepherdess (obj-phoebe) true asc-11)
			  (shepherd (obj-ganymede) true asc-12)
			  (hermit (obj-hermit) true asc-13)
			 )
	     )
	    '(plot ((depose (obj-frederick obj-old-duke) true as-1)
		    (duke (obj-frederick) true as-2)
		    (cause (as-1 as-2) true as-3)
		    (banish (obj-frederick obj-old-duke) true as-4)
		    (live (obj-old-duke obj-arden) true as-5)
		    (cause (as-4 as-5) true as-6)
		    (wrestle (obj-orlando obj-charles) true as-7)
		    (defeat (obj-orlando obj-charles) true as-8)
		    (love (obj-orlando obj-rosalind) true as-9)
		    (love (obj-rosalind obj-orlando) true as-10)
		    (necklace (obj-chain) true as-11)
		    (give (obj-rosalind obj-chain obj-orlando) true as-12)
		    (cause (as-10 as-12) true as-13)
		    (hate (obj-frederick obj-orlando) true as-14)
		    (conjoin-event (asc-3 asc-5) true as-15)
		    (cause (as-15 as-14) true as-16)
		    (learn (obj-frederick as-10) true as-17)
		    (banish (obj-frederick obj-rosalind) true as-18)
		    (conjoin-event (as-10 as-14) true as-19)
		    (cause (as-19 as-18) true as-20)
		    (masquerade (obj-rosalind obj-ganymede) true as-21)
		    (enter (obj-rosalind obj-arden) true as-22)
		    (accompany (obj-celia obj-rosalind) true as-23)
		    (mistreat (obj-oliver obj-orlando) true as-24)
		    (journey (obj-orlando obj-arden) true as-25)
		    (cause (as-24 as-25) true as-26)
		    (meet (obj-orlando obj-old-duke) true as-27)
		    (welcome (obj-old-duke obj-orlando) true as-28)
		    (cause (as-15 as-28) true as-29)
		    (verse (obj-verse) true as-30)
		    (compose (obj-orlando obj-verse) true as-31)
		    (trees (obj-trees) true as-32)
		    (attach (obj-orlando obj-verse obj-trees) true as-33)
		    (cause (as-9 as-31) true as-34)
		    (cause (as-9 as-33) true as-35)
		    (mock (obj-ganymede obj-orlando) true as-36)
		    (cause (as-33 as-36) true as-37)
		    (love (obj-silvius obj-phoebe) true as-38)
		    (love (obj-phoebe obj-ganymede) true as-39)
		    (rescue (obj-oliver obj-orlando) true as-40)
		    (repentant (obj-oliver) true as-41)
		    (cause (as-40 as-41) true as-42)
		    (wounded (obj-orlando) true as-43)
		    (cause (as-40 as-43) true as-44)
		    (worried (obj-oliver) true as-45)
		    (cause (as-43 as-45) true as-46)
		    (love (obj-celia obj-oliver) true as-47)
		    (cause (as-45 as-47) true as-48)
		    (meet (obj-frederick obj-hermit) true as-49)
		    (religious (obj-frederick) false as-50)
		    (become-true (as-50) true as-51)
		    (restore (asc-1) true as-52)
		    (end (as-21) true as-53)
		    (marry (obj-orlando obj-rosalind) true as-54)
		    (marry (obj-oliver obj-celia) true as-55)
		    (marry (obj-phoebe obj-silvius) true as-56)
		   )
	     )
)

; Much Ado About Nothing

(make_struc 'much-ado 'play
	    '(characters ((prince (obj-don-pedro) true muc-1)
			  (brother (obj-don-john obj-don-pedro) true muc-2)
			  (nobleman (obj-claudio) true muc-3)
			  (nobleman (obj-benedick) true muc-4)
			  (friend (obj-claudio obj-don-pedro) true muc-5)
			  (friend (obj-benedick obj-don-pedro) true muc-6)
			  (governor (obj-leonato) true muc-7)
			  (daughter (obj-hero obj-leonato) true muc-8)
			  (niece (obj-beatrice obj-leonato) true muc-9)
			  (constable (obj-dogberry) true muc-10)
			  (bachelor (obj-benedick) true muc-11)
			 )
	     )
	    '(plot ((love (obj-claudio obj-hero) true mu-1)
		    (woo (obj-claudio obj-hero) true mu-2)
		    (masquerade (obj-don-pedro obj-claudio) true mu-3)
		    (assist (obj-don-pedro mu-2) true mu-4)
		    (cause (mu-4 mu-3) true mu-5)
		    (marry (obj-claudio obj-hero) true mu-6)
		    (consent (obj-leonato mu-6) true mu-7)
		    (planned (mu-7) true mu-8)
		    (bitter (obj-benedick) true mu-9)
		    (marriage (conc-marriage) true mu-10)
		    (oppose (obj-benedick conc-marriage) true mu-11)
		    (oppose (obj-beatrice conc-marriage) true mu-12)
		    (quarrel (obj-benedick obj-beatrice) true mu-13)
		    (discredit (obj-don-john obj-hero) true mu-14)
		    (plot (obj-don-john mu-14) true mu-15)
		    (unfaithful (obj-hero) false mu-16)
		    (believe (obj-claudio (mu-16 true)) true mu-17)
		    (believe (obj-leonato (mu-16 true)) true mu-18)
		    (cause (mu-15 mu-17) true mu-19)
		    (cause (mu-15 mu-18) true mu-20)
		    (forswear (obj-claudio mu-1) true mu-21)
		    (cause (mu-17 mu-21) true mu-22)
		    (faint (obj-hero) true mu-23)
		    (cause (mu-21 mu-23) true mu-24)
		    (dead (obj-hero) false mu-25)
		    (believe (obj-claudio (mu-25 true)) true mu-26)
		    (cause (mu-26 mu-23) true mu-27)
		    (reveal (obj-dogberry mu-15 obj-leonato) true mu-28)
		    (reveal (obj-dogberry mu-15 obj-claudio) true mu-29)
		    (avenged (obj-leonato) unknown mu-30)
		    (marry (obj-claudio obj-beatrice) unknown mu-31)
		    (if ((mu-30 true) (mu-31 true)) true mu-32)
		    (pretend (obj-leonato mu-32) true mu-33)
		    (agree (obj-claudio mu-31) true mu-34)
		    (substitute (obj-hero obj-beatrice) true mu-35)
		    (occur (mu-6) true mu-36)
		    (love (obj-benedick obj-beatrice) true mu-37)
		    (love (obj-beatrice obj-benedick) true mu-38)
		    (marry (obj-beatrice obj-benedick) true mu-39)
		    (punish (obj-don-pedro obj-don-john) true mu-40)
		    (cause (mu-15 mu-40) true mu-41)
		   )
	     )
)	    


; Twelfth Night

(make_struc 'twelfth-night 'play
	    '(characters ((man (obj-sebastian) true tnc-1)
			  (woman (obj-viola) true tnc-2)
			  (twins (obj-viola obj-sebastian) true tnc-3)
			  (man (obj-cesario) true tnc-4)
			  (duke (obj-orsino) true tnc-5)
			  (countess (obj-olivia) true tnc-6)
			  (captain (obj-antonio) true tnc-7)
			  (nobleman (obj-sir-andrew) true tnc-8)
			  (police (obj-police) true tnc-9)
			 )
	     )
	    '(plot ((ship (obj-ship) true tn-1)
		    (sail (obj-viola obj-ship) true tn-2)
		    (sail (obj-sebastian obj-ship) true tn-3)
		    (storm (obj-storm) true tn-4)
		    (wreck (obj-storm obj-ship) true tn-5)
		    (separated (obj-viola obj-sebastian) true tn-6)
		    (cause (tn-5 tn-6) true tn-7)
		    (dead (obj-viola) false tn-8)
		    (dead (obj-sebastian) false tn-9)
		    (believe (obj-viola (tn-9 true)) true tn-10)
		    (believe (obj-sebastian (tn-8 true)) true tn-11)
		    (masquerade (obj-viola obj-cesario) true tn-12)
		    (same (obj-viola obj-cesario) true tn-13)
		    (page (obj-cesario) true tn-14)
		    (attendant (obj-cesario obj-orsino) true tn-15)
		    (love (obj-orsino obj-olivia) true tn-16)
		    (send (obj-orsino obj-cesario tn-18) true tn-17)
		    (woo (obj-cesario obj-olivia) true tn-18)
		    (cause (tn-16 tn-17) true tn-19)
		    (love (obj-olivia obj-cesario) true tn-20)
		    (ring (obj-ring) true tn-21)
		    (give (obj-olivia obj-ring obj-cesario) true tn-22)
		    (cause (tn-20 tn-22) true tn-23)
		    (love (obj-viola obj-orsino) true tn-24)
		    (love (obj-sir-andrew obj-olivia) true tn-25)
		    (conjoin-event (tn-20 tn-25) true tn-26)
		    (jealous (obj-sir-andrew) true tn-27)
		    (cause (tn-26 tn-27) true tn-28)
		    (challenge (obj-sir-andrew obj-cesario) true tn-29)
		    (rescue (obj-antonio obj-sebastian) true tn-30)
		    (friends (obj-antonio obj-sebastian) true tn-31)
		    (visit (obj-sebastian obj-orsino) true tn-32)
		    (accompany (obj-antonio obj-sebastian) true tn-33)
		    (purse (obj-purse) true tn-34)
		    (give (obj-antonio obj-purse obj-sebastian) true tn-35)
		    (safe (obj-purse) true tn-36)
		    (cause (tn-35 tn-36) true tn-37)
		    (separate (obj-antonio obj-sebastian) true tn-38)
		    (duel (obj-cesario obj-sir-andrew) true tn-39)
		    (cause (tn-29 tn-39) true tn-40)
		    (see (obj-antonio tn-39) true tn-41)
		    (same (obj-cesario obj-sebastian) false tn-42)
		    (believe (obj-antonio (tn-42 true)) true tn-43)
		    (rescue (obj-antonio obj-cesario) true tn-44)
		    (cause (tn-43 tn-44) true tn-45)
		    (arrest (obj-police obj-antonio) true tn-46)
		    (return (obj-cesario obj-purse obj-antonio) false tn-47)
		    (request (obj-antonio (tn-47 true)) true tn-48)
		    (cause (tn-43 tn-48) true tn-49)
		    (know (obj-cesario obj-antonio) false tn-50)
		    (have (obj-cesario obj-purse) false tn-51)
		    (angry (obj-antonio obj-sebastian) true tn-52)
		    (conjoin-event (tn-43 tn-47) true tn-53)
		    (cause (tn-53 tn-52) true tn-54)
		    (believe (obj-sir-andrew (tn-42 true)) true tn-55)
		    (duel (obj-sir-andrew obj-sebastian) true tn-56)
		    (cause (tn-55 tn-56) true tn-57)
		    (wound (obj-sebastian obj-sir-andrew) true tn-58)
		    (believe (obj-olivia (tn-42 true)) true tn-59)
		    (conjoin-event (tn-20 tn-59) true tn-60)
		    (marry (obj-olivia obj-sebastian) true tn-61)
		    (cause (tn-60 tn-61) true tn-62)
		    (believe (obj-orsino (tn-42 true)) true tn-63)
		    (conjoin-event (tn-16 tn-61) true tn-64)
		    (conjoin-event (tn-63 tn-64) true tn-65)
		    (angry (obj-orsino obj-cesario) true tn-66)
		    (cause (tn-65 tn-66) true tn-67)
		    (end (tn-12) true tn-68)
		    (reunited (obj-viola obj-sebastian) true tn-69)
		    (marry (obj-viola obj-orsino) true tn-70)
		   )
	     )
)

; Concerns:
;   should include the following "cause" propositions:
; (cause (tn-5 tn-6) true)
; All (believe (person (tn-42 true))) propositions should be cause by the fact
; that viola and sebastian are twins, and the fact that viola and cesario are 
; the same.
;   Also: all propositions dealing with the purse could be left out (tn-34,
; 35, 36, 47, 48, 51).


; Love's Labour's Lost

(make_struc 'loves-labours 'play
	    '(characters ((king (obj-ferdinand) true llc-1)
			  (lord (obj-berowne) true llc-2)
			  (lord (obj-longaville) true llc-3)
			  (lord (obj-dumaine) true llc-4)
			  (clown (obj-costard) true llc-5)
			  (man (obj-armado) true llc-6)
			  (conjoin-object (obj-berowne obj-longaville obj-bl)
					  true llc-7)
			  (conjoin-object (obj-bl obj-dumaine obj-lords) true llc-8)
			  (attendants (obj-lords obj-ferdinand) true llc-9)
			  (fool (obj-armado) true llc-10)
			  (princess (obj-princess) true llc-11)
			  (lady (obj-rosaline) true llc-12)
			  (lady (obj-maria) true llc-13)
			  (lady (obj-katharine) true llc-14)
			  (conjoin-object (obj-rosaline obj-maria obj-rm) true llc-15)
			  (conjoin-object (obj-rm obj-katharine obj-ladies)
					   true llc-16)
			  (attendants (obj-ladies obj-princess) true llc-17)
			  (wench (obj-jaquenetta) true llc-18)
			  (country (obj-navarre) true llc-19)
			 )
	     )
	    '(plot ((vow (conc-vow) true ll-1)
		    (fast (conc-vow) true ll-2)
		    (studying (conc-vow) true ll-3)
		    (abstention (conc-vow) true ll-4)
		    (vow-that (obj-ferdinand conc-vow) true ll-5)
		    (vow-that (obj-lords conc-vow) true ll-6)
		    (insincere (obj-lords) true ll-7)
		    (love (obj-costard obj-jaquenetta) true ll-8)
		    (love (obj-armado obj-jaquenetta) true ll-9)
		    (reveal (obj-armado ll-8 obj-ferdinand) true ll-10)
		    (punish (obj-ferdinand obj-costard) true ll-11)
		    (arrive (obj-princess obj-navarre) true ll-12)
		    (accompany (obj-ladies obj-princess) true ll-13)
		    (rude (obj-ferdinand obj-princess) true ll-14)
		    (cause (ll-5 ll-14) true ll-15)
		    (love (obj-ferdinand obj-princess) true ll-16)
		    (love (obj-berowne obj-rosaline) true ll-17)
		    (letter (obj-letter1) true ll-18)
		    (write (obj-berowne obj-letter1) true ll-19)
		    (give (obj-costard obj-letter1 obj-rosaline) false ll-20)
		    (order (obj-berowne (ll-20 true)) true ll-21)
		    (letter (obj-letter2) true ll-22)
		    (write (obj-armado obj-letter2) true ll-23)
		    (give (obj-costard obj-letter2 obj-jaquenetta) false ll-24)
		    (order (obj-armado (ll-24 true)) true ll-25)
		    (exchange (obj-costard obj-letter1 obj-letter2) true ll-26)
		    (give (obj-costard obj-letter1 obj-jaquenetta) true ll-27)
		    (give (obj-costard obj-letter2 obj-rosaline) true ll-28)
		    (sonnet (obj-sonnet) true ll-29)
		    (compose (obj-ferdinand obj-sonnet) true ll-30)
		    (cause (ll-16 ll-30) true ll-31)
		    (love (obj-longaville obj-maria) true ll-32)
		    (verse (obj-verse) true ll-33)
		    (compose (obj-longaville obj-verse) true ll-34)
		    (cause (ll-32 ll-34) true ll-35)
		    (love (obj-dumaine obj-katharine) true ll-36)
		    (poem (obj-poem) true ll-37)
		    (compose (obj-dumaine obj-poem) true ll-38)
		    (cause (ll-36 ll-38) true ll-39)
		    (break (obj-ferdinand conc-vow) true ll-40)
		    (break (obj-lords conc-vow) true ll-41)
		    (mock (obj-princess obj-ferdinand) true ll-42)
		    (cause (ll-40 ll-42) true ll-43)
		    (mock (obj-ladies obj-lords) true ll-44)
		    (cause (ll-41 ll-44) true ll-45)
		    (hermit (obj-ferdinand) unknown ll-46)
		    (marry (obj-princess obj-ferdinand) unknown ll-47)
		    (if ((ll-46 true) (ll-47 true)) true ll-48)
		    (orders (obj-orders) true ll-49)
		    (obey (obj-lords obj-orders) unknown ll-50)
		    (order (obj-ladies (ll-50 true)) true ll-51)
		    (marry (obj-ladies obj-lords) unknown ll-52)
		    (if ((ll-50 true) (ll-52 true)) true ll-53)
		   )
	     )
)

; Concerns:
;  conjoin-objects are ugly.
;  this is very long.
;  prop ll-52, where all the ladies marry all the lords?


; Winter's Tale

(make_struc 'winters-tale 'play
	    '(characters ((king-of (obj-polixenes obj-bohemia) true wtc-1)
			  (king-of (obj-leontes obj-sicilia) true wtc-2)
			  (friends (obj-polixenes obj-leontes) true wtc-3)
			  (queen (obj-hermione) true wtc-4)
			  (married (obj-leontes obj-hermione) true wtc-5)
			  (man (obj-camillo) true wtc-6)
			  (counselor (obj-camillo) true wtc-7)
			  (girl (obj-perdita) true wtc-8)
			  (daughter (obj-perdita obj-hermione) true wtc-9)
			  (boy (obj-florizel) true wtc-10)
			  (prince (obj-florizel) true wtc-11)
			  (woman (obj-paulina) true wtc-12)
			  (attendant (obj-paulina obj-hermione) true wtc-13)
			  (man (obj-antigonus) true wtc-14)
			  (married (obj-antigonus obj-paulina) true wtc-15)
			  (shepherd (obj-shepherd) true wtc-16)
			  (son (obj-mamillus obj-hermione) true wtc-17)
			  (country (obj-sicilia) true wtc-18)
			  (country (obj-bohemia) true wtc-19)
			 )
	     )
	    '(plot ((lovers (obj-polixenes obj-hermione) false wt-1)
		    (believe (obj-leontes (wt-1 true)) true wt-2)
		    (jealous (obj-leontes) true wt-3)
		    (cause (wt-2 wt-3) true wt-4)
		    (poison (obj-camillo obj-leontes) false wt-5)
		    (order (obj-leontes (wt-5 true)) true wt-6)
		    (cause (wt-3 wt-6) true wt-7)
		    (reveal (obj-camillo wt-6 obj-polixenes) true wt-8)
		    (leave (obj-polixenes obj-sicilia) true wt-9)
		    (accompany (obj-camillo obj-polixenes) true wt-10)
		    (accuse-of (obj-leontes obj-hermione (wt-1 true)) true wt-11)
		    (imprison (obj-leontes obj-hermione) true wt-12)
		    (cause (wt-2 wt-12) true wt-13)
		    (give-birth-to (obj-hermione obj-perdita) true wt-14)
		    (abandon (obj-antigonus obj-perdita) true wt-15)
		    (order (obj-leontes wt-15) true wt-16)
		    (cause (wt-2 wt-16) true wt-17)
		    (find (obj-shepherd obj-perdita) true wt-18)
		    (raise (obj-shepherd obj-perdita) true wt-19)
		    (bear (obj-bear) true wt-20)
		    (kill (obj-bear obj-antigonus) true wt-21)
		    (conjoin-event (wt-11 wt-12) true wt-22)
		    (conjoin-event (wt-22 wt-16) true wt-23)
		    (cause (wt-23 wt-25) true wt-24)
		    (die (obj-mamillus) true wt-25)
		    (faint (obj-hermione) true wt-26)
		    (cause (wt-25 wt-26) true wt-27)
		    (alive (obj-hermione) true wt-28)
		    (say (obj-paulina (wt-28 false) obj-leontes) true wt-29)
		    (believe (obj-leontes (wt-28 false)) true wt-30)
		    (grieve (obj-leontes) true wt-31)
		    (repent (obj-leontes wt-2) true wt-32)
		    (unaware (obj-florizel (wtc-9 true)) true wt-33)
		    (unaware (obj-polixenes (wtc-9 true)) true wt-34)
		    (love (obj-florizel obj-perdita) true wt-35)
		    (marry (obj-florizel obj-perdita) unknown wt-36)
		    (forbid (obj-polixenes (wt-36 true)) true wt-37)
		    (cause (wt-34 wt-37) true wt-38)
		    (journey (obj-florizel obj-sicilia) true wt-39)
		    (accompany (obj-perdita obj-florizel) true wt-40)
		    (help (obj-camillo wt-39) true wt-41)
		    (chase (obj-polixenes obj-florizel) true wt-42)
		    (accompany (obj-camillo obj-polixenes) true wt-43)
		    (reveal (obj-shepherd wt-18 obj-leontes) true wt-44)
		    (convinced (obj-leontes (wtc-9 true)) true wt-45)
		    (reunited (obj-leontes obj-perdita) true wt-46)
		    (joyfully (wt-46) true wt-47)
		    (consent (obj-polixenes (wt-36 true)) true wt-48)
		    (become-true (wt-36) true wt-49)
		    (statue-of (obj-statue obj-hermione) true wt-50)
		    (visit (obj-leontes obj-statue) true wt-51)
		    (alive (obj-statue) true wt-52)
		    (same (obj-statue obj-hermione) true wt-53)
		    (reunited (obj-leontes obj-hermione) true wt-54)
		   )
	     )
)

; Concerns: note the passage of 16 years between propositions wt-32 and wt-35.
;   also -- does wt-37 say that polixenes forbids propn wt-36 from becoming
;  true?  cause that's what it should say.
;   Note propns 100-104.  Which ones to use?
;   note wt-28 -- perhaps it should be "dead", as I do in all other plays?


; A Midsummer Night's Dream

(make_struc 'midsummer-night 'play
	    '(characters ((man (obj-lysander) true mnc-1)
			  (man (obj-demetrius) true mnc-2)
			  (woman (obj-helena) true mnc-3)
			  (woman (obj-hermia) true mnc-4)
			  (father (obj-egeus obj-hermia) true mnc-5)
			  (duke (obj-theseus) true mnc-6)
			  (queen (obj-hippolyta) true mnc-7)
			  (man (obj-bottom) true mnc-9)
			  (weaver (obj-bottom) true mnc-10)
			  (fairie (obj-titania) true mnc-11)
			  (queen (obj-titania) true mnc-12)
			  (fairie (obj-oberon) true mnc-13)
			  (king (obj-oberon) true mnc-14)
			  (fairie (obj-puck) true mnc-15)
			  (messenger (obj-puck) true mnc-16)
			  (prankster (obj-puck) true mnc-17)
			  (guild (obj-guild) true mnc-18)
			  (laborers (obj-guild) true mnc-19)
			  (member-of (obj-bottom obj-guild) true mnc-20)
			 )
	     )
	    '(plot ((love (obj-hermia obj-lysander) true mn-1)
		    (love (obj-lysander obj-hermia) true mn-2)
		    (love (obj-demetrius obj-hermia) true mn-3)
		    (love (obj-helena obj-demetrius) true mn-4)
		    (marry (obj-demetrius obj-hermia) unknown mn-5)
		    (desire (obj-demetrius (mn-5 true)) true mn-6)
		    (desire (obj-egeus (mn-6 true)) true mn-7)
		    (uphold (obj-theseus mn-7) true mn-8)
		    (marry (obj-lysander obj-hermia) unknown mn-9)
		    (desire (obj-lysander (mn-9 true)) true mn-10)
		    (desire (obj-hermia (mn-9 true)) true mn-11)
		    (plan (obj-lysander (mn-9 true)) true mn-12)
		    (plan (obj-hermia (mn-9 true)) true mn-13)
		    (marry (obj-theseus obj-hippolyta) unknown mn-14)
		    (planned ((mn-14 true)) true mn-15)
		    (play (obj-play) true mn-16)
		    (rehearse (obj-guild obj-play) true mn-17)
		    (woods (obj-woods) true mn-18)
		    (enter (obj-lysander obj-woods) true mn-19)
		    (enter (obj-hermia obj-woods) true mn-20)
		    (enter (obj-guild obj-woods) true mn-21)
		    (reveal (obj-helena mn-13 obj-demetrius) true mn-22)
		    (cause (mn-4 mn-22) true mn-23)
		    (follow (obj-demetrius obj-hermia) true mn-24)
		    (cause (mn-3 mn-24) true mn-25)
		    (follow (obj-helena obj-demetrius) true mn-26)
		    (cause (mn-4 mn-26) true mn-27)
		    (scorn (obj-demetrius obj-helena) true mn-28)
		    (hear (obj-oberon mn-28) true mn-29)
		    (pity (obj-oberon obj-helena) true mn-30)
		    (juice (obj-juice) true mn-31)
		    (get (obj-puck obj-juice) true mn-32)
		    (eye-of (obj-eye1 obj-demetrius) true mn-33)
		    (put-in (obj-puck obj-juice obj-eye1) unknown mn-34)
		    (order (obj-oberon (mn-34 true)) true mn-35)
		    (eye-of (obj-eye2 obj-lysander) true mn-36)
		    (put-in (obj-puck obj-juice obj-eye2) true mn-37)
		    (mistake (mn-37) true mn-38)
		    (wake-up (obj-helena obj-lysander) true mn-39)
		    (love (obj-lysander obj-helena) true mn-40)
		    (conjoin-event (mn-37 mn-39) true mn-41)
		    (cause (mn-41 mn-40) true mn-42)
		    (mock (obj-lysander obj-helena) false mn-43)
		    (believe (obj-helena (mn-43 true)) true mn-44)
		    (pursue (obj-lysander obj-helena) true mn-45)
		    (awaken (obj-hermia) true mn-46)
		    (killed (obj-lysander) false mn-47)
		    (believe (obj-hermia (mn-47 true)) true mn-48)
		    (cause (mn-45 mn-48) true mn-49)
		    (ass (obj-ass) true mn-50)
		    (head-of (obj-head obj-ass) true mn-51)
		    (put-on (obj-puck obj-head obj-bottom) true mn-52)
		    (eye-of (obj-eye3 obj-titania) true mn-53)
		    (put-in (obj-puck obj-juice obj-eye3) true mn-54)
		    (love (obj-titania obj-bottom) true mn-55)
		    (cause (mn-54 mn-55) true mn-56)
		    (learn (obj-oberon mn-37) true mn-57)
		    (put-in (obj-oberon obj-juice obj-eye1) true mn-58)
		    (love (obj-demetrius obj-helena) true mn-59)
		    (cause (mn-58 mn-59) true mn-60)
		    (ridicule (obj-demetrius obj-helena) false mn-61)
		    (believe (obj-helena (mn-61 true)) true mn-62)
		    (tire (obj-puck obj-demetrius) true mn-63)
		    (tire (obj-puck obj-lysander) true mn-64)
		    (sleep (obj-demetrius) true mn-65)
		    (sleep (obj-lysander) true mn-66)
		    (antidote (obj-antidote) true mn-67)
		    (put-in (obj-puck obj-antidote obj-eye2) true mn-68)
		    (end (mn-40) true mn-69)
		    (restore (mn-2) true mn-70)
		    (put-in (obj-oberon obj-antidote obj-eye3) true mn-71)
		    (end (mn-55) true mn-72)
		    (remove (obj-puck obj-head) true mn-73)
		    (return-to (obj-bottom obj-guild) true mn-74)
		    (become-true (mn-14) true mn-75)
		    (become-true (mn-5) true mn-76)
		    (marry (obj-helena obj-demetrius) true mn-77)
		    (perform (obj-guild obj-play) true mn-78)
		   )
	     )
)

; 97 propositions, but who's counting?
; note: proposition mnc-8 is deliberately missing.

; Taming of the Shrew

(make_struc 'taming-shrew 'play
	    '(characters ((man (obj-lucentio) true tsc-1)
			  (student (obj-lucentio) true tsc-2)
			  (servant (obj-tranio obj-lucentio) true tsc-3)
			  (gentleman (obj-baptista) true tsc-4)
			  (rich (obj-baptista) true tsc-5)
			  (daughter (obj-katharina obj-baptista) true tsc-6)
			  (shrew (obj-katharina) true tsc-7)
			  (daughter (obj-bianca obj-baptista) true tsc-8)
			  (gentleman (obj-gremio) true tsc-9)
			  (gentleman (obj-hortensio) true tsc-10)
			  (man (obj-petruchio) true tsc-11)
			  (rich (obj-petruchio) true tsc-12)
			  (noble (obj-petruchio) true tsc-13)
			  (town (obj-padua) true tsc-14)
			  (friends (obj-petruchio obj-hortensio) true tsc-15)
			  (widow (obj-widow) true tsc-16)
			  (rich (obj-widow) true tsc-17)
			 )
	     )
	    '(plot ((journey (obj-lucentio obj-padua) true ts-1)
		    (accompany (obj-tranio obj-lucentio) true ts-2)
		    (study (obj-lucentio) true ts-3)
		    (meet (obj-lucentio obj-baptista) true ts-4)
		    (love (obj-gremio obj-bianca) true ts-5)
		    (love (obj-hortensio obj-bianca) true ts-6)
		    (marry (obj-gremio obj-bianca) unknown ts-7)
		    (desire (obj-gremio (ts-7 true)) true ts-8)
		    (marry (obj-hortensio obj-bianca) unknown ts-9)
		    (desire (obj-hortensio (ts-9 true)) true ts-10)
		    (husband (obj-husband) true ts-11)
		    (marry (obj-katharina obj-husband) unknown ts-12)
		    (find (obj-gremio obj-husband) unknown ts-13)
		    (must (obj-gremio (ts-13 true)) true ts-14)
		    (before ((ts-13 true) (ts-7 true)) true ts-15)
		    (find (obj-hortensio obj-husband) unknown ts-16)
		    (must (obj-hortensio (ts-16 true)) true ts-17)
		    (before ((ts-17 true) (ts-9 true)) true ts-18)
		    (love (obj-lucentio obj-bianca) true ts-19)
		    (masquerade (obj-tranio obj-lucentio) true ts-20)
		    (masquerade (obj-lucentio obj-tutor1) true ts-21)
		    (tutor (obj-tutor1) true ts-22)
		    (woo (obj-lucentio obj-bianca) true ts-23)
		    (arrive (obj-petruchio obj-padua) true ts-24)
		    (marry (obj-petruchio obj-katharina) true ts-25)
		    (desire (obj-petruchio ts-25) true ts-26)
		    (desire (obj-baptista ts-25) true ts-27)
		    (marry (obj-tranio obj-bianca) unknown ts-28)
		    (desire (obj-tranio (ts-28 true)) true ts-29)
		    (love (obj-bianca obj-lucentio) true ts-30)
		    (forswear (obj-hortensio ts-6) true ts-31)
		    (forswear (obj-gremio ts-5) true ts-32)
		    (marry (obj-lucentio obj-bianca) true ts-33)
		    (marry (obj-hortensio obj-widow) true ts-34)
		   )
	     )
)


; Timon of Athens

(make_struc 'timon-of-athens 'play
	    '(characters ((lord (obj-timon) true tac-1)
			  (rich (obj-timon) true tac-2)
			  (man (obj-ventidius) true tac-3)
			  (friend (obj-ventidius obj-timon) true tac-4)
			  (man (obj-apemantus) true tac-5)
			  (friend (obj-apemantus obj-timon) true tac-6)
			  (general (obj-alcibiades) true tac-7)
			  (steward (obj-flavius obj-timon) true tac-8)
			  (city (obj-athens) true tac-9)
			 )
	     )
	    '(plot ((extravagant (obj-timon) true ta-1)
		    (generous (obj-timon) true ta-2)
		    (debt (obj-debt) true ta-3)
		    (owe (obj-ventidius obj-debt) true ta-4)
		    (jailed (obj-ventidius) true ta-5)
		    (cause (ta-4 ta-5) true ta-6)
		    (pay (obj-timon obj-debt) true ta-7)
		    (support (obj-timon obj-ventidius) true ta-8)
		    (criticize-for (obj-apemantus obj-timon ta-2) true ta-9)
		    (repay (obj-ventidius obj-timon) false ta-10)
		    (offer (obj-ventidius (ta-10 true)) true ta-11)
		    (refuse (obj-timon (ta-10 true)) true ta-12)
		    (insolvent (obj-timon) true ta-13)
		    (cause (ta-2 ta-13) true ta-14)
		    (borrow (obj-timon obj-money) false ta-15)
		    (attempt (obj-timon (ta-15 true)) true ta-16)
		    (unable (obj-timon (ta-15 true)) true ta-17)
		    (enraged (obj-timon) true ta-18)
		    (cause (ta-17 ta-18) true ta-19)
		    (misanthrope (obj-timon) true ta-20)
		    (leave (obj-timon obj-athens) true ta-21)
		    (seashore (obj-seashore) true ta-22)
		    (live (obj-timon obj-seashore) true ta-23)
		    (banished (obj-alcibiades obj-athens) true ta-24)
		    (beseige (obj-alcibiades obj-athens) unknown ta-25)
		    (plan (obj-alcibiades (ta-25 true)) true ta-26)
		    (cause (ta-24 ta-26) true ta-27)
		    (dig-for (obj-timon obj-roots) true ta-28)
		    (roots (obj-roots) true ta-29)
		    (gold (obj-gold) true ta-30)
		    (find (obj-timon obj-gold) true ta-31)
		    (curse (obj-timon obj-gold) true ta-32)
		    (find (obj-alcibiades obj-timon) true ta-33)
		    (give (obj-timon obj-gold obj-alcibiades) true ta-34)
		    (find (obj-flavius obj-timon) true ta-35)
		    (give (obj-timon obj-gold obj-flavius) true ta-36)
		    (find (obj-senators obj-timon) true ta-37)
		    (lend (obj-senators obj-money obj-timon) unknown ta-38)
		    (offer (obj-senators (ta-38 true)) true ta-39)
		    (refuse (obj-timon (ta-38 true)) true ta-40)
		    (curse (obj-timon obj-athens) true ta-41)
		    (criticize (obj-apemantus obj-timon) true ta-42)
		    (spare (obj-alcibiades obj-athens) true ta-43)
		    (die (obj-timon) true ta-44)
		   )
	     )
)


; Pericles, Prince of Tyre

(make_struc 'pericles 'play
	    '(characters ((prince (obj-pericles) true pec-1)
			  (king-of (obj-antiochus obj-antioch) true pec-2)
			  (daughter (obj-daughter1 obj-antiochus) true pec-3)
			  (country (obj-antioch) true pec-4)
			  (agents (obj-agents) true pec-5)
			  (country (obj-pentapolis) true pec-6)
			  (king-of (obj-simonides obj-pentapolis) true pec-7)
			  (daughter (obj-thaisa obj-simonides) true pec-8)
			  (lords (obj-tyrians) true pec-9)
			  (country (obj-tyre) true pec-10)
			  (physician (obj-physician) true pec-11)
			  (country (obj-tarsus) true pec-12)
			  (governor-of (obj-cleon obj-tarsus) true pec-13)
			  (daughter (obj-daughter2 obj-cleon) true pec-14)
			  (pirates (obj-pirates) true pec-15)
			  (servant (obj-servant) true pec-16)
			  (country (obj-mytilene) true pec-17)
			  (governor-of (obj-lysimachus obj-mytilene) true pec-18)
			 )
	     )
	    '(plot ((love (obj-antiochus obj-daughter1) true pe-1)
		    (incestuous (pe-1) true pe-2)
		    (marry (obj-pericles obj-daughter1) unknown pe-3)
		    (desire (obj-pericles (pe-3 true)) true pe-4)
		    (riddle (obj-riddle) true pe-5)
		    (solve (obj-pericles obj-riddle) unknown pe-6)
		    (if ((pe-6 true) (pe-3 true)) true pe-7)
		    (reveal (obj-riddle pe-1 obj-pericles) true pe-8)
		    (fear (obj-antiochus obj-pericles) true pe-9)
		    (cause (pe-8 pe-9) true pe-10)
		    (flee (obj-pericles obj-antioch) true pe-11)
		    (kill (obj-agents obj-pericles) unknown pe-12)
		    (order (obj-antiochus (pe-12 true)) true pe-13)
		    (cause (pe-9 pe-13) true pe-14)
		    (follow (obj-agents obj-pericles) true pe-15)
		    (fear (obj-pericles obj-agents) true pe-16)
		    (travel (obj-pericles) true pe-17)
		    (cause (pe-16 pe-17) true pe-18)
		    (castaway (obj-pericles) true pe-19)
		    (arrive (obj-pericles obj-pentapolis) true pe-20)
		    (tournament (obj-tournament) true pe-21)
		    (honor (obj-tournament obj-thaisa) true pe-22)
		    (win (obj-pericles obj-tournament) true pe-23)
		    (love (obj-thaisa obj-pericles) true pe-24)
		    (marry (obj-thaisa obj-pericles) true pe-25)
		    (die (obj-antiochus) true pe-26)
		    (safe (obj-pericles) true pe-27)
		    (dead (obj-pericles) false pe-28)
		    (believe (obj-tyrians (pe-28 true)) true pe-29)
		    (journey (obj-pericles obj-tyre) true pe-30)
		    (accompany (obj-thaisa obj-pericles) true pe-31)
		    (give-birth-to (obj-thaisa obj-marina) true pe-32)
		    (dead (obj-thaisa) false pe-33)
		    (believe (obj-pericles (pe-33 true)) true pe-34)
		    (adrift (obj-thaisa) true pe-35)
		    (find (obj-physician obj-thaisa) true pe-36)
		    (alive (obj-thaisa) true pe-37)
		    (believe (obj-thaisa (pe-28 true)) true pe-38)
		    (votaress (obj-thaisa) true pe-39)
		    (leave-with (obj-pericles obj-marina obj-cleon) true pe-40)
		    (raise (obj-cleon obj-marina) true pe-41)
		    (return-to (obj-pericles obj-tyre) true pe-42)
		    (superior-to (obj-marina obj-daughter2) true pe-43)
		    (kill (obj-servant obj-marina) unknown pe-44)
		    (order (obj-cleon (pe-44 true)) true pe-45)
		    (cause (pe-43 pe-45) true pe-46)
		    (capture (obj-pirates obj-marina) true pe-47)
		    (become-false (pe-44) true pe-48)
		    (cause (pe-47 pe-48) true pe-49)
		    (brothel (obj-brothel) true pe-50)
		    (owner (obj-owner obj-brothel) true pe-51)
		    (sell (obj-pirates obj-marina obj-owner) true pe-52)
		    (dead (obj-marina) false pe-53)
		    (believe (obj-cleon (pe-53 true)) true pe-54)
		    (believe (obj-pericles (pe-53 true)) true pe-55)
		    (grieve (obj-pericles) true pe-56)
		    (wander (obj-pericles) true pe-57)
		    (cause (pe-55 pe-56) true pe-58)
		    (cause (pe-56 pe-57) true pe-59)
		    (visit (obj-lysimachus obj-marina) true pe-60)
		    (gold (obj-gold) true pe-61)
		    (give (obj-lysimachus obj-gold obj-marina) true pe-62)
		    (teach (obj-marina) true pe-63)
		    (arrive (obj-pericles obj-mytilene) true pe-64)
		    (reunited (obj-pericles obj-marina) true pe-65)
		    (temple (obj-temple) true pe-66)
		    (go (obj-pericles obj-temple) true pe-67)
		    (dream-of (obj-dream pe-67) true pe-68)
		    (dream (obj-pericles obj-dream) true pe-69)
		    (cause (pe-69 pe-67) true pe-70)
		    (reunited (obj-pericles obj-thaisa) true pe-71)
		    (cause (pe-67 pe-71) true pe-72)
		    (marry (obj-marina obj-lysimachus) true pe-73)
		   )
	     )
)	    

