/* vector.c

   vector and matrix allocation

   $Revision:$            $Date:$
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vector.h"

/*----------------- Array storage allocation routines ---------------------*/
/* Allocate space for vector of float cells for
   one dimensional dynamic vector[cols]
*/
void VectorAllocate(VECTOR *vector, int nCols)
{
   if ((*vector = (VECTOR) calloc(nCols, sizeof(float))) == NULL)
   {
      fprintf(stderr, "Sorry! Not enough memory for nodes\n");
      exit(1);
   }
}


/* Allocate space for columns (float cells) for
   dynamic two dimensional matrix[rows][cols]
*/
void AllocateCols(PFLOAT matrix[], int nRows, int nCols)
{
   int  i;

   for (i = 0;  i < nRows;  i++)
      VectorAllocate(&matrix[i], nCols);
}

/* Allocate space for a two dimensional dynamic matrix [rows] [cols]
*/
void MatrixAllocate(MATRIX *pmatrix, int nRows, int nCols)
{
   if ( (*pmatrix  =  (MATRIX) calloc(nRows,  sizeof(PFLOAT) ) )   ==  NULL)
   {
      fprintf(stderr, "Sorry! Not enough memory for nodes\n");
      exit(1);
   }

   AllocateCols(*pmatrix, nRows, nCols);
}

/* free space for two dimensional dynamic array */
void MatrixFree(MATRIX matrix,  int nRows)
{
   int   i;
   for (i = 0;  i < nRows;  i++)
      free(matrix[i]);
   free(matrix);
}

