#|----------------------------------------------------------------04/Jun/88----
   Function  - get-time
       
   Inputs    -> nothing
       
   Returns   -> kcl time in a format string.
     Note this is highly kcl-dependent.  Needed because kcl has no clue about
     daylight savings time, and our local implementation uses the default to
     Kyoto time (neat).  So we have the eval-when loop that sets things up for
     proper time zone (= # of time zones away from GMT?).  If not in kcl,
     could I think just use the get-time function as is; it just takes the
     nonsense returned from common lisp get-decoded-time (9 values) and
     returns a string with a readable date.
-------------------------------------------------------------------KThompso--|#


(provide "get-time")



(defvar days-of-week 
     '("Monday" "Tuesday" "Wednesday" "Thursday" "Friday" "Saturday" "Sunday"))


(defun daylight-savings-time-p ()
  (multiple-value-bind
   (sec min hour date month year day-of-week savings-time time-zone)
   (get-decoded-time)
   (or (member month '(5 6 7 8 9))               ;may-october
       (and nil nil))))                          ;april?  Dunno how to compute.


(eval-when (compile load eval)
   (let ((daylight-savings? (daylight-savings-time-p)))
     (if daylight-savings?
       (setq si:*default-time-zone* 7) 
       (setq si:*default-time-zone* 8))))


(defun get-time ()
  (multiple-value-bind
     (sec min hour date month year day-of-week savings-time time-zone)
     (get-decoded-time)
     (let ((date-str (format nil "~2,'0D/~2,'0D/~2,'0D" 
			     month date (- year 1900)))
	   (time-str (format nil "~2,'0D:~2,'0D" hour min))
	   (day-str (string-capitalize
		      (string-downcase 
		        (princ-to-string (elt days-of-week day-of-week))))))
       (concatenate 'string time-str " on " day-str ", " date-str))))

