;;; -*- Mode:Lisp; Package: cl-lib; Syntax: ansi-common-lisp -*-
;;;
;;;; (C) 1993 by Bradford W. Miller and the Trustees of the University of Rochester.
;;; Unlimited non-commercial use is granted to the end user, other rights to
;;; the non-commercial user are as granted by the GNU LIBRARY GENERAL PUBLIC LICENCE
;;; version 2 which is incorporated here by reference.

;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the Gnu Library General Public License as published by
;;; the Free Software Foundation; version 2.

;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; Gnu Library General Public License for more details.

;;; You should have received a copy of the Gnu Library General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;
;;; Bug reports, improvements, and feature requests should be sent
;;; to miller@cs.rochester.edu. Ports to other lisps are also welcome.
;;; (It would be appreciated if you would also cc mkant@cs.cmu.edu.)
;;;
;;; This is the incremental file expression reader package written by 
;;;   Bradford W. Miller
;;;   miller@cs.rochester.edu
;;;   University of Rochester, Department of Computer Science
;;;   610 CS Building, Comp Sci Dept., U. Rochester, Rochester NY 14627-0226
;;;   716-275-1118
;;; I will be glad to respond to bug reports or feature requests.
;;;
;;; This version was NOT obtained from the directory
;;; /afs/cs.cmu.edu/user/mkant/Public/Lisp-Utilities/reader.lisp
;;; via anonymous ftp from a.gp.cs.cmu.edu. (you got it in cl-lib).
;;;

;;; Note: The use of (raw-read-char) can translate to (read-char) on most
;;; architectures, under Allegro, it puts Gnu Emacs into raw mode, so a single
;;; character will be transmitted instead of waiting for an entire (buffered) line.
;;; (when using the fi interface, and loading more-allegro.lisp in the cl-lib 
;;; distribution).

(in-package cl-lib)

(defun reader (filename)
  (flet ((eval-expr (expr)
           (restart-case 
               (PRINT (MULTIPLE-VALUE-LIST (eval eXPR)))
             (nil ()
                 :report
                   (lambda (s) (format s "Continue READER as if form is ok"))))))
    (let ((reader-expr nil)
          (pointer 0))
      (with-open-file (obj filename)
        (loop
          (while (member (setq reader-expr (peek-char nil obj nil 'end))
                         '(#\space #\return #\newline #\;))
            (if (eql reader-expr #\;)
                (write-line (read-line obj nil #\space))
	      (write-char (read-char obj))))
          (if (eq reader-expr 'end)
              (return-from reader 'end))
          (if (eq (setq reader-expr (read obj nil 'end)) 'end)
              (return-from reader 'end))
          (incf pointer)
          (block prompt
            (loop
              (format t "~%~%~a. ~s" pointer reader-expr)
              (let ((input-char (raw-read-char)))
                (case input-char
                  ((#\space #\y #+lispm #\end #\return #-symbolics #\newline)
                   (eval-expr reader-expr)
                   (return-from prompt nil))
                  (#\q
                   (return-from reader 'end))
                  (#\s
                   (let ((skip (read)))
                     (while (plusp (decf skip))
                       (if (eq (read obj nil 'end) 'end)
                           (return-from reader 'end))
                       (incf pointer))
                     (return-from prompt nil)))
                  (#\e
                   (format t "val: ")
                   (eval-expr (read))
                   (terpri))
                  (#\(
                   (unread-char input-char)
                   (format t "val: ")
                   (eval-expr (read))
                   (terpri))
                  ((#\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
                   (eval-expr reader-expr)
                   (unread-char input-char)
                   (dotimes (count (- (parse-integer (read))
                                      1))
                     (progn count)
                     (if (eq (setq reader-expr (read obj nil 'end)) 'end)
                         (return-from reader 'end))
                     (eval-expr reader-expr)
                     (incf pointer))
                   (return-from prompt nil))
                  (t (format t "~%~%
summary of commands
~~~~~~~~~~~~~~~~~~~

<space>, y, <end>: evaluates the next expression.
<number> : evaluates the next <number> of expressions.
s <number> : skips the next <number> of expressions.
e <lisp-expr> : evaluates the <lisp-expr>.
q : to exit the READER.
? : prints out this menu.

")
                     )))))))
      :reader-done)))


