;;; -*- Mode: LISP; Syntax: ansi-common-lisp; Package: CL-LIB; Base: 10 -*-
;;; 
;;; Copyright (C) 1994 by Bradford W. Miller, miller@cs.rochester.edu
;;;                       and the Trustees of the University of Rochester
;;; Unlimited non-commercial use is granted to the end user, other rights to
;;; the non-commercial user are as granted by the GNU LIBRARY GENERAL PUBLIC LICENCE
;;; version 2 which is incorporated here by reference.

;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU Library General Public License as published by
;;; the Free Software Foundation; version 2.

;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU Library General Public License for more details.

;;; You should have received a copy of the GNU Library General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;;
;;; The following is contributed by miller@cs.rochester.edu

(in-package cl-lib)

;;; various incantations for prompting for a non-binary choice (see also query.lisp in this directory).
;;; if CLIM is active, use that... thanks to George Ferguson for the initial take on the following three 
;;; functions... (ferguson@cs.rochester.edu)

#+clim
(defun popup-read-form (type &optional (prompt nil pp) (default nil dp))
  "Pops up a dialog box to read a symbol. Returns two values: the symbol
or NIL if Aborted and a flag that is T if Aborted."
  (let (x)
    (restart-case
	(progn
	  (CLIM:accepting-values
	   (t :own-window t :initially-select-query-identifier 'the-item)
	   (setq x (apply #'CLIM:accept type
                          :query-identifier 'the-item
                          (nconc (if pp
                                     `(:prompt ,prompt))
                                 (if dp
                                     `(:default ,default))))))
	  ;; If we get here Ok was selected
	  (values x nil))
      ;; If we get here Abort was selected
      (abort () (values nil t)))))

(defun prompt-and-read (prompt &rest prompt-args)
  "Prompt the user for an arbitrary response."
  #+clim
  (clim-prompt-for '(clim::form :auto-activate t) prompt prompt-args)
  #-clim
  (progn
    (apply #'format *query-io* prompt prompt-args)
    (read *query-io*)))

(defun prompt-for (type &optional prompt &rest prompt-args)
  "inspired by cltl/2, condition chapter."
  (unless prompt
    (setq prompt (format nil "Please enter a ~A" type)))
  #+clim
  (clim-prompt-for type prompt prompt-args)
  #-clim
  (let (result)
    (while-not (typep (setq result (apply #'prompt-and-read prompt prompt-args)) type))
    result))

#+clim
(defun clim-prompt-for (type prompt prompt-args)
  (loop
    (mlet (result aborted)
        (popup-read-form (convert-to-presentation-type type) (if prompt (apply #'format nil prompt prompt-args)))
      (cond
       (aborted
        (if (find-restart 'abort)
            (abort)
          (return-from clim-prompt-for (values nil t))))
       (t
        (return-from clim-prompt-for result))))))

#+clim
(defun clim-prompt-for-with-default (type default prompt prompt-args)
  (loop
    (mlet (result aborted)
        (popup-read-form (convert-to-presentation-type type) (if prompt (apply #'format nil prompt prompt-args)) default)
      (cond
       (aborted
        (if (find-restart 'abort)
            (abort)
          (return-from clim-prompt-for-with-default (values nil t))))
       (t
        (return-from clim-prompt-for-with-default result))))))

#+clim (defvar *default-presentation-type* '((clim:form) :auto-activate t))

#+clim
(defun convert-to-presentation-type (type)
  "Convert a lisp type into a presentation type."
  (cond
   ((clim:presentation-type-specifier-p type)
    type)
   (t
    *default-presentation-type*)))

