;;; -*- Mode: LISP; Syntax: Ansi-common-lisp; Package: process; Base: 10; Vsp: 1 -*-
;;;; Copyright (C) 1994, 1993, 1992 by the Trustees of the University of Rochester. All rights reserved.
;;; Unlimited non-commercial use is granted to the end user, other rights to
;;; the non-commercial user are as granted by the GNU LIBRARY GENERAL PUBLIC LICENCE
;;; version 2 which is incorporated here by reference.

;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the Gnu Library General Public License as published by
;;; the Free Software Foundation; version 2.

;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; Gnu Library General Public License for more details.

;;; You should have received a copy of the Gnu Library General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;; allow code that runs on the symbolics to also run under allegro (possibly not optimally).

;; Modified from code written by Steve Luk for the TRAINS project.

(in-package process)

(defvar *default-process-priority* 0)

(psetf (macro-function 'with-lock) (macro-function 'mp:with-process-lock)
       (symbol-function 'lock) (symbol-function 'mp:process-lock)
       (symbol-function 'unlock) (symbol-function 'mp:process-unlock)
       (symbol-function 'process-name) (symbol-function 'mp:process-name)
       (symbol-function 'interrupt) (symbol-function 'mp:process-interrupt)
       (symbol-function 'process-wait) (symbol-function 'mp:process-wait)
       (symbol-function 'runnable-p) (symbol-function 'mp:process-runnable-p)
       (macro-function 'without-preemption) (macro-function 'mp:without-scheduling)
       (macro-function 'without-interrupts) (macro-function 'excl:without-interrupts)
       )

(defvar *process-verify-alist* nil)

(defun block-process (whostate verify-function &rest args)
  (apply #'mp:process-wait whostate verify-function args))
;  (let ((who (intern whostate :keyword)))
;    (cl-lib:update-alist mp:*current-process* (list* who verify-function args) *process-verify-alist*)
;    (cl-lib:while (not (apply verify-function args))
;                  (mp:process-add-arrest-reason mp:*current-process* who))
;    ;; done
;    (cl-lib:update-alist mp:*current-process* nil *process-verify-alist*)))

(defmacro block-and-poll-wait-function 
    (whostate interval verify-function &rest args)
  `(mp:process-wait ,whostate ,verify-function ,@args))

#+allegro-v4.1
(cl-lib:add-initialization "lep-init for block"
                    '(lep::eval-in-emacs "(put 'block-and-poll-wait-function 'fi:lisp-indent-hook 1)")
                    '(:lep))

(defmacro block-and-poll-with-timeout 
    (n-seconds whostate interval verify-function &rest args)
  `(mp:process-wait-with-timeout ,whostate ,n-seconds ,verify-function ,@args))

#+allegro-v4.1
(cl-lib:add-initialization "lep-init for block"
                    '(lep::eval-in-emacs "(put 'block-and-poll-with-timeout 'fi:lisp-indent-hook 1)")
                    '(:lep))

; Warning: the key words in symbolics and allegro are all compatable
(setf (symbol-function 'process-run-function) 
  (symbol-function 'mp:process-run-function))

; Not quite the idea, but works for the cases in this system
(defun process-abort (process &key message all query time-out stream)
  (declare (ignore message all query time-out stream))
  (mp:process-kill process))

(defun make-lock (name &key (type :simple) recursive area flavor)
  (declare (ignore type recursive area flavor))
  (mp:make-process-lock :name name))

; Well, the function is not completely the same in both machines. I guess it
; is better to rewrite the code than to use macro substitution.
(defmacro make-process (name
			&rest init-args
			&key (priority process:*default-process-priority*) 
			(initial-function nil) initial-function-arguments 
			verify-function verify-function-arguments 
			(run-reasons '(:enable)) flavor 
			area simple-p interrupt-handler system-process flags 
			top-level-whostate &allow-other-keys)
  `(let ((process (mp:make-process :name ,name 
                                   :priority ,priority)))
     (mp:process-enable process)
     (cond
      (,initial-function
       (apply #'mp:process-preset process ,initial-function 
              ,initial-function-arguments)
       (mp:process-allow-schedule process)))
     process))

#+allegro-v4.1
(cl-lib:add-initialization "lep-init for make"
                    '(lep::eval-in-emacs "(put 'make-process 'fi:lisp-indent-hook 1)")
                    '(:lep))
	  
(defun make-process-priority (class priority &rest extra-args)
  (declare (ignore extra-args))
  (if (eq class :foreground)
      priority
    (error "This class is not currently supported")))

(defun reset (process &key (if-current-process t) 
                           (if-without-aborts :ask))
  (declare (ignore if-current-process if-without-aborts))
  (mp:process-reset process))

(defun kill (process &key if-current-process if-without-aborts)
  (declare (ignore if-current-process if-without-aborts))
  (mp:process-kill process))

(defun wakeup (process)
  t)
;;  (if (eval (cddr (assoc process *process-verify-alist*)))
;;      (wakeup-without-test process)))

(defun wakeup-without-test (process)
  t)
  ;;  (mp:process-revoke-arrest-reason process (cadr (assoc process *process-verify-alist*))))

(defun lock-idle-p (lock)
  (null (mp:process-lock-locker lock)))
    
(defun make-lock-argument (ignore)
  (declare (ignore ignore))
  mp:*current-process*)

