(in-package cl-lib)

;; raw io

(defun raw-read-char (&optional (stream *standard-input*) &rest args)
  ;; copied from the example on page 14-87 of the allegro 4.1 manual.
  ;; raw-reading is in response to our earlier enhancement request for the FI interface.
  (excl:set-terminal-characteristics stream :input-processing :cbreak)
  (sleep 1)                     ; a hack, the above call isn't synchronous.
  (unwind-protect
      (handler-case
          (apply #'read-char stream args)
        (error (c)
          (format *terminal-io* "error doing read-char from ~s: ~a" stream c)))
    (excl:set-terminal-characteristics stream :input-processing :cooked)))

(defun raw-read-char-no-hang (&optional (stream *standard-input*) &rest args)
  ;; copied from the example on page 14-87 of the allegro 4.1 manual.
  ;; raw-reading is in response to our earlier enhancement request for the FI interface.
  (excl:set-terminal-characteristics stream :input-processing :cbreak)
  (sleep 1)                     ; a hack, the above call isn't synchronous.
  (unwind-protect
      (handler-case
          (apply #'read-char-no-hang stream args)
        (error (c)
          (format *terminal-io* "error doing read-char-no-hang from ~s: ~a" stream c)))
    (excl:set-terminal-characteristics stream :input-processing :cooked)))

(defun raw-peek-char (&optional peek-type (stream *standard-input*) &rest args)
  ;; adapted from the example on page 14-87 of the allegro 4.1 manual.
  ;; raw-reading is in response to our earlier enhancement request for the FI interface.
  (excl:set-terminal-characteristics stream :input-processing :cbreak)
  (sleep 1)                     ; a hack, the above call isn't synchronous.
  (unwind-protect
      (handler-case
          (apply #'peek-char peek-type stream args)
        (error (c)
          (format *terminal-io* "error doing peek-char from ~s: ~a" stream c)))
    (excl:set-terminal-characteristics stream :input-processing :cooked)))

;; install the series stuff

(add-initialization "Install Waters Series"
                    '(let ((*package* (find-package 'cl-lib)))
                      (series::install))
                    '(:once :now))

;;From: Doug Cutting <cutting@parc.xerox.com>
;;To: pshell@nl.cs.cmu.edu
;;Cc: allegro-cl@ucbvax.berkeley.edu
;;Subject: Re: I/O efficiency question
;;Date: 	Tue, 23 Feb 1993 13:38:19 PST
;;
;;
;;If you really want to make your program burn, try the following:

(in-package cl-lib)

(defmacro fast-read-char (stream)
  #+(and allegro (version>= 4)) `(stream:stream-read-char ,stream)
  #+lucid`(lcl:fast-read-char ,stream nil :eof)
  #-(or (and allegro (version>= 4)) lucid) `(read-char ,stream nil :eof))

(defmacro fast-read-file-char (stream) `(fast-read-char ,stream))

#+(and allegro (version>= 4))
(define-compiler-macro fast-read-file-char (stream)
  `(macrolet ((stream-slots (stream)
		`(the simple-vector (svref ,stream 1)))
	      (stream-buffer (slots)
		`(the simple-string (svref ,slots 11)))
	      (stream-buffpos (slots)
		`(the fixnum (svref ,slots 12)))
	      (stream-maxbuffpos (slots)
		`(the fixnum (svref ,slots 13))))
     (declare (optimize (speed 3) (safety 0)))
     (let* ((stream ,stream)
	    (slots (stream-slots stream))
	    (buffpos (stream-buffpos slots))
	    (maxbuffpos (stream-maxbuffpos slots)))
       (declare (fixnum buffpos maxbuffpos))
       (if (>= buffpos maxbuffpos)
	   (stream:stream-read-char stream)
	 (prog1 (schar (stream-buffer slots) buffpos)
	   (when (= (setf (stream-buffpos slots) (the fixnum (1+ buffpos)))
		    maxbuffpos)
	     (setf (stream-maxbuffpos slots) 0)))))))

