;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; File:         useful.l
; Description:  useful functions
; Author:       Eric Muehle
; Created:      23-Sep-87
; Package:      FROBS
; RCS $Header: useful.l,v 2.2 88/03/30 14:32:40 jed Exp $
;
; (c) Copyright 1987, University of Utah, all rights reserved
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package 'frobs)

;(export '(optimize-slots defun shadow-wrapper def-method opt-slots))

(shadow 'defun)

(defmacro optimize-slots (slots-list &body body)
  (let (get-form set-form)
    (dolist (s (cdr (assoc 'get slots-list)))
      (push (if (symbolp s)
	      `(,s (,s $self))
	      `(,(cadr s) (with-frob ,(car s) (,(cadr s) $self))))
	    get-form))
    (dolist (s (cdr (assoc 'set slots-list)))
      (push (if (symbolp s)
	      `(,s (,s $self))
	      `(,(cadr s) (with-frob ,(car s) (,(cadr s) $self))))
	    get-form)
      (push (if (symbolp s)
	      `(setf (,s $self) ,s)
	      `(with-frob ,(car s) (setf (,(cadr s) $self) ,(cadr s))))
	    set-form))
    (if set-form
      `(let ,get-form
	 (prog1
	     (progn ,@body)
	   ,@set-form))
      ;; else
      `(let ,get-form
	 ,@body))))


(defmacro shadow-wrapper (fn &body body)
  `(let ((old-fn (symbol-function ',fn))
	 (shadowed-name nil))
     ,@body
     (shadow ',fn)
     (setf shadowed-name (find-symbol (symbol-name ',fn))
	   (symbol-function shadowed-name)
	   (symbol-function ',fn)
	   (symbol-function ',fn)
	   old-fn)
     shadowed-name))


(defmacro defun (name pars &body code)
  (when (fboundp name)
    (warn "Redefining ~S~%" name)
    (when (gethash name *main-methods*)
      (remhash name *main-methods*)))
  `(lisp:defun ,name ,pars ,@code))
    
(setf (macro-function 'old-def-method)
      (macro-function 'def-method))

(defvar *class-hook* nil)

(defmacro def-method ((class name &rest priv-show) params &rest code)
  (if (listp class)
    (setf *class-hook* (get-class-name class))
    (setf *class-hook* class))
  (if (member :shadow priv-show)
    `(shadow-wrapper ,name 
	       (old-def-method (,class ,name ,@priv-show) ,params ,@code))
    `(old-def-method (,class ,name ,@priv-show) ,params ,@code)))


(defun make-get-macro (class slot)
  (let ((fn (car (frobs::get-generic-fn* slot (get-class-frob class)))))
    `(,slot ($self) 
	    `(funcall ',',fn ,$self))))

(defun make-set-macro (class slot)
  (let ((fn   (car (frobs::get-generic-fn* slot (get-class-frob class))))
	(name (frobs::make-set-slot slot)))
    `(,name ($self *val*) 
	    `(funcall ',',fn ,$self ,*val*))))

(defmacro opt-slots (slots &body forms)
  (let (macros)
    (dolist (s slots)
      (push (make-get-macro *class-hook* s) macros)
      (push (make-set-macro *class-hook* s) macros))
    `(macrolet ,macros  ,@forms)))

;; End of file.
