;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; File:         pack.l
; Description:  contains the package interface for frobs
; Author:       Eric Muehle
; Created:      23-May-87
; Package:      FROBS
; RCS $Header: pack.l,v 2.7 91/04/22 16:42:16 eeide Exp $
;
; (c) Copyright 1987, University of Utah, all rights reserved
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Copyright (c) 1987 Eric G. Muehle and Utah Portable AI Support 
;;; Systems Project.  This program may be used, copied, modified, and 
;;; redistributed freely for noncommercial purposes, so long as this 
;;; notice remains intact and the program is redistributed in its 
;;; entirity.  Any commercial use of the software or derivative thereof
;;; requires a redistribution license from: Utah PASS Project 3190 M.E.B 
;;; Department of Computer Science University of Utah Salt Lake City, UT 
;;; 84112

;;; make the frobs package
(in-package 'frobs)

(export '( def-class new-instance new-instance* gen-instance put-class-frob
	    frob-type all-frobs ask assert-val assert-vals
	    erase remove-val show def-method close-class with-frob
	    class-frob? instance-frob? frob? undefined bound?
	    get-generic-fn put-frob kill-instance-frobs instance-name 
	    class-name *frob-messages* 
	    all-class-frobs all-instance-frobs reset-system class-instances
	    all-class-instances instances all-instances *undefined* 
	    class get-frob get-class-frob reset-context slot?
	    kill-frob kill-class-frob $self call-method apply-method 
	    with-module before-methods after-methods run-super
	    kill-instance-frobs kill-instances inherits-from frob-type?
	    class-parent call-method-in-context apply-method-in-context

	    ; in daemons.l
	    install-daemon define-daemon daemon
	    before-assert after-assert before-ask after-ask before-remove 
	    after-remove set-before-assert set-after-assert set-before-ask 
	    set-after-ask set-before-remove set-after-remove $slot $value
	    remove-daemon set-%%init-daemon %%init-daemon define-init-daemon 
	    init-daemon $parent

	    ; in dynamic.l
;	    dyn add-new-slot get-slot-value set-slot-value %slots set-%slots
;	    dyn$$%slots dyn$$set-%slots %%slots set-%%slots
;	    dyn$$%%slots dyn$$set-%%slots

            ; in struct.l
            print-self

	    ; in the-rules.l
	    known bind set-conflict-resolution-strategy stop-fc
	    evalp def-rule install-rule kill-rule reset-rules depth-first
	    breadth-first get-rule-value change-rule-value atomic not-atomic
	    par-breadth-first par-depth-first trace-rules untrace-rules
	    *trace-all-rules*))

;;; For KCL and other systems that default to INLINE code!
(proclaim '(notinline run-rules check-rules check-daemons))

;; End of file.
