;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; File:         misc.l
; Description:  Contains misc functions
; Author:       Eric G. Muehle
; Created:      7-Jan-87
; Package:      FROBS
; RCS $Header: misc.l,v 2.4 90/03/29 09:14:34 carr Exp $
;
; (c) Copyright 1987, University of Utah, all rights reserved.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Copyright (c) 1987 Eric G. Muehle and Utah Portable AI Support 
;;; Systems Project.  This program may be used, copied, modified, and 
;;; redistributed freely for noncommercial purposes, so long as this 
;;; notice remains intact and the program is redistributed in its 
;;; entirity.  Any commercial use of the software or derivative thereof
;;; requires a redistribution license from: Utah PASS Project 3190 M.E.B 
;;; Department of Computer Science University of Utah Salt Lake City, UT 
;;; 84112

(in-package 'frobs)

;;; Stub functions for now
(defun in-module (x &key key) 
  (let (temp)
    (setf temp (gethash x *key*))
    (cond ((null temp)
	   (error "Module ~S does not exist" x))
          ((funcall temp key)
	   (setf *module* x))
	  (t (error "~S requires a key" x)))))
    
;;; Closesd a class module
(defmacro close-class (&optional key)
  `(eval-when (compile load eval)
     (close-class-aux ',*module* ',key)))

;;; Aux function that defines the keyword access functions for the modules
(defun close-class-aux (class key)
  (cond ((gethash class *key*)
	 (warn "~S cannot be re closed" class))
        (key
	 (setf (gethash class *key*)
	       (eval `(function (lambda (x) (eq x ',key))))))
	(t (setf (gethash class *key*)
		 (eval `(function (lambda (x) t))))))
  (close-module))


(defun close-module () (setf *module* nil))

;;; Predicate functions
(defun instance-frob? (frob)
  (frob-p frob))

(defun class-frob? (frob)
  (class-frob-p frob))

(defun frob? (frob)
  (or (instance-frob? frob)(class-frob? frob)))

;;; Special form for MV slots
(defmacro with-mv-slot (mode &rest code)
  `(unwind-protect
       (progn
	 (setq *mv* ',mode)
	 ,@code)
     (setf *mv* 'normal)))

;;; Creates a context environment
(defmacro with-frob (frob &rest code)
  `(let ((old-context *context*))
     (unwind-protect
       (progn
	 (setq *context* ',frob)
	 ,@code)
       (setq *context* old-context))))


;;; Creates a module environment
(defmacro with-module (mod key &rest code)
  `(let ((old-module *module*))
     (unwind-protect
       (progn
	 (in-module ',mod :key ',key)
	 ,@code)
       (setq *module* old-module))))


;;; Expr version of GET-TYPE
(defun frob-type (frob)
  (cond ((frob-p frob)(class-frob-name (frob-parent frob)))
        ((class-frob-p frob) (class-frob-name frob))
        (t (error "~S is not a frob" frob))))

;;; Prints out system messages
(defmacro frob-message (string &rest args)
  `(when *frob-messages* (format t ,string ,@args)))

(defun frob-compile-file (&rest args)
  (unwind-protect 
    (progn
     (setf *comp-mode* t)
     (setf *comp-meths-list* nil)
     (apply *compile-file-fn* args))
    (setf *comp-mode* nil)))

;; End of file.
