;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; File:         frob-browser.l
; Description:  X browser for frobs
; Author:       Jed Krohnfeldt, Leigh Stoller
; Created:      23-Sep-87
; Package:      USER
; RCS $Header: frob-browser.l,v 2.1 88/02/08 16:06:40 jed Exp $
;
; (c) Copyright 1987, University of Utah, all rights reserved
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(require "browsers")
(require "frobs")

(in-package 'frobs)

(defun frob-browser ()
  (make-browser (all-frobs)
		:x 300 :y 100
		:mousemap '((1 browser-frob-browser)))
  (browser-top-loop))

(defun browser-frob-browser (browser coords)
  (let ((item (browser-select-item browser coords)))
    (if item
      (make-browser (list item)
		    :print-function 'frob-print-function
		    :x 50 :y 50)
      (browser-beep browser coords))))

(defun frob-print-function (browser frob)
  (declare (ignore browser))
  (show frob))

;; End of file.

