;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; File:         dynamic.l
; Description:  contains the dynamic mix-in class
; Author:       Eric Muehle
; Created:      29-Apr-87
; Package:      FROBS
; RCS $Header: dynamic.l,v 2.2 88/03/30 14:31:47 jed Exp $
;
; (c) Copyright 1987, University of Utah, all rights reserved
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Copyright (c) 1987 Eric G. Muehle and Utah Portable AI Support 
;;; Systems Project.  This program may be used, copied, modified, and 
;;; redistributed freely for noncommercial purposes, so long as this 
;;; notice remains intact and the program is redistributed in its 
;;; entirity.  Any commercial use of the software or derivative thereof
;;; requires a redistribution license from: Utah PASS Project 3190 M.E.B 
;;; Department of Computer Science University of Utah Salt Lake City, UT 
;;; 84112

;;; Need the daemons package
(eval-when (compile load eval)
  (require 'daemons "daemons"))

(in-package 'frobs)

(def-class dyn {class init-daemon} 
  :private ((%%slots nil)))

(def-method ({class dyn} %slots :in-module)()
  (%%slots $self))

(def-method ({class dyn} set-%slots :in-module)(val)
  (setf (%%slots $self) val))

(defsetf %slots set-%slots)


(define-init-daemon ({class dyn} init-dyn)
  (unless (eq (%slots $parent)
	      (%slots $self))
	  (setf (%slots $self)
		(append (%slots $self)(%slots $parent)))))

(def-sys 'dyn)
(def-sys-meth '(%%slots set-%%slots %slots set-%slots))

(defun get-slot-value (frob slot context)
  (with-frob dyn	       
    (let ((val (assoc context (cdr (assoc slot (%slots frob))))))
      (if val 
	(cdr val)
	*undefined*))))

(defun set-slot-value (frob slot val context)
  (with-frob dyn	       
    (when (or (class-frob-p frob)
	      (eq (%slots frob)(%slots (frob-parent frob))))
      (setf (%slots frob)(copy-tree (%slots frob))))
    (let ((pair (assoc context (cdr (assoc slot (%slots frob))))))
      (cond (pair
	     (rplacd pair val))
	    ((assoc slot (%slots frob))
	     (push (cons context val) (cdr (assoc slot (%slots frob)))))
	    (t (push (list slot (cons context val)) (%slots frob))))))
  val)

(defmacro add-new-slot (class slot)
  (let ((set-name  (make-set-slot slot))
	(new-class (get-class-name class)))
    (when (slot? new-class slot)
      (error "~S is already a slot.~%" slot))
    (unless (slot? new-class '%%slots)
      (error "~S does not inherit from {class dyn}.~%" new-class))	  
    `(eval-when (load compile eval)
       (def-method (,class ,slot :only :show)()
	 (get-slot-value $self ',slot ',(class-frob-name new-class)))
       (def-method (,class ,set-name :only)(val)
	 (set-slot-value $self ',slot val ',(class-frob-name new-class)))
       (defsetf ,slot ,set-name))))

;; End of file.
