;*******************************************************************************
;*
;*	Structures for the representation of concepts in CNF
;*
;*******************************************************************************

(proclaim '(inline get-pos-definitive-prims get-pos-possible-prims get-neg-definitive-prims get-neg-possible-prims
		   get-pos-definitive-families get-pos-possible-families get-neg-definitive-families get-neg-possible-families
		   get-pos-definitive-prims-of-family get-pos-possible-prims-of-family 
		   get-neg-definitive-prims-of-family get-neg-possible-prims-of-family
		   get-exists-links get-forall-links get-cnf-agree get-cnf-disagree 
		   set-agree! set-disagree!
		   ))
(defstruct (cnf-help (:conc-name cnf-help-)
		     (:print-function print-subs-help)
		     )
  (subs-rules			nil :type list)
  (exists-links			nil :type list)
  (forall-links			nil :type list)
  (pos-definitive-prims		nil :type list)
  (neg-definitive-prims 	nil :type list)
  (pos-possible-prims		nil :type list)
  (neg-possible-prims		nil :type list)
  (pos-definitive-families	nil :type list)
  (neg-definitive-families	nil :type list)
  (pos-possible-families	nil :type list)
  (neg-possible-families	nil :type list)
  (agree			nil :type symbol)
  (disagree			nil :type symbol)
  )

(defun print-subs-help (p s k)
  (terpri)
  (print-if (cnf-help-exists-links p)		"Some Links			: ")
  (print-if (cnf-help-forall-links p)		"Forall Links			: ")
  (print-if (cnf-help-pos-definitive-prims p)	"Definitive Primitives		: ")
  (print-if (cnf-help-neg-definitive-prims p)	"Neg. Definitive Primitives	: ")
  (print-if (cnf-help-pos-possible-prims p)	"Possible Primitives		: ")
  (print-if (cnf-help-neg-possible-prims p)	"Neg. Possible Primitives	: ")
  (print-if (cnf-help-pos-definitive-families p)"Definitive Families		: ")
  (print-if (cnf-help-neg-definitive-families p)"Neg. Definitive Families	: ")
  (print-if (cnf-help-pos-possible-families p)	"Possible Families		: ")
  (print-if (cnf-help-neg-possible-families p)	"Neg. Possible Families		: ")
  (print-if (cnf-help-agree p)			"Agreement with empty path	: ")
  (print-if (cnf-help-disagree p)		"Disagreement with empty path	: ")
  )

(defun add-to-forall-links! (cnf link)
  (pushnew link (cnf-help-forall-links cnf)))
(defun add-to-exists-links! (cnf link)
  (pushnew link (cnf-help-exists-links cnf)))

(defun add-to-definitive-primitives! (cnf prim)
  (pushnew prim (cnf-help-pos-definitive-prims cnf)))
(defun add-to-possible-primitives! (cnf prim)
  (pushnew prim (cnf-help-pos-possible-prims cnf)))
(defun add-to-neg-definitive-primitives! (cnf prim)
  (pushnew prim (cnf-help-neg-definitive-prims cnf)))
(defun add-to-neg-possible-primitives! (cnf prim)
  (pushnew prim (cnf-help-neg-possible-prims cnf)))

(defun add-to-SR! (cnf rule)
  (push rule (cnf-help-subs-rules cnf)))

(defun add-family-to-definitive-families! (cnf fam)
  (unless (assoc fam (cnf-help-pos-definitive-families cnf))
	  (setf (cnf-help-pos-definitive-families cnf) 
		(cons (list fam) (cnf-help-pos-definitive-families cnf)))))
(defun add-family-to-possible-families! (cnf fam)
  (unless (assoc fam (cnf-help-pos-possible-families cnf))
	  (setf (cnf-help-pos-possible-families cnf) 
		(cons (list fam) (cnf-help-pos-possible-families cnf)))))
(defun add-family-to-neg-definitive-families! (cnf fam)
  (let ((neg-fam (assoc fam (cnf-help-neg-definitive-families cnf)))
	)
       (if neg-fam
	   (rplacd neg-fam nil)
	   (setf (cnf-help-neg-definitive-families cnf) 
		 (cons (list fam) (cnf-help-neg-definitive-families cnf))))))
(defun add-family-to-neg-possible-families! (cnf fam)
  (let ((neg-fam (assoc fam (cnf-help-neg-possible-families cnf)))
	)
       (if neg-fam
	   (rplacd neg-fam nil)
	   (setf (cnf-help-neg-possible-families cnf) 
		 (cons (list fam) (cnf-help-neg-possible-families cnf))))))

(defun add-sprim-to-definitive-families! (cnf prim)
  (let ((family (get-family prim))
	(definitive-families (cnf-help-pos-definitive-families cnf))
	)
       (let ((fam-slot (assoc family definitive-families))
	     )
	    (if fam-slot
		(rplacd fam-slot (pushnew prim (cdr fam-slot)))
		(setf (cnf-help-pos-definitive-families cnf)
		      (cons (list family prim)
			    definitive-families))))))
(defun add-sprim-to-neg-definitive-families! (cnf prim)
  (let ((family (get-family prim))
	(definitive-families (cnf-help-neg-definitive-families cnf))
	)
       (let ((fam-slot (assoc family definitive-families))
	     )
	    (if fam-slot
		(rplacd fam-slot (pushnew prim (cdr fam-slot)))
		(setf (cnf-help-neg-definitive-families cnf)
		      (cons (list family prim)
			    definitive-families))))))
(defun add-sprim-to-possible-families! (cnf prim)
  (let ((family (get-family prim))
	(possible-families (cnf-help-pos-possible-families cnf))
	)
       (let ((fam-slot (assoc family possible-families))
	     )
	    (if fam-slot
		(rplacd fam-slot (pushnew prim (cdr fam-slot)))
		(setf (cnf-help-pos-possible-families cnf)
		      (cons (list family prim)
			    possible-families))))))
(defun add-sprim-to-neg-possible-families! (cnf prim)
  (let ((family (get-family prim))
	(possible-families (cnf-help-neg-possible-families cnf))
	)
       (let ((fam-slot (assoc family possible-families))
	     )
	    (if fam-slot
		(rplacd fam-slot (pushnew prim (cdr fam-slot)))
		(setf (cnf-help-neg-possible-families cnf)
		      (cons (list family prim)
			    possible-families))))))


(defun add-list-to-exists-links! (cnf list)
  (setf (cnf-help-exists-links cnf) 
	(union (cnf-help-exists-links cnf) list)))
(defun add-list-to-forall-links! (cnf list)
  (setf (cnf-help-forall-links cnf) 
	(union (cnf-help-forall-links cnf) list)))

(defun add-list-to-definitive-primitives! (cnf list)
  (setf (cnf-help-pos-definitive-prims cnf) 
	(union (cnf-help-pos-definitive-prims cnf) list)))
(defun add-list-to-possible-primitives! (cnf list)
  (setf (cnf-help-pos-possible-prims cnf) 
	(union (cnf-help-pos-possible-prims cnf) list)))
(defun add-list-to-neg-definitive-primitives! (cnf list)
  (setf (cnf-help-neg-definitive-prims cnf) 
	(union (cnf-help-neg-definitive-prims cnf) list)))
(defun add-list-to-neg-possible-primitives! (cnf list)
  (setf (cnf-help-neg-possible-prims cnf) 
	(union (cnf-help-neg-possible-prims cnf) list)))

(defun get-pos-definitive-prims (cnf)
  (cnf-help-pos-definitive-prims cnf))
(defun get-pos-possible-prims (cnf)
  (cnf-help-pos-possible-prims cnf))
(defun get-neg-definitive-prims (cnf)
  (cnf-help-neg-definitive-prims cnf))
(defun get-neg-possible-prims (cnf)
  (cnf-help-neg-possible-prims cnf))

(defun get-pos-definitive-families (cnf)
  (cnf-help-pos-definitive-families cnf))
(defun get-pos-possible-families (cnf)
  (cnf-help-pos-possible-families cnf))
(defun get-neg-definitive-families (cnf)
  (cnf-help-neg-definitive-families cnf))
(defun get-neg-possible-families (cnf)
  (cnf-help-neg-possible-families cnf))

(defun get-pos-definitive-prims-of-family (fam cnf)
  (cdr (assoc fam (cnf-help-pos-definitive-families cnf))))
(defun get-pos-possible-prims-of-family (fam cnf)
  (cdr (assoc fam (cnf-help-pos-possible-families cnf))))
(defun get-neg-definitive-prims-of-family (fam cnf)
  (cdr (assoc fam (cnf-help-neg-definitive-families cnf))))
(defun get-neg-possible-prims-of-family (fam cnf)
  (cdr (assoc fam (cnf-help-neg-possible-families cnf))))

(defun get-exists-links (cnf)
  (cnf-help-exists-links cnf))
(defun get-forall-links (cnf)
  (cnf-help-forall-links cnf))
(defun get-cnf-agree (cnf)
  (cnf-help-agree cnf))
(defun get-cnf-disagree (cnf)
  (cnf-help-disagree cnf))

(defun get-subsumption-functions (cnf)
  (cnf-help-subs-rules cnf))

(defun set-agree! (cnf)
  (setf (cnf-help-agree cnf) t))
(defun set-disagree! (cnf)
  (setf (cnf-help-disagree cnf) t))

(defun add-list-to-definitive-families! (cnf fam-slot)
  (dolist (fam fam-slot)
	  (if (cdr fam)
	      (dolist (sprim (cdr fam))
		      (add-sprim-to-definitive-families! cnf sprim))
	      (add-family-to-definitive-families! cnf (car fam))
	      )))
(defun add-list-to-neg-definitive-families! (cnf fam-slot)
  (dolist (fam fam-slot)
	  (if (cdr fam)
	      (dolist (sprim (cdr fam))
		      (add-sprim-to-neg-definitive-families! cnf sprim))
	      (add-family-to-neg-definitive-families! cnf (car fam))
	      )))
(defun add-list-to-possible-families! (cnf fam-slot)
  (dolist (fam fam-slot)
	  (if (cdr fam)
	      (dolist (sprim (cdr fam))
		      (add-sprim-to-possible-families! cnf sprim))
	      (add-family-to-possible-families! cnf (car fam))
	      )))
(defun add-list-to-neg-possible-families! (cnf fam-slot)
  (dolist (fam fam-slot)
	  (if (cdr fam)
	      (dolist (sprim (cdr fam))
		      (add-sprim-to-neg-possible-families! cnf sprim))
	      (add-family-to-neg-possible-families! cnf (car fam))
	      )))
