#|
**************************************************
	File :  	rules
	Last Change :   13 nov 91
	Author :	dd

**************************************************
|#

(defun RO-== (a b)
  (print-RO-call a '= b)  
  (=-rule a b))
(defun RO-<< (a b)
  (print-RO-call a '< b)
  (>-rule b a))
(defun RO->> (a b)
  (print-RO-call a '> b)
  (>-rule a b))
(defun RO-<> (a b)
  (print-RO-call a '<> b)
  (<>-rule a b))
(defun RO-<<= (a b)
  (print-RO-call a '<= b)
  (>=-rule b a))
(defun RO->>= (a b)
  (print-RO-call a '>= b)
  (>=-rule a b))


(defun =-rule (_a _b)
  (let ((index_a (get-index _a))
	(index_b (get-index _b))
	)
       (let ((a (cond ((and index_a (real-ord-obj-eq (get-obj index_a))))
		      (t _a)))
	     (b (cond ((and index_b (real-ord-obj-eq (get-obj index_b))))
		      (t _b)))
	     )
	    (cond ((and index_a (eq index_a index_b)))
		  ((and (numberp a) (numberp b))
		   (if (/= a b)
		       (clash '=-rule _a _b)))
		  ((numberp a)
		   (cond (index_b
			  (propagate-number-= a (get-obj index_b)))
			 (t (set-eq a (create-new-obj b)))))
		  ((numberp b)
		   (cond (index_a
			  (propagate-number-= b (get-obj index_a)))
			 (t (set-eq b (create-new-obj a)))))
		  (t (cond ((and index_a index_b)
			    (cond ((symbolic-clash-=? index_a
						      (get-obj index_b))
				   (clash '=-rule _a _b))
				  (t (propagate-number-constraint-= (get-obj index_a) 
								    (get-obj index_b)))))
			   (index_a  
			    (trail! (make-function 'reset-index b))
			    (set-id->index b index_a))  
			   (index_b  
			    (trail! (make-function 'reset-index a))
			    (set-id->index a index_b))  
			   (t (create-new-obj a)  
			      (trail! (make-function 'reset-index b))
			      (set-id->index b (get-index a))  
			      ))))))
  )
(defun >-rule (_a _b)
  (let ((index_a (get-index _a))
	(index_b (get-index _b))
	)
       (let ((a (cond ((and index_a (real-ord-obj-eq (get-obj index_a))))
		      (t _a)))
	     (b (cond ((and index_b (real-ord-obj-eq (get-obj index_b))))
		      (t _b)))
	     )
	    (cond ((and index_a (eq index_a index_b))
		   (clash '>-rule _a _b))
		  ((and (numberp a) (numberp b))
		   (if (<= a b)
		       (clash '>-rule _a _b)))
		  ((numberp a)
		   (cond (index_b
			  (propagate-number->-obj a (get-obj index_b)))
			 (t (set-ub (list '< a) (create-new-obj b)))))
		  ((numberp b)
		   (cond (index_a
			  (propagate-number-<-obj b (get-obj index_a)))
			 (t (set-lb (list '> b) (create-new-obj a)))))
		  (t (cond ((and index_a index_b)
			    (cond ((symbolic-clash->? index_a (get-obj index_b)) 
				   (clash '>-rule _a _b))
				  (t (propagate-number-constraint-> (get-obj index_a)
								    (get-obj index_b)))))
			   (index_a  
			    (let ((obj (get-obj index_a)))
				 (propagate-new-> (create-new-obj b) 
						  (set-bit-weakly index_a 
								  (bit-ior (real-ord-obj-*> obj)
									   (real-ord-obj-*>= obj)))
						  (real-ord-obj-ub obj))))
			   (index_b  
			    (let ((obj (get-obj index_b)))
				 (propagate-new-< (create-new-obj a) 
						  (set-bit-weakly index_b
								  (bit-ior (real-ord-obj-*< obj)
									   (real-ord-obj-*<= obj)))
						  (real-ord-obj-lb obj))))
			   (t (let ((obj_a (create-new-obj a))
				    (obj_b (create-new-obj b)))
				   (set-bit-*< *index obj_a)
				   (set-bit-*> (1- *index) obj_b))))))))
  )
(defun >=-rule (_a _b)
  (let ((index_a (get-index _a))
	(index_b (get-index _b))
	)
       (let ((a (cond ((and index_a (real-ord-obj-eq (get-obj index_a))))
		      (t _a)))
	     (b (cond ((and index_b (real-ord-obj-eq (get-obj index_b))))
		      (t _b)))
	     )
	    (cond ((and index_a (eq index_a index_b)))
		  ((and (numberp a) (numberp b))
		   (if (< a b)
		       (clash '>=-rule _a _b)))
		  ((numberp a)
		   (cond (index_b
			  (propagate-number->=-obj a (get-obj index_b)))
			 (t (set-ub (list '<= a) (create-new-obj b)))))
		  ((numberp b)
		   (cond (index_a
			  (propagate-number-<=-obj b (get-obj index_a)))
			 (t (set-lb (list '>= b) (create-new-obj a)))))
		  (t (cond ((and index_a index_b)
			    (cond ((symbolic-clash->=? index_a (get-obj index_b)) 
				   (clash '>=-rule _a _b))
				  (t (propagate-number-constraint->= (get-obj index_a)
								     (get-obj index_b)))))
			   (index_a  
			    (let ((obj (get-obj index_a))
				  (new-obj (create-new-obj b))
				  )
				 (propagate-new-> new-obj (real-ord-obj-*> obj) (real-ord-obj-ub obj))
				 (propagate-new->= new-obj 
						   (set-bit-weakly index_a
								   (real-ord-obj-*>= obj))
						   (real-ord-obj-ub obj))))
			   (index_b  
			    (let ((obj (get-obj index_b))
				  (new-obj (create-new-obj a))
				  )
				 (propagate-new-< new-obj (real-ord-obj-*< obj) (real-ord-obj-lb obj))
				 (propagate-new-<= new-obj 
						   (set-bit-weakly index_b
								   (real-ord-obj-*<= obj))
						   (real-ord-obj-lb obj))))
			   (t (let ((obj_a (create-new-obj a))
				    (obj_b (create-new-obj b)))
				   (set-bit-*<= *index obj_a)
				   (set-bit-*>= (1- *index) obj_b))))))))
  )
(defun <>-rule (_a _b)
  (let ((index_a (get-index _a))
	(index_b (get-index _b))
	)
       (let ((a (cond ((and index_a (real-ord-obj-eq (get-obj index_a))))
		      (t _a)))
	     (b (cond ((and index_b (real-ord-obj-eq (get-obj index_b))))
		      (t _b)))
	     )
	    (cond ((and index_a (eq index_a index_b)) 
		   (clash '<>-rule _a _b))
		  ((and (numberp a) (numberp b))
		   (if (= a b)
		       (clash '<>-rule _a _b)))
		  ((numberp a)
		   (cond (index_b
			  (propagate-number-<> a (get-obj index_b)))
			 (t (set-ne (list a) (create-new-obj b)))))
		  ((numberp b)
		   (cond (index_a
			  (propagate-number-<> b (get-obj index_a)))
			 (t (set-ne (list b) (create-new-obj a)))))
		  (t (cond ((and index_a index_b)
			    (cond ((symbolic-clash-<>? index_a (get-obj index_b)) 
				   (clash '<>-rule _a _b))
				  (t (propagate-symbolic-<> (get-obj index_a)
							    (get-obj index_b)))))
			   (index_a  
			    (set-bit-<> index_a (create-new-obj b))
			    (set-bit-<> *index (get-obj index_a)))
			   (index_b  
			    (set-bit-<> index_b (create-new-obj a))
			    (set-bit-<> *index (get-obj index_b)))
			   (t (let ((obj_a (create-new-obj a))
				    (obj_b (create-new-obj b)))
				   (set-bit-<> *index obj_a)
				   (set-bit-<> (1- *index) obj_b)))))))))
