// terminal.hpp
//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


// Terminal Set Class definitions  --> defined in terminal.cpp

// A terminal set is made up of two classes TS ( the terminal set itself )
// and Terminal for each block within the function set. Each class is defined
// below....

#ifndef __TERMINAL

#define __TERMINAL

#include <iostream.h>

// Below is defined the number of diffent values which a real or floating
// point number are allowed to have
// V.V. Important that Functions and terminals never >= 32767

#define RandomReal 32767  // the top number of an signed so you should never use
													// above this............
extern unsigned int NumberOfDifferentValues;  // see above note



class Terminal
{
// variables for the terminal numerical values
	unsigned int uiTerminal;

	friend class TS;               // TS needs to access private bits, honest!
// Print functions for Terminal and Terminal set....................
	friend ostream& operator << ( ostream&, Terminal* );
// simple functions which can return function and arguments to outside world
	friend unsigned int terminal( Terminal *pt );

public:
// standard constructor
	Terminal();
};

class TS
{
// pointer to the first function in the function
	Terminal *ptHeader;
// length of the function set............                
	unsigned int uiLength;

// print function for TS
	friend ostream& operator << ( ostream&, TS* );

public:

// standard constructor (not used)
	TS();
// enhanced constructor for TS function values then arguments
	TS( unsigned int noofargs, ... );
// standard destructor          
	~TS();
// returns the n'th value of the function set......
	Terminal *Nth( unsigned int n );
// chooses a random member of the function set......
	Terminal *Choose();
};

// a naughty global variable which user must create to place function set into
// because of adfs having individual function sets this is an array...........
extern TS *TerminalSets[];

// function to exit system nicely when error occurs...........................
extern void ExitSystem( char* );
#endif
