// rungps.cc

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


// Version 0.40  24 February 1994 apf ..............at long last some comments
// Version 0.1 15 March 1993 apf



// This is the main block of code which runs gpcpp. If you actually go through
// it slowly it should read a bit like english and be fairly understandable.
// The actually gpcpp evolving is four lines long !! The rest of the
// code concerns itself with opening and outputing to files...


// include population def'ns ( and gpv. gp, gene )
#include "pop.hpp"
// ifor random number generation
#include "gprand.hpp"

#include <fstream.h>
#include <time.h>
#include <string.h>

void CreateGenerationReport( ostream&, ostream&, Population*, GP* );


// The hulking great big block of code which brings all the components of gpcpp into a cohesive
// whole......................
void RunGPS( int PopulationSize, int Generation, char *strOut )
{
	Population *ppop;
	GP *BestOfAll;
	char strOutFile[12], strBestOutFile[12];

// Intro screen
	cout << "Genetic Programming in C++...Initialising system" << endl << endl;

// set up names for date file..............................................................
	strcpy( strOutFile, strOut );
	strcpy( strBestOutFile, strOut );
	strcat( strOutFile, ".dat" );
	strcat( strBestOutFile, "b.dat" );

// open the main output file for data in english and best of file for structural data..
	ofstream fout( strOutFile );
	ofstream bout( strBestOutFile );

// seeds random numbers for scientific purposes this should be maybe be input from command line?
	gp_srand( (unsigned)time(NULL) );

// calls function contained in your evolving code. This should include terminal and function set
// This function must be called before the creating the population
	InitialiseGPS();

// Create a complete new population for the use of gp all operators act on this structure
	if (!(ppop = new Population( PopulationSize, Generation )))     ExitSystem( "RunGPS: Population" );

// rather than printing out the population this prints out only that variables of the system
	fout << endl << (GPVariables *)ppop;
	cout << endl << (GPVariables *)ppop;

// make sure user knows creation has worked....................................................
	cout << endl<< "Creation Completed" << endl;

// Setup best of generation and best of all gps these are allocated memory as UNIX does not seem
// to like them being left as pointer variables though DOS was OK....
	if (!(BestOfAll = new GP)) ExitSystem( "RunGPS: BestOfGeneration" );

// evaluate the each member of the population 
	ppop->Evaluate();
	cout << "Evaluation Completed" << endl << endl;

// Print out the initial random data to a file
	fout << endl << endl << "Initial random population" << endl;
  CreateGenerationReport( fout, bout, ppop, BestOfAll );

// this next for statement is the actual genetic programming system
// which is in essence just repeated reproduction and crossover
// loop through all the generations .....
	for ( int gen = 1; gen <= Generation; gen++ )
	{
// start this particular generation and also make user known of the fact....
		cout << "Generation " << gen << " ... ";
		fout << endl <<  "Generation : " << gen << endl;

// Major workhorse components GP'ing bit NB generate is a steady state gp ( see generate.cc )
		ppop->Generate();

// the mutation operator should probably be included within the generate code but at the
// moment it is seperate as it is a last minute bolt on and can I get the code to work if
// NumberToMutate == 0 can I 'eck as like...
		ppop->Mutate();

// Create a report of this generation and how well it is doing.....
		CreateGenerationReport( fout, bout, ppop, BestOfAll );

		cout << "completed." << endl;      // finished this generation
	}

// Finished all the generations of genetic programming now its time to clean up before quiting
	fout << endl << endl << "Genetic Programming System Completed" << endl;

// pritn best of all gp to english file......................................................
	fout << endl << "The Best GP of all was: " << endl << BestOfAll 
	     << "Fitness               : " << BestOfAll->iFitness << endl
			 << "Structural Complexity : " << BestOfAll->iLength << endl;


// close the main output file
	fout.close();

// the gp structural loader function looks for the gp with a hash before it. This is defined
// as the best of as shown below though this does allow the user to edit the data file and
// change the position of the hash function....
	bout << "# ";                                                                                   // this makes loading operator use this string
	BestOfAll->Save( bout );
	bout.close();

// Tell the user you have finished and where to find the information and print name up
//  V.V.important that bit...
	cout << endl;
	cout << "Genetic Programming System Completed. Results in ";
	cout << strOutFile << " and " << strBestOutFile << endl;
	cout << endl << "Genetic Programming in C++ Kernel by Adam P. Fraser 1994" << endl;

// clean up all those components which have been created during the complete run......
	delete BestOfAll;
	delete ppop;

// calls function which should be in your code which deletes your created blocks
	CleanUpGPS();
}


// output all the data found in a generation....
void CreateGenerationReport( ostream& fout, ostream& bout, Population *ppop, GP *BestOfAll )
{
	GP *BestOfGeneration;

// Calculate the average fitness of the population and place this in output file...
	fout << "Average Fitness : " << (float)(ppop->TotalFitness()) / (float)ppop->PopulationSize << endl;

// Calculate the average fitness of the population and place this in output file...
	fout << "Average Length  : " << (float)(ppop->TotalLength()) / (float)ppop->PopulationSize << endl;

// Calculate the best of generation and place this in both utput files
	if (!(BestOfGeneration = new GP( ppop->Best() ) )) ExitSystem( "CreateGenerationReport" );
	fout << "Best Of Generation was : " << endl << BestOfGeneration
			 << "Fitness                : " << BestOfGeneration->iFitness << endl
			 << "Structural Complexity  : " << BestOfGeneration->iLength << endl;
	BestOfGeneration->Save( bout );
	bout << endl;

// Check if best of generation is the best yet
	if ( BestOfAll->iFitness <= BestOfGeneration->iFitness ) BestOfAll->Copy( BestOfGeneration);

// clean up...
	delete BestOfGeneration;
}


// rungps.cpp
