// function.hpp
// Function Set Class definitions  --> defined in function.cpp

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------

// A function set is made up of two classes FS ( the function set itself )
// and Function for each block within the function set. Each class is defined
// below....

#ifndef __FUNCTION

#define __FUNCTION

#include <iostream.h>

class Function
{
// variables for the function numerical value and the number of arguments it takes
	unsigned int uiFunction;                                        
	unsigned int uiArguments;

	friend class FS;               // FS needs to access private bits, honest!
// Print functions for Function and Function set....................
	friend ostream& operator << ( ostream&, Function* );
// simple functions which can return function and arguments to outside world
	friend unsigned int function( Function *pf );
	friend unsigned int arguments( Function *pf );

public:
// standard constructor
	Function();
};

class FS
{
// pointer to the first function in the function
	Function *pfHeader;
// length of the function set............                
	unsigned int uiLength;

// print function for FS
	friend ostream& operator << ( ostream&, FS* );

public:

// standard constructor (not used)
	FS();
// enhanced constructor for FS function values then arguments
	FS( unsigned int noofargs, ... );
// standard destructor          
	~FS();
// returns the n'th value of the function set......
	Function *Nth( unsigned int n );
// chooses a random member of the function set......
	Function *Choose();
};

// a naughty global variable which user must create to place function set into
// because of adfs having individual function sets this is an array...........
extern FS *FunctionSets[];

// function to exit system nicely when error occurs...........................
extern void ExitSystem( char* );
#endif
