/*******************************************************************
**                                                                **
**                    Genetic Library                             **
**                                                                **
**   A library of functions to give an environment for Genetic    **
**                      Algorithms.                               **
**                                                                **
**  While these functions were designed to be used in the field   **
**  of neural networks, they could easily (hopefully) be used on  **
**   other types of optimisations.  The library implements both   **
**   a 1-stage GA and a 2-stage GA. A one stage GA is a GA where  **
**   you only have one population, in a 2-stage GA you may have   **
**  several populations, and a "master" population wich controls  **
**                 the "sub" poulations.                          **
**                                                                **
**        This library has been implemented and tested on:        **
**                                                                **
**           IBM RS/6000 & AIX 3.2 & GCC 2.5.7                    **
**                                                                **
**                 PC & DOS 6.2 % MSC 7.0                         **
**                                                                **
**   This software is part of my Diplomarbeit at the University   **
**  Kassel, Researchgroup Neural Networks.  The software may be   **
**   used for academic and educational purposes.  The use in a    **
**   corporate environment depends on the written permission of   **
**   the author.  I give no warranty for the functions in this    **
**        library, although all have been tested.                 **
**                                                                **
**      You may alter the files in this library, but are not      **
**    permitted to redistribute the files under their original    **
**  name.  If you write additions to this library and would like  **
**    them to be included in future releases, contact me, I'll    **
**           include them and give you credit.                    **
**                                                                **
**      Send questions, bugs, requests for new features and       **
**                      additions to                              **
**                                                                **
**         jochenr@neuro.informatik.uni-kassel.de                 **
**                   University Kassel                            **
**                 FG Neuronale Netzwerke                         **
**                     Jochen Ruhland                             **
**                Heinrich-Plett-Str.  40                         **
**                     D-34132 Kassel                             **
**                        Germany                                 **
**                                                                **
*******************************************************************/
/* Genetic operators */
/* Erweiterung auf mehrere Populationen gleichzeitig */

#ifndef __USHORT
#define __USHORT
typedef unsigned short USHORT;
#endif

#define ISCALC          1
#define ISNOTCALC       0
#define ISFREE          1
#define ISNOTFREE       0
#define NOMOREFREE     -1

/* Struct zum Fuehren einer Rangliste */
struct r_list
{
    float	pop_error;	/* Der Fehler des Popelementes */
    int         bit_error;	/* Die Anzahl der falsch
				 * klassifizierten Bits */
    int         is_calculated;	/* Der Fehler wurde bereits berechnet */
    int         is_free;	/* Der entsprechende Popeintrag ist frei */
    int		age;		/* Wie alt ist das Ding */
    USHORT      *p;		/* Die Population selber */

    /* Variablen fuer mehrstufige Genetische Algorithmen */
    int         num_in_pop;	/* Anzahl der Elemente in der Pop */
    int         size_of_pop;	/* Die Groesse eines Popelementes */
    struct r_list *r;		/* Die Rangliste der Population */
    USHORT   	*their_p;	/* Zeiger auf das Genom der Subpopulation */
    void       	*spare;		/* Populationsspezifischer Bereich kann zur */
				/* Informationsspeicherung frei verwendet werden */
};

/* Holt das naechste, freie Element einer Rangliste */
extern int fetch_free(struct r_list * r, int number);

/* Einige Debugfunktionen */
extern void dump_ranklist(struct r_list * r, int number);
extern void debug_ranklist(struct r_list * r, int number);

/* Sortiert eine Rangliste */
extern void sort_rank(struct r_list * r, int size);

/* Erstellt eine Rangliste der Population */
extern void __set_rank(struct r_list * rank, int number,
			   float (*ges_error) (), void *t, void *s);

extern double __compute_hamming(struct r_list * r, int number, int size);

extern int __dimension(struct r_list * r, int number, int size);

struct auslese_param
{
    float	rate;
};

extern const struct auslese_param def_auslese;

extern int auslese(struct r_list * r, int number, struct auslese_param * a);

extern void init_rank_list(struct r_list * r, int np);


