/*******************************************************************
**                                                                **
**                    Genetic Library                             **
**                                                                **
**   A library of functions to give an environment for Genetic    **
**                      Algorithms.                               **
**                                                                **
**  While these functions were designed to be used in the field   **
**  of neural networks, they could easily (hopefully) be used on  **
**   other types of optimisations.  The library implements both   **
**   a 1-stage GA and a 2-stage GA. A one stage GA is a GA where  **
**   you only have one population, in a 2-stage GA you may have   **
**  several populations, and a "master" population wich controls  **
**                 the "sub" poulations.                          **
**                                                                **
**        This library has been implemented and tested on:        **
**                                                                **
**           IBM RS/6000 & AIX 3.2 & GCC 2.5.7                    **
**                                                                **
**                 PC & DOS 6.2 % MSC 7.0                         **
**                                                                **
**   This software is part of my Diplomarbeit at the University   **
**  Kassel, Researchgroup Neural Networks.  The software may be   **
**   used for academic and educational purposes.  The use in a    **
**   corporate environment depends on the written permission of   **
**   the author.  I give no warranty for the functions in this    **
**        library, although all have been tested.                 **
**                                                                **
**      You may alter the files in this library, but are not      **
**    permitted to redistribute the files under their original    **
**  name.  If you write additions to this library and would like  **
**    them to be included in future releases, contact me, I'll    **
**           include them and give you credit.                    **
**                                                                **
**      Send questions, bugs, requests for new features and       **
**                      additions to                              **
**                                                                **
**         jochenr@neuro.informatik.uni-kassel.de                 **
**                   University Kassel                            **
**                 FG Neuronale Netzwerke                         **
**                     Jochen Ruhland                             **
**                Heinrich-Plett-Str.  40                         **
**                     D-34132 Kassel                             **
**                        Germany                                 **
**                                                                **
*******************************************************************/
/* Debugging stuff */
#ifndef DEBUG_MACROS
#define DEBUG_MACROS

#ifndef GENLIB_DEBUG
#define GENLIB_DEBUG 0
#endif

/* Debuglevel : 0   - kein Debugoutput */
/* Debuglevel : 1   - Aufruf der Funktionen wird angezeigt */
/* Debuglevel : 2   - Alle Parameter, die keine Pointer sind */


#if (GENLIB_DEBUG>0)
#include <malloc.h>
/* Fuer die HEAP-Testroutine */
#endif

extern FILE    *debugfile;

#if(GENLIB_DEBUG==0)
/* Keine Meldung */
#elif (GENLIB_DEBUG==1)
#pragma message( "Debuglevel 1" )
#elif (GENLIB_DEBUG==2)
#pragma message( "Debuglevel 2" )
#endif

#if(GENLIB_DEBUG>0)
#ifndef _MSDOS 
extern unsigned short _debugmodule_star;
#endif

#define DEBUG_call(name)\
    fprintf( debugfile, "Call "#name"\n" )

#define DEBUGr_uint(var)\
    fprintf( debugfile, "Return(i) : %d\n",(unsigned int)var )

#define DEBUGr_int(var)\
    fprintf( debugfile, "Return(i) : %d\n",(int)var )

#define DEBUGr_const(var)\
    fprintf( debugfile, "Return(c) : "#var"\n" )

#define DEBUGr_double(var)\
    fprintf( debugfile, "Return(d) : %f\n",(double)var )

#ifdef _MSDOS
#define DEBUG_pointer(p)\
    {int status=_heapchk();\
	if( status!=_HEAPOK )\
	{\
	    fprintf( stderr,"Heap corrupt in "__FILE__" at %d with %d\n",\
		__LINE__, status );\
	    abort();\
	};\
    }

#else
#define DEBUG_pointer(p)\
    {_debugmodule_star += *(unsigned short *)(p); }
#endif

#else
#define DEBUG_call(name)
#define DEBUGr_int(name)
#define DEBUGr_uint(name)
#define DEBUGr_const(name)
#define DEBUGr_double(name)
#define DEBUG_pointer(p)
#endif

#if(GENLIB_DEBUG>1)

#define DEBUG_int(var)\
    fprintf( debugfile, "Var "#var" : %d\n",(int)var )

#define DEBUG_uint(var)\
    fprintf( debugfile, "Var "#var" : %u\n",(unsigned int)var )

#define DEBUG_ushort(var)\
    fprintf( debugfile, "Var "#var" : %hd\n",(unsigned short)var )

#define DEBUG_ulong(var)\
    fprintf( debugfile, "Var "#var" : %ld\n",(unsigned long)var )

#define DEBUG_double(var)\
    fprintf( debugfile, "Var "#var" : %f\n",(double)var )

#define DEBUG_float(var)\
    fprintf( debugfile, "Var "#var" : %f\n",(float)var )

#define DEBUG_char(var)\
    fprintf( debugfile, (var!=EOF?"Var "#var" : %c\n":"Var "#var" : EOF\n"),\
	(char)var )

#define DEBUGc(ch)\
    fputc( ch, debugfile )

#define DEBUGs(s)\
    fprintf( debugfile,"%s",s );

#else
#define DEBUG_int(var)
#define DEBUG_uint(var)
#define DEBUG_ushort(var)
#define DEBUG_ulong(var)
#define DEBUG_float(var)
#define DEBUG_double(var)
#define DEBUG_char(var)
#define DEBUGc(ch)
#define DEBUGs(s)
#endif

extern void DEBUG_flush();

extern void DEBUG_fopen(char *name);

extern void DEBUG_fclose();

extern void DEBUG_msg(char *strg);

#endif


