/*******************************************************************
**                                                                **
**                    Genetic Library                             **
**                                                                **
**   A library of functions to give an environment for Genetic    **
**                      Algorithms.                               **
**                                                                **
**  While these functions were designed to be used in the field   **
**  of neural networks, they could easily (hopefully) be used on  **
**   other types of optimisations.  The library implements both   **
**   a 1-stage GA and a 2-stage GA. A one stage GA is a GA where  **
**   you only have one population, in a 2-stage GA you may have   **
**  several populations, and a "master" population wich controls  **
**                 the "sub" poulations.                          **
**                                                                **
**        This library has been implemented and tested on:        **
**                                                                **
**           IBM RS/6000 & AIX 3.2 & GCC 2.5.7                    **
**                                                                **
**                 PC & DOS 6.2 % MSC 7.0                         **
**                                                                **
**   This software is part of my Diplomarbeit at the University   **
**  Kassel, Researchgroup Neural Networks.  The software may be   **
**   used for academic and educational purposes.  The use in a    **
**   corporate environment depends on the written permission of   **
**   the author.  I give no warranty for the functions in this    **
**        library, although all have been tested.                 **
**                                                                **
**      You may alter the files in this library, but are not      **
**    permitted to redistribute the files under their original    **
**  name.  If you write additions to this library and would like  **
**    them to be included in future releases, contact me, I'll    **
**           include them and give you credit.                    **
**                                                                **
**      Send questions, bugs, requests for new features and       **
**                      additions to                              **
**                                                                **
**         jochenr@neuro.informatik.uni-kassel.de                 **
**                   University Kassel                            **
**                 FG Neuronale Netzwerke                         **
**                     Jochen Ruhland                             **
**                Heinrich-Plett-Str.  40                         **
**                     D-34132 Kassel                             **
**                        Germany                                 **
**                                                                **
*******************************************************************/
/* Support Funktionen */

/* Maximale Anzahl von erkannten Parametern */
#define MAX_PARAMS  20

/* Wird Parameter nur als UPCASE erkannt */
#define P_UPCASEPAR	1
/* Wird Parameter nur als LOCASE erkannt */
#define P_LOCASEPAR	2
/* Wird Parameter sowohl als auch erkannt */
#define P_NOCASEPAR	0

/* Moegliche Datentypen */
#define P_SHORT		0
#define P_LONG		1
#define P_INT		2
#define P_FLOAT		3
#define P_DOUBLE	4
#define P_CHAR		5
#define P_STRING	6
#define P_BOOLEAN_ON	7	/* Muss ein INT sein */
/* Ein Parameter der per default an ist. Vorkommen dieser Option schltet aus */

#define P_BOOLEAN_OFF	8	/* Muss ein INT sein */
/* Ein Parameter der per default aus ist. Vorkommen dieser Option schltet an */


extern struct pararray
{
	char            switch_char;
	short           set_case;
	short           datatype;
	void           *parameter;
} p_array[MAX_PARAMS];

/* Wieviele Parameter sollen erkannt werden */
extern int def_parameter;

/* Parameter des Programms parsen */
extern void parse_parameter(int num, char **vals);

