/*******************************************************************
**                                                                **
**                    Genetic Library                             **
**                                                                **
**   A library of functions to give an environment for Genetic    **
**                      Algorithms.                               **
**                                                                **
**  While these functions were designed to be used in the field   **
**  of neural networks, they could easily (hopefully) be used on  **
**   other types of optimisations.  The library implements both   **
**   a 1-stage GA and a 2-stage GA. A one stage GA is a GA where  **
**   you only have one population, in a 2-stage GA you may have   **
**  several populations, and a "master" population wich controls  **
**                 the "sub" poulations.                          **
**                                                                **
**        This library has been implemented and tested on:        **
**                                                                **
**           IBM RS/6000 & AIX 3.2 & GCC 2.5.7                    **
**                                                                **
**                 PC & DOS 6.2 % MSC 7.0                         **
**                                                                **
**   This software is part of my Diplomarbeit at the University   **
**  Kassel, Researchgroup Neural Networks.  The software may be   **
**   used for academic and educational purposes.  The use in a    **
**   corporate environment depends on the written permission of   **
**   the author.  I give no warranty for the functions in this    **
**        library, although all have been tested.                 **
**                                                                **
**      You may alter the files in this library, but are not      **
**    permitted to redistribute the files under their original    **
**  name.  If you write additions to this library and would like  **
**    them to be included in future releases, contact me, I'll    **
**           include them and give you credit.                    **
**                                                                **
**      Send questions, bugs, requests for new features and       **
**                      additions to                              **
**                                                                **
**         jochenr@neuro.informatik.uni-kassel.de                 **
**                   University Kassel                            **
**                 FG Neuronale Netzwerke                         **
**                     Jochen Ruhland                             **
**                Heinrich-Plett-Str.  40                         **
**                     D-34132 Kassel                             **
**                        Germany                                 **
**                                                                **
*******************************************************************/
/* Setzen des Target-Vektors */
#include "genetic_.h"
char *target_func = "cos(x)*0.5+0.5";struct target targets[N_TARGET];
void set_target()
{
	targets[0].input[0] = 0.000000;
	targets[0].output[0] = 1.000000;

	targets[1].input[0] = 0.104720;
	targets[1].output[0] = 0.997261;

	targets[2].input[0] = 0.209440;
	targets[2].output[0] = 0.989074;

	targets[3].input[0] = 0.314159;
	targets[3].output[0] = 0.975528;

	targets[4].input[0] = 0.418879;
	targets[4].output[0] = 0.956773;

	targets[5].input[0] = 0.523599;
	targets[5].output[0] = 0.933013;

	targets[6].input[0] = 0.628319;
	targets[6].output[0] = 0.904508;

	targets[7].input[0] = 0.733038;
	targets[7].output[0] = 0.871572;

	targets[8].input[0] = 0.837758;
	targets[8].output[0] = 0.834565;

	targets[9].input[0] = 0.942478;
	targets[9].output[0] = 0.793893;

	targets[10].input[0] = 1.047198;
	targets[10].output[0] = 0.750000;

	targets[11].input[0] = 1.151917;
	targets[11].output[0] = 0.703368;

	targets[12].input[0] = 1.256637;
	targets[12].output[0] = 0.654508;

	targets[13].input[0] = 1.361357;
	targets[13].output[0] = 0.603956;

	targets[14].input[0] = 1.466077;
	targets[14].output[0] = 0.552264;

	targets[15].input[0] = 1.570796;
	targets[15].output[0] = 0.500000;

	targets[16].input[0] = 1.675516;
	targets[16].output[0] = 0.447736;

	targets[17].input[0] = 1.780236;
	targets[17].output[0] = 0.396044;

	targets[18].input[0] = 1.884956;
	targets[18].output[0] = 0.345492;

	targets[19].input[0] = 1.989675;
	targets[19].output[0] = 0.296632;

	targets[20].input[0] = 2.094395;
	targets[20].output[0] = 0.250000;

	targets[21].input[0] = 2.199115;
	targets[21].output[0] = 0.206107;

	targets[22].input[0] = 2.303835;
	targets[22].output[0] = 0.165435;

	targets[23].input[0] = 2.408554;
	targets[23].output[0] = 0.128428;

	targets[24].input[0] = 2.513274;
	targets[24].output[0] = 0.095492;

	targets[25].input[0] = 2.617994;
	targets[25].output[0] = 0.066987;

	targets[26].input[0] = 2.722714;
	targets[26].output[0] = 0.043227;

	targets[27].input[0] = 2.827433;
	targets[27].output[0] = 0.024472;

	targets[28].input[0] = 2.932153;
	targets[28].output[0] = 0.010926;

	targets[29].input[0] = 3.036873;
	targets[29].output[0] = 0.002739;

	targets[30].input[0] = 3.141593;
	targets[30].output[0] = 0.000000;

	targets[31].input[0] = 3.246312;
	targets[31].output[0] = 0.002739;

	targets[32].input[0] = 3.351032;
	targets[32].output[0] = 0.010926;

	targets[33].input[0] = 3.455752;
	targets[33].output[0] = 0.024472;

	targets[34].input[0] = 3.560472;
	targets[34].output[0] = 0.043227;

	targets[35].input[0] = 3.665191;
	targets[35].output[0] = 0.066987;

	targets[36].input[0] = 3.769911;
	targets[36].output[0] = 0.095492;

	targets[37].input[0] = 3.874631;
	targets[37].output[0] = 0.128428;

	targets[38].input[0] = 3.979351;
	targets[38].output[0] = 0.165435;

	targets[39].input[0] = 4.084070;
	targets[39].output[0] = 0.206107;

	targets[40].input[0] = 4.188790;
	targets[40].output[0] = 0.250000;

	targets[41].input[0] = 4.293510;
	targets[41].output[0] = 0.296632;

	targets[42].input[0] = 4.398230;
	targets[42].output[0] = 0.345492;

	targets[43].input[0] = 4.502949;
	targets[43].output[0] = 0.396044;

	targets[44].input[0] = 4.607669;
	targets[44].output[0] = 0.447736;

	targets[45].input[0] = 4.712389;
	targets[45].output[0] = 0.500000;

	targets[46].input[0] = 4.817109;
	targets[46].output[0] = 0.552264;

	targets[47].input[0] = 4.921828;
	targets[47].output[0] = 0.603956;

	targets[48].input[0] = 5.026548;
	targets[48].output[0] = 0.654508;

	targets[49].input[0] = 5.131268;
	targets[49].output[0] = 0.703368;

	targets[50].input[0] = 5.235988;
	targets[50].output[0] = 0.750000;

	targets[51].input[0] = 5.340708;
	targets[51].output[0] = 0.793893;

	targets[52].input[0] = 5.445427;
	targets[52].output[0] = 0.834565;

	targets[53].input[0] = 5.550147;
	targets[53].output[0] = 0.871572;

	targets[54].input[0] = 5.654867;
	targets[54].output[0] = 0.904508;

	targets[55].input[0] = 5.759587;
	targets[55].output[0] = 0.933013;

	targets[56].input[0] = 5.864306;
	targets[56].output[0] = 0.956773;

	targets[57].input[0] = 5.969026;
	targets[57].output[0] = 0.975528;

	targets[58].input[0] = 6.073746;
	targets[58].output[0] = 0.989074;

	targets[59].input[0] = 6.178466;
	targets[59].output[0] = 0.997261;

}
