/*******************************************************************
**                                                                **
**                    Genetic Library                             **
**                                                                **
**   A library of functions to give an environment for Genetic    **
**                      Algorithms.                               **
**                                                                **
**  While these functions were designed to be used in the field   **
**  of neural networks, they could easily (hopefully) be used on  **
**   other types of optimisations.  The library implements both   **
**   a 1-stage GA and a 2-stage GA. A one stage GA is a GA where  **
**   you only have one population, in a 2-stage GA you may have   **
**  several populations, and a "master" population wich controls  **
**                 the "sub" poulations.                          **
**                                                                **
**        This library has been implemented and tested on:        **
**                                                                **
**           IBM RS/6000 & AIX 3.2 & GCC 2.5.7                    **
**                                                                **
**                 PC & DOS 6.2 % MSC 7.0                         **
**                                                                **
**   This software is part of my Diplomarbeit at the University   **
**  Kassel, Researchgroup Neural Networks.  The software may be   **
**   used for academic and educational purposes.  The use in a    **
**   corporate environment depends on the written permission of   **
**   the author.  I give no warranty for the functions in this    **
**        library, although all have been tested.                 **
**                                                                **
**      You may alter the files in this library, but are not      **
**    permitted to redistribute the files under their original    **
**  name.  If you write additions to this library and would like  **
**    them to be included in future releases, contact me, I'll    **
**           include them and give you credit.                    **
**                                                                **
**      Send questions, bugs, requests for new features and       **
**                      additions to                              **
**                                                                **
**         jochenr@neuro.informatik.uni-kassel.de                 **
**                   University Kassel                            **
**                 FG Neuronale Netzwerke                         **
**                     Jochen Ruhland                             **
**                Heinrich-Plett-Str.  40                         **
**                     D-34132 Kassel                             **
**                        Germany                                 **
**                                                                **
*******************************************************************/
#include <stdio.h>
#include <math.h>
#include "topology.h"

int main()
{
	double xval, yval;
	int i;
	/* Erzeugen der set_targ.c Datei */
	printf( "/* Setzen des Target-Vektors */\n" );
	printf( "#include \"genetic_.h\"\n" );
	printf( "char *target_func = \"cos(x)*0.5+0.5\";" );
	printf( "struct target targets[N_TARGET];\n" );
	printf( "void set_target()\n" );
	printf( "{\n" );
	for( i=0; i<N_TARGET; i++ )
	{
		xval = 2.0*((double)i)*M_PI/((double)N_TARGET);
		yval = (cos(xval)*0.5)+0.5;
		printf( "\ttargets[%d].input[0] = %f;\n",i,xval );
		printf( "\ttargets[%d].output[0] = %f;\n\n",i,yval );
		fprintf( stderr,"%f %f\n", xval, yval );
	}
	printf( "}\n" );
	return 0;
}
