/* NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/




#ifndef protokoll_h
#define protokoll_h

#include <InterViews/monoglyph.h>
#include <InterViews/action.h>

#include "wissensbank.h"
#include "koosystem.h"
#include "nfclook.h"
#include "regel_tafel.h"
#include "regel_tab.h"
#include "protokoll_ed.h"

/*
 *------------------------------------------------------------------------------
 * Klasse : WerteBrowser
 * Zweck  : Stellt die Steuer- und Messwerte sowie den Systemfehler auf dem
 *          Bildschirm dar.
 *------------------------------------------------------------------------------
 */

class WerteBrowser
{
  public : virtual Glyph* glyph() = 0;
           virtual void eingabe_var(int var_nr, FuzzyTyp wert) = 0;
           virtual void ausgabe_var(int var_nr, FuzzyTyp wert) = 0;
           virtual void fehler_var(FuzzyTyp fehler) = 0;
};


/*
 *------------------------------------------------------------------------------
 * Klasse : LingVarBrowser
 * Zweck  : Stellt die Fuzzy-Sets eines LingVarSatzes grafisch auf dem Bild-
 *          schirm dar.
 *------------------------------------------------------------------------------
 */

class LingVarBrowser : public MonoGlyph
{
  public : LingVarBrowser();
           virtual void draw(Canvas*, const Allocation&) const;
           void init(const LingVarSatz*);
           void zeig_var(int nr);
           void zeig_fuz(Regel*);
           void init_var_tafel();
           void aktualisiere();
  private: void _var_auswahl();
           void _zeichne_fuzzysets() const;
           const LingVarSatz* _lingvarsatz;
           NfcStrBrowser* _var_tafel;
           KooSystem* _grafik;
           int _merk_var_nr,
               _markiert;
};


/*
 *------------------------------------------------------------------------------
 * Klasse : DateiProtokoll
 * Zweck  : Oeffnet Datei und legt in dieser Protokoll-Daten ab. Der Name der
 *          Datei kann per Resourcen bestimmt werden.
 *------------------------------------------------------------------------------
 */
class DateiProtokoll
{
  public : DateiProtokoll(const LingVarSatz*);
           ~DateiProtokoll();
           void start(float lern_faktor, const LingVarSatz*);
           void ende(long anz_schritte, const LingVarSatz*);
           void fehlschlag();
           void messwert(int nr, FuzzyTyp wert);
           void steuerwert(int nr, FuzzyTyp wert);
           void fehlerwert(FuzzyTyp);
  private: void _schreib_lingvarsatz(const LingVarSatz*);
           ofstream* _datei;
           const LingVarSatz* _lingvarsatz;
};


/*
 *------------------------------------------------------------------------------
 * Klasse : NfcProtokoll
 * Zweck  : Zeigt alle wichtigen Werte waehrend der Steuerung einer Anwendung.
 *          Protokolliert werden koennen dabei :
 *            - die Aenderung in den Fuzzy-Sets der Steuer-Variablen
 *            - welche Regeln benutzt werden
 *            - das Fuzzy-Set mit dem groessten Treffergrad
 *            - Mess- und Steuerwerte sowie Systemfehler
 *          Ausserdem kann eine Protokoll-Datei mit allen wichtigen Daten
 *          angelegt werden, diese wird auch dann weiter aktualisiert, wenn das
 *          Protokoll gestoppt wurde.
 *          Was wie protokolliert wird, wird durch die 'ProtokollStruktur' dem
 *          Konstruktor mitgeteilt.
 *------------------------------------------------------------------------------
 */

class NfcProtokoll : public Protokoll, public MonoGlyph
{
  public : NfcProtokoll(Wissensbank*, ProtokollStruktur*);
           ~NfcProtokoll();
           void stop(boolean);

           // fuers grafische Protokoll
           virtual void init(const LingVarSatz*);
           virtual void init(const RegelBasis*);
           virtual void aktua_lingvarsatz();
           virtual void zeig_regel(int nr);

           // fuers Datei-Protokoll
           virtual void fehlschlag();
           void datei_start(float lern_faktor, const LingVarSatz*);
           void datei_ende(long anz_schritte, const LingVarSatz*);

           // fuer Beides
           virtual void zeig_eingabe_var(int var_nr, FuzzyTyp wert);
           virtual void zeig_ausgabe_var(int var_nr, FuzzyTyp wert);
           virtual void zeig_fehler(FuzzyTyp fehler);

  // Zustandsvariablen
  private: boolean _gestoppt;
           Wissensbank* _wissensbank;

  // Grafikelemente
  private: RegelBrowser* _regel_browser;
           LingVarBrowser* _var_browser;
           WerteBrowser* _werte_browser;
           DateiProtokoll* _prot_datei;
};
#endif
