/* NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/




#ifndef lingvar_ed_h
#define lingvar_ed_h

#include <InterViews/monoglyph.h>

#include "nfclook.h"
#include "lingvar.h"

class FuzzySetAuswahl;

/*
 *------------------------------------------------------------------------------
 * Klasse : LingVarEd
 * Zweck  : Oeffnet ein Popup-Window, das Grafikelemente enthaelt, mit dessen
 *          Hilfe linguistische Variablen und deren Fuzzy-Sets eingegeben werden
 *          koennen.
 *------------------------------------------------------------------------------
 */
class LingVarEd : public NfcDialogFenster
{
  public : LingVarEd(
             const LingVarSatz*,
             boolean steuer_var,
             Action* ok_cb,
             Action* nook_cb
           );
           ~LingVarEd();
           LingVarSatz* lingvar();
  private: void _ende();
           Action* _ende_cb;
           LingVarSatz _lingvarsatz;
           FuzzySetAuswahl* _fuz_editor;
           NfcAusgabe* _ausgabe_feld;
};

#endif
