/* NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/




#ifndef datei_h
#define datei_h

#include <iostream.h>
#include <IV-look/dialogs.h>

#include "lingvar.h"
#include "regel.h"
#include "nfclook.h"

/*
 *------------------------------------------------------------------------------
 * Klasse : DateiArbeit
 * Zweck  : Dient dem Abspeicher und Laden von linguistischen Variablen und
 *          Regeln in/aus Dateien.
 *------------------------------------------------------------------------------
 */
class DateiArbeit
{
  public : DateiArbeit(Window*, NfcAusgabe*);
           void speichern(boolean steuer_var, const LingVarSatz*);
           void speichern(boolean steuer_regeln, const RegelBasis*);
           void laden(boolean steuer_var, LingVarSatz*);
           void laden(boolean steuer_regeln, RegelBasis*);

  // lokale Funktionen und Variablen
  private: enum Modus { LvSpeichern, LvLaden, RgSpeichern, RgLaden };
           void _ausfuehren(Modus);
           void _callback(FileChooser*, boolean ok);
           CopyString _parse(String eingabe, String extension);
           Modus _modus;
           String _lv_extension,           // Datei-Endungen
                  _rg_extension,
                  _lv_filter,
                  _rg_filter;

           const LingVarSatz* _quell_vars;
           LingVarSatz* _ziel_vars;

           const RegelBasis* _quell_regeln;
           RegelBasis* _ziel_regeln;

           // Handelt es sich um Steuer- oder Fehler-Var/Regeln ?
           // ist nur wichtig fuer Meldung im Ausgabefenster.
           boolean _steuer_daten;

           Window* _basis_fenster;
           NfcAusgabe* _ausgabe_feld;
};

  // Deklartionen fuer die Ein/Ausgabe-Operatoren fuer ling. Variablen
  ostream& operator<<(ostream& os, FsIntervall*);
  istream& operator>>(istream& is, FsIntervall*);

  ostream& operator<<(ostream& os, FuzzySet*);
  istream& operator>>(istream& is, FuzzySet*);

  ostream& operator<<(ostream& os, LingVar*);
  istream& operator>>(istream& is, LingVar*);

  ostream& operator<<(ostream& os, const LingVarSatz*);
  istream& operator>>(istream& is, LingVarSatz*);

  // Deklartionen fuer die Ein/Ausgabe-Operatoren fuer Regeln
  ostream& operator<<(ostream& os, const RegelBasis*);
  istream& operator>>(istream& is, RegelBasis*);

  ostream& operator<<(ostream& os, Regel*);
  istream& operator>>(istream& is, Regel*);

  // Hilfsfunktion zum Loeschen von Trennzeichen
  void del_trenn(istream& is);

#endif
