/* NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/




#ifndef control_ed_h
#define control_ed_h

#include <InterViews/monoglyph.h>
#include <InterViews/action.h>

#include "nfclook.h"
#include "protokoll_ed.h"
#include "protokoll.h"
#include "wissensbank.h"

/*
 *------------------------------------------------------------------------------
 * Klasse : ControllerEd
 * Zweck  : Aufruf des Controllers und Anzeige des Protokolls.
 *------------------------------------------------------------------------------
 */
class ControllerEd : public NfcDialogFenster
{
  public : ControllerEd(Wissensbank*, ProtokollStruktur*, Action* ende_cb);
           ~ControllerEd();

  // lokale Funktionen  (alles Callbacks)
  private: void _lies_werte();
           void _fehler();
           void _start();
           void _stop();
           void _ende();
           void _stop_prot();
           void _setz_faktor();
           void _hol_lern_strukt();

  // Zustands-Variablen
  private: Wissensbank* _wissensbank;
           int _regeln_lernen, _fuz_optimieren;
           float _lern_faktor;
           boolean _prot_einfrieren;
           boolean _aktiv;
           int _merk_anzahl1, _merk_anzahl2;
           long _zaehler;
           RgLernStruktur _lern_strukt;

  // Grafikelemente
  private: NfcProtokoll* _protokoll;          // Protokoll-Teil
           NfcAusgabe* _ausgabe_feld;         // Ausgabe-Teil
           EingabeFeld *_lernphase1_ed, *_lernphase2_ed, *_lernfaktor_ed;
           Action* _ende_cb;
           Button* _lern_option_bt;           // Initiiert Eingabe fuer Lrn-Opt.
};

#endif
