/* PENDULUM: a graphical simulation of an inverted pendulum; part of 
   NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "pendel_texte.h"

/*
 * Anmerkung :
 * Beim Hinzufuegen neuer Texte sollte darauf geachtet werden, dass diese
 * sowohl in Deutsch als auch in Englisch angegeben werden. Bei der Auswahl
 * von Texten mittels 'Txt(int)' werden die Array-Grenzen nicht kontrolliert,
 * d.h. bei zu grossen Nummern 'geht er baden'.
 */

char* deutsch[] = {
  /*000*/    "<"                                                    ,
  /*001*/    ">"                                                    ,
  /*002*/    "Warnung :"                                            ,
  /*003*/    "Fehler :"                                             ,
  /*004*/    "Auto-Start"                                           ,
  /*005*/    "Zufallswinkel"                                        ,
  /*006*/    "reset"                                                ,
  /*007*/    "Start-Werte"                                          ,
  /*008*/    "Pendel-Winkel : "                                     ,
  /*009*/    "Winkel-Geschw. : "                                    ,
  /*010*/    "Wagen-Position : "                                    ,
  /*011*/    "Wagen-Geschw. : "                                     ,
  /*012*/    "Grundeinstellung"                                     ,
  /*013*/    "Laenge der Strecke : "                                ,
  /*014*/    "Synchron.-Faktor : "                                  ,
  /*015*/    "Zaehler : "                                           ,
  /*016*/    "Meldungen"                                            ,
  /*017*/    "Start"                                                ,
  /*018*/    "Stop"                                                 ,
  /*019*/    "Ende"                                                 ,
  /*020*/    "Winkel zu gross"                                      ,
  /*021*/    "Winkel-Geschwindigkeit ist zu gross"                  ,
  /*022*/    "zu hoher Wert fuer Position"                          ,
  /*023*/    "Wagen-Geschwindigkeit ist zu gross"                   ,
  /*024*/    "Kraft ist zu gross"                                   ,
  /*025*/    "Pendel ist umgekippt"                                 ,
  /*026*/    "Streckenende erreicht"                                ,
  /*027*/    "unbekanntes Zeichen : "                               ,
  /*028*/    "zuerst Pendel stoppen"                                ,
  /*029*/    "ohne"                                                 ,
  /*030*/    "Pendel"                                               ,
  /*031*/    "Pendel gestoppt"                                      ,
  /*032*/    "Pendel gestartet"
};

char* englisch[] = {
  /*000*/    "<"                                                    ,
  /*001*/    ">"                                                    ,
  /*002*/    "warning :"                                            ,
  /*003*/    "error :"                                              ,
  /*004*/    "auto start"                                           ,
  /*005*/    "random angle"                                      ,
  /*006*/    "reset"                                                ,
  /*007*/    "start values"                                         ,
  /*008*/    "angle of pend. : "                                    ,
  /*009*/    "angle velocity : "                                    ,
  /*010*/    "cart position : "                                     ,
  /*011*/    "cart velocity : "                                     ,
  /*012*/    "settings"                                             ,
  /*013*/    "length of track : "                                ,
  /*014*/    "synchron. factor : "                                  ,
  /*015*/    "counter : "                                           ,
  /*016*/    "messages"                                             ,
  /*017*/    "start"                                                ,
  /*018*/    "stop"                                                 ,
  /*019*/    "end"                                                  ,
  /*020*/    "angle to large"                                       ,
  /*021*/    "angle velocity is to large"                           ,
  /*022*/    "cart position is to large"                            ,
  /*023*/    "cart velocity is to large"                            ,
  /*024*/    "force is to large"                                    ,
  /*025*/    "pendulum dropped"                                     ,
  /*026*/    "end of line reached"                                  ,
  /*027*/    "unknown character : "                                 ,
  /*028*/    "first stop the pendulum"                              ,
  /*029*/    "without"                                              ,
  /*030*/    "inverted pendulum"                                    ,
  /*031*/    "pendulum stopped"                                     ,
  /*032*/    "pendulum started"
};

// falls kein init_texte_.. aufgerufen wird : deutsche Texte
char** text_array = deutsch;
// if you want to have an english interface by default, comment out the 
// previous command line, and uncomment the following line.
//char** text_array = englisch;

void init_texte_deutsch() { text_array = deutsch; }

void init_texte_englisch() { text_array = englisch; }
