/* PENDULUM: a graphical simulation of an inverted pendulum; part of 
   NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <InterViews/background.h>
#include <InterViews/session.h>
#include <InterViews/style.h>
#include <InterViews/window.h>
#include <IV-look/kit.h>
#include <InterViews/layout.h>

#include "pendel_texte.h"
#include "pendel.h"

static PropertyData props[] = {
    { "*FieldEditor*background",                     "#90ffa0" },
    { "*cursorFlashRate",                                  "0" },
    { "*NfcEditorFont*font", "*helvetica-medium-r-normal--12*" },
    { "*NfcInfoFont*font",     "*helvetica-bold-r-normal--12*" },
    { "*PushButton*font",          "*times-bold-r-normal--12*" },
    { "*LaengeStrecke",                                    "0" },
    { "*mitWinkel",                                       "on" },
    { "*mitWiGeschw",                                     "on" },
    { "*mitPosition",                                    "off" },
    { "*mitWaGeschw",                                    "off" },
    { "*english",                                        "off" },
    { nil }
};

static OptionDesc options[] = {
    { "editorfont=", "*NfcEditorFont", OptionValueAfter          },
    { "infofont=",   "*NfcInfoFont",   OptionValueAfter          },
    { "buttonfont=", "*NfcButtonFont", OptionValueAfter          },
    { "-laenge=",    "*LaengeStrecke", OptionValueAfter          },
    { "-mWi",        "*mitWinkel",     OptionValueImplicit, "on" },
    { "-mWiG",       "*mitWiGeschw",   OptionValueImplicit, "on" },
    { "-mPo",        "*mitPosition",   OptionValueImplicit, "on" },
    { "-mWaG",       "*mitWaGeschw",   OptionValueImplicit, "on" },
    { "-e",          "*english",       OptionValueImplicit, "on" },
    { nil }
};

int main(int argc, char** argv)
{
  Session* session = new Session("pendel", argc, argv, options, props);
  WidgetKit* wkit  = WidgetKit::instance();
  Style* style     = wkit->style();

  // Setzen der Sprache
  if(style->value_is_on("english"))
    init_texte_englisch();
  else
    init_texte_deutsch();

  style->attribute("name", Txt(30));

  PendelFenster* ThePendelFenster = new PendelFenster(style);
  Window* TheWindow = new ApplicationWindow(
                          new Background(ThePendelFenster, 
                                         wkit->background()
                              ) 
                          );

  session->run_window(TheWindow);
}
