#include <InterViews/background.h>
#include <InterViews/session.h>
#include <InterViews/style.h>
#include <InterViews/window.h>
#include <IV-look/kit.h>
#include <InterViews/layout.h>

#include "pendel_texte.h"
#include "pendel.h"

static PropertyData props[] = {
    { "*FieldEditor*background",                     "#90ffa0" },
    { "*cursorFlashRate",                                  "0" },
    { "*NfcEditorFont*font", "*helvetica-medium-r-normal--12*" },
    { "*NfcInfoFont*font",     "*helvetica-bold-r-normal--12*" },
    { "*PushButton*font",          "*times-bold-r-normal--12*" },
    { "*LaengeStrecke",                                    "0" },
    { "*mitWinkel",                                       "on" },
    { "*mitWiGeschw",                                     "on" },
    { "*mitPosition",                                    "off" },
    { "*mitWaGeschw",                                    "off" },
    { "*englisch",                                       "off" },
    { nil }
};

static OptionDesc options[] = {
    { "editorfont=", "*NfcEditorFont", OptionValueAfter          },
    { "infofont=",   "*NfcInfoFont",   OptionValueAfter          },
    { "buttonfont=", "*NfcButtonFont", OptionValueAfter          },
    { "-laenge=",    "*LaengeStrecke", OptionValueAfter          },
    { "-mWi",        "*mitWinkel",     OptionValueImplicit, "on" },
    { "-mWiG",       "*mitWiGeschw",   OptionValueImplicit, "on" },
    { "-mPo",        "*mitPosition",   OptionValueImplicit, "on" },
    { "-mWaG",       "*mitWaGeschw",   OptionValueImplicit, "on" },
    { "-e",          "*englisch",      OptionValueImplicit, "on" },
    { nil }
};

int main(int argc, char** argv)
{
  Session* session = new Session("pendel", argc, argv, options, props);
  WidgetKit* wkit  = WidgetKit::instance();
  Style* style     = wkit->style();

  // Setzen der Sprache
  if(style->value_is_on("englisch"))
    init_texte_englisch();
  else
    init_texte_deutsch();

  style->attribute("name", Txt(30));

  session->run_window(
    new ApplicationWindow(
      new Background(new PendelFenster(style), wkit->background())
    )
  );
}
