function [set]=outdef(inset)

%OUTDEF
%         [SET]=OUTDEF(INSET)
%         OUTDEF is a tool to design output-variables of a fuzzy-control
%         system.
%         OUTDEF returns a matrix SET, which contains the names of
%         the newly designed fuzzy variables (i.e. the input-, the 
%         output-variables and the abbreviations of them).
%         INSET is a corresponding matrix, which contains the in-
%         put-variables.
%
%         Note: 
%         Only a variable of type SET can be displayed using SHOWSET,
%         and only the function OUTDEF can return such types.
%		
%         See also INDEF, CORRECT.

% Stephan Molt 01-09-93

[zz1,ss1]=size(inset);
% pruefen der eingangsgroessen: sind sie vom richtigen typ ?
% check type of input parameters
if(ss1~=24)
   error('argument must be of type INSET');
end


if(nargin~=1)
    error('wrong number of arguments - OUTDEF requires one argument');
end

[nin,void]=size(inset);
nins=zeros(1,20);
nins(1)=nin;
nins=setstr(nins);

% wie bei INDEF muss festgestellt werden, um welchen computer es sich handelt
% wegen ascii-zeichensatz (Check computer type
clc;
TYP=computer;
TYP=TYP(1,1:2);

if(TYP=='PC')
   load c:\matlab\fuzzy\fuzzy2;
else
   a=' ';
   b='FUZZY-DESIGN: Output-Variables';
   c=' ';
end;

% aufbauen der bildschirmmaske
disp(a);
disp(b);
disp(c);
leer=' ';
disp(leer)
k=input('Number of output-variables ');
disp(leer);
disp(leer);
txt1='Okay, so you have designed ';
txt2=num2str(k);
txt3=' output-variable(s). Let';
txt4=setstr(39);
txt5='s start now.';
txt=[txt1,txt2,txt3,txt4,txt5];
disp(txt);
disp(leer);

disp('Please input the name of the output-variable and then the abbreviation of it');

name=['Name of Variables:  '];
abb= ['Abb.'];

name=zeros(k,20);
abb=zeros(k,4);

% eingabe der namen und abkuerzungen
for i=1:1:k
	j=num2str(i);
	txt='. Name ';
	txt=[j,txt];
	s1=input(txt,'s');
	[void,len]=size(s1);
	if (~(len==20))
             s1=[s1,zeros(1,20-len)];
	end
	txt=['Abbreviation of ',j,'. Variable '];
	s2=input(txt,'s');
	[void,len]=size(s2);

	if(~(len==4))
	    s2=[s2,zeros(1,4-len)];
	end
	name(i,1:20)=s1;
	abb(i,1:4)=s2;	
end

out=[name,abb];
fill=setstr(zeros(1,24));

[nout,void]=size(out);
nouts=zeros(1,4);
nouts(1)=nout;
nouts=setstr(nouts);


%verbinden von inset und out
if(nin~=nout)
  if(nin>nout)
    for i=1:1:nin-nout
       out=[out;fill];
    end
  else
    for i=1:1:nout-nin
       out=[out;fill];
    end
  end
end

% 'berechnen' der rueckgabematrix
% compute outputmatrix
set=[nins,nouts,nins,nouts;inset,out];


return


%------------------------------------------------------------------------------
%  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any non-commercial purpose without fee is hereby granted,
%  provided that the above copyright notice appears in all copies and that
%  both that copyright notice and this permission notice appear in
%  supporting documentation.
% 
%  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
%  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
%  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
%  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
%  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
%  SOFTWARE.
%---------------------------------------------------------------------------
%  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE
