function [reg]=makerule3(rule,set,setdesc,nr)

%MAKERULE3
%         this function is called by EDITRULE and SHOWRULE

% Stephan Molt 01-09-93

[zz1,ss1]=size(set);
% makerule3 wird von editrule aufgerufen und von showrule
hold off;


n_in=abs(set(1,1));
n_out=abs(set(1,21));


axis('off');



axis([0 1 0 1]);
txt=['Nr of Rule',num2str(nr)];
text(0.,1.0,txt)
text(0,0.95,'INPUT-VARIABLES');
i=1;
string=[];


% regel wird dargestellt; der rest ist wie bei makerule2
for t=1:n_in
  setstr(string);
  string=['ruledef(',num2str(i),')'];
  txt=set(t+1,1:24);
  text(0 ,0.93-0.06*t,txt);
  
  lingvar=lingus(setdesc(t,1));
  element=rule(t,1);
  % element gibt an, welchen wert die regelmatrix an dieser stelle hat
  if element==0
     string2='ANY';
  else
     string2=lingvar(element,1:3);
  end
 
  
  h(t)=text(0.3,0.93-0.06*t,string2);
  handle(i)=uicontrol('style','pushbutton','string','+',...
                    'position',[0.43 0.85-0.05*t 0.03 0.04],...
                     'units','normalized',...
                     'callback',string);
  string=['ruledef(',num2str(i+1),')'];
  handle(i+1)=uicontrol('style','pushbutton','string','-',...
                     'position',[0.47 0.85-0.05*t 0.03 0.04],...
                      'units','normalized',...
                      'callback',string);
   i=i+2;                 
end

text(0.57 ,0.95,'OUTPUT-VARIABLES');

for t=1:n_out
  text2=set(t+1,25:44);
  text(0.57 ,0.93-0.06*t,text2);
  string=['ruledef(',num2str(i),')'];

  lingvar=lingus(setdesc(t,4));
  element=rule(t,2);
  if element==0
     string2='ANY';
  else
     string2=lingvar(element,1:3);
  end
  
  h(n_in+t)=text(0.85,0.93-0.06*t,string2);
  handle(i)=uicontrol('style','pushbutton','string','+',...
                    'position',[0.86 0.85-0.05*t 0.03 0.04],...
                     'units','normalized',...
                      'callback',string);
  string=['ruledef(',num2str(i+1),')'];
  handle(i+1)=uicontrol('style','pushbutton','string','-',...
                     'position',[0.90 0.85-0.05*t 0.03 0.04],...
                      'units','normalized',...
                       'callback',string);
   i=i+2;                 
end

% hier def. von safety
c__s=rule(1,3);
string2=['SAFETY ',num2str(c__s)];
saf=text(0.85,0.1,string2);

safepl=uicontrol('style','pushbutton','string','+',...
                    'position',[0.86 0.1 0.03 0.04],...
                     'units','normalized',...
                      'callback','safety(1)');
safemin=uicontrol('style','pushbutton','string','-',...
                     'position',[0.9 0.1 0.03 0.04],...
                      'units','normalized',...
                       'callback','safety(2)');

save f__safe saf c__s;

save f__temp h n_in rule setdesc nr;


string='exit_button1;';
hexit=uicontrol('style','pushbutton','string','OK',...
                     'position',[0.1 0.1 0.1 0.05],...
                      'units','normalized',...
                       'callback',string);

drawnow;


return

%------------------------------------------------------------------------------
%  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any non-commercial purpose without fee is hereby granted,
%  provided that the above copyright notice appears in all copies and that
%  both that copyright notice and this permission notice appear in
%  supporting documentation.
% 
%  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
%  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
%  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
%  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
%  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
%  SOFTWARE.
%---------------------------------------------------------------------------
%  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE
