/*--------------------------------------------------------------------------
 *  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
 *
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any non-commercial purpose without fee is hereby granted,
 *  provided that the above copyright notice appears in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation.
 *
 *  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 *  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 *  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 *  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 *  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 *  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 *  SOFTWARE.
 *---------------------------------------------------------------------------
 *  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE                         
 *--------------------------------------------------------------------------
 */




#include<math.h>
#include"cmex.h"

#define IN1 prhs[0] /* IN1 ist nin */
#define IN2 prhs[1] /* IN2 ist max_spalte der rckgabematrix*/
#define IN3 prhs[2] /* IN3 ist die matrix setdesc*/
#define IN4 prhs[3] /* mewert-matrix, gleiche reihenfolge wie setdesc*/
#define IN5 prhs[4] /* default-wert, wenn auerhalb des bereiches */

#define OUT plhs[0]
#define betrag(a) ( (a>0) ? a : -a )

user_fcn(nlhs, plhs, nrhs, prhs)
  int nlhs, nrhs;
  Matrix *plhs[], *prhs[];

{

float fi,fein,faus,x0,st,h0,a,aus,fl,fr;
float fanz1,fanz2,N,M,alpha,beta;
float mu[9];
float Ls,Rs,w,L,R;

/* x0 - arbeitspunkt
   st - start des sets
   h0 - normierte schrittweite
   a  - gesamtes intervall der gre
   w - wert des fuzzy-eingangs
   fl,fr - linker und rechter rand dieser zahl
   sd_zeil - zeilenzahl von setdesc
   nin - zahl der eingangsgren
   sections - max zahl der sections -> spaltenzahl der rckgabematrix

   Ls=L*, Rs=R*, linker und rechter Rand der Fuzzy-Zahlen
   treffer - zahl der treffer bei der analyse; PS,PM -> 2 Treffer

   def=1: wenn auerhalb, dann maximalen wert nehmen
   def=0: wenn auerhalb, dann kein treffer
*/ 

int sd_zeil,ein,anz1,anz2,nin,treffer,sections;
int pos[9];
int i,j,k;
int def;


nin=(IN1->pr)[0]; sections=(IN2->pr)[0];
def=(IN5->pr)[0];

OUT=create_matrix(nin,sections,REAL);
for(i=0;i<nin*sections;i++)
      (OUT->pr)[i]=0.0;

for(i=0;i<9;i++) mu[i]=0.0;
for(i=0;i<9;i++) pos[i]=0;


for(j=1;j<=nin;j++)
  {
/*
  vorsicht: indices i,j mssen auf eine zahl umgerechnet werden
  ist z die zeile und s die spalte (z,s), ergibt sich der index zu
  (s-1)*zmax+z-1; dabei ist zmax die anzahl der zeilen
*/

  sd_zeil=IN3->m;

/*  zeilenzahl sd und die der mematrix ist gleich */

  ein=(int)(IN3->pr)[j-1];
  fein=(float) ein;
  x0=(IN3->pr)[sd_zeil+j-1];
  a=(IN3->pr)[2*sd_zeil+j-1];

  w=(IN4->pr)[j-1];
  fl=w*(IN4->pr)[sd_zeil+j-1];
  fr=w*(IN4->pr)[2*sd_zeil+j-1];
  Ls=w-betrag(fl);
  Rs=w+betrag(fr);
  
  h0=a/fein;
  fanz1=fein-2.;
  fanz2=fein+1.;
  faus=2.0*fein-2.0;
  alpha=h0;
  beta=h0;
  st=x0-a;

  treffer=0;
			    
  /* test auf treffer bei nullpunkt */
  if( (Ls<(x0+beta)) && (Rs>(x0-alpha)) )
    {
    treffer++;
    pos[treffer]=(int) (fein+1.)/2.;
/*    mex_printf("\n Treffer NP in %d pos %d",j,pos[treffer]);  */
	
    if(w>=x0)
	{ mu[treffer]=(x0-w)/(beta+fl)+1.;
	  goto Aus3; }
    if(w<x0)
 	  mu[treffer]=(w-x0)/(fr+alpha)+1.;
	
    }
  Aus3:
  ;

  /* test auf treffer im vorderen, negativen bereich */      

       for(fi=1.;fi<=fanz1;fi+=2.)
	{
        if(fi<2.)
          {alpha=0;
	   N=st;}
        else
  	  {alpha=h0;
	   N=st+fi*h0;
          }
	  
	  M=st+(fi+1.)*h0;
                 
/*	mex_printf("\n L%f R%f L*%f R*%f",N-alpha,M+beta,Ls,Rs);  */
	if( (Ls<(M+beta)) && (Rs>(N-alpha)) )
	  {
	  treffer++;
	  pos[treffer]=(int) (fi+1.)/2.;
/*	  mex_printf("\n Tr neg in %d pos %d",j,pos[treffer]);  */
	  if(w>M)
	      { mu[treffer]=(M-w)/(beta+fl)+1.;
		goto Aus; }
	  if(w<N)
	       mu[treffer]=(w-N)/(fr+alpha)+1.;
	  else
	       mu[treffer]=1.0; 
	  }
	Aus:
	;
	}
	
	/* test auf treffer im hinteren, positiven bereich */
	for(fi=fanz2;fi<=faus;fi+=2.)
	{
        if(fi>faus-2.) 
           {beta=0;
            M=st+(fi+2.)*h0;
           }
        else
           {beta=h0;
            M=st+(fi+1.)*h0;
           } 
	N=st+fi*h0;
/*	mex_printf("\n L%f R%f L*%f R*%f",N-alpha,M+beta,Ls,Rs); */
	if( (Ls<(M+beta)) && (Rs>(N-alpha)) )
	  {
	  treffer++;
	  pos[treffer]=(int) (fi+2.)/2.;	
/*	  mex_printf("\n Tr posit in %d pos %d",j,pos[treffer]); */
	  if(w>M)
	      { mu[treffer]=(M-w)/(beta+fl)+1.;
		goto Aus2; }
	  if(w<N)
	       mu[treffer]=(w-N)/(fr+alpha)+1.;
	  else
	       mu[treffer]=1.0; 
	  }
	Aus2:
	;
	} /* ende i */

	/* wird def=1 gesetzt, und ist die gre des eingangs auerhalb
	   des sets, wird trotzdem ein treffer gegeben
           bsp.: x0=0; h/2=10; Ls=-15 liegt auerhalb; bei def=1 wird dann
	   zum beispiel NB als treffer gegeben */

	if(def==1)
	   {
	   if(Ls<st)
		{
		treffer++;
		pos[treffer]=1;
		mu[treffer]=1.0;
		}
	   if(Rs>x0+a)
		{
		treffer++;
		pos[treffer]=ein;
		mu[treffer]=1.0;
		}
	   }

	for(k=1;k<=treffer;k++)
	   {
	   (OUT->pr)[(pos[k]-1)*nin+j-1]=mu[k];
	   }   

  } /* ende j*/

return 0;
} /* hier endet user-fcn */
